/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.asn1.pkcs7;

import com.isnetworks.provider.asn1.Any;
import com.isnetworks.provider.asn1.AsnObject;
import com.isnetworks.provider.asn1.DecodeException;
import com.isnetworks.provider.asn1.DecodeListener;
import com.isnetworks.provider.asn1.Sequence;
import com.isnetworks.provider.asn1.TypeMapper;
import com.isnetworks.provider.asn1.pkcs7.ContentType;
import com.isnetworks.provider.asn1.pkcs7.Data;
import com.isnetworks.provider.asn1.pkcs7.EncryptedData;
import com.isnetworks.provider.asn1.pkcs7.Identifiers;
import com.isnetworks.provider.asn1.pkcs7.SignedData;

public class ContentInfo
extends Sequence {
    ContentType mContentType = new ContentType("contentType");
    Any mContent;
    TypeMapper mAuthenticatedTypeMapper;

    public ContentInfo() {
        this.addComponent(this.mContentType);
        this.mContent = new Any("content");
        this.mContent.setTag(128, 0, 2, true);
        this.addComponent(this.mContent);
        this.mContentType.addDecodeListener(new DecodeListener(){

            public void objectDecoded(AsnObject object) throws DecodeException {
                ContentInfo.this.determineContentType(object);
            }
        });
    }

    public ContentInfo(String identifier) {
        this();
        this.setIdentifier(identifier);
    }

    public void setAuthenticatedTypeMapper(TypeMapper mapper) {
        this.mAuthenticatedTypeMapper = mapper;
    }

    private void determineContentType(AsnObject object) throws DecodeException {
        Identifiers.touch();
        if (object.equals(Identifiers.data)) {
            this.mContent.setActual(new Data("data"));
        } else if (object.equals(Identifiers.signedData)) {
            SignedData signedData = new SignedData("signedData");
            signedData.setAuthenticatedTypeMapper(this.mAuthenticatedTypeMapper);
            this.mContent.setActual(signedData);
        } else if (object.equals(Identifiers.encryptedData)) {
            EncryptedData encryptedData = new EncryptedData("encryptedData");
            this.mContent.setActual(encryptedData);
        } else {
            throw new DecodeException("unimplemented pkcs7.ContentType " + object.toString());
        }
    }

    public ContentType getContentType() {
        return this.mContentType;
    }

    public Any getContent() {
        return this.mContent;
    }
}

