/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.asn1.pkcs12;

import com.isnetworks.provider.asn1.Any;
import com.isnetworks.provider.asn1.AsnObject;
import com.isnetworks.provider.asn1.DecodeException;
import com.isnetworks.provider.asn1.DecodeListener;
import com.isnetworks.provider.asn1.ObjectIdentifier;
import com.isnetworks.provider.asn1.Sequence;
import com.isnetworks.provider.asn1.SetOf;
import com.isnetworks.provider.asn1.pkcs12.CRLBag;
import com.isnetworks.provider.asn1.pkcs12.CertBag;
import com.isnetworks.provider.asn1.pkcs12.Identifiers;
import com.isnetworks.provider.asn1.pkcs12.KeyBag;
import com.isnetworks.provider.asn1.pkcs12.PKCS12Attribute;
import com.isnetworks.provider.asn1.pkcs12.PKCS8ShroudedKeyBag;
import com.isnetworks.provider.asn1.pkcs12.SafeContents;
import com.isnetworks.provider.asn1.pkcs12.SecretBag;

public class SafeBag
extends Sequence {
    private ObjectIdentifier mBagId = new ObjectIdentifier("bagId");
    private Any mBagValue;
    private SetOf mBagAttributes;
    static /* synthetic */ Class class$com$isnetworks$provider$asn1$pkcs12$PKCS12Attribute;

    public SafeBag() {
        this.addComponent(this.mBagId);
        this.mBagId.addDecodeListener(new DecodeListener(){

            public void objectDecoded(AsnObject object) throws DecodeException {
                SafeBag.this.determineContentType(object);
            }
        });
        this.mBagValue = new Any("bagValue");
        this.mBagValue.setTag(128, 0, 2, false);
        this.addComponent(this.mBagValue);
        this.mBagAttributes = new SetOf("bagAttributes");
        this.mBagAttributes.setOptional(true);
        this.mBagAttributes.setComponentClass(class$com$isnetworks$provider$asn1$pkcs12$PKCS12Attribute == null ? (class$com$isnetworks$provider$asn1$pkcs12$PKCS12Attribute = SafeBag.class$("com.isnetworks.provider.asn1.pkcs12.PKCS12Attribute")) : class$com$isnetworks$provider$asn1$pkcs12$PKCS12Attribute);
        this.addComponent(this.mBagAttributes);
    }

    public SafeBag(String name) {
        this();
        this.setIdentifier(name);
    }

    public ObjectIdentifier getBagId() {
        return this.mBagId;
    }

    public Any getBagValue() {
        return this.mBagValue;
    }

    public SetOf getBagAttributes() {
        return this.mBagAttributes;
    }

    private void determineContentType(AsnObject object) throws DecodeException {
        if (object.equals(Identifiers.keyBag)) {
            this.mBagValue.setActual(new KeyBag("keyBag"));
        } else if (object.equals(Identifiers.pkcs8ShroudedKeyBag)) {
            this.mBagValue.setActual(new PKCS8ShroudedKeyBag("pkcs8ShroudedKeyBag"));
        } else if (object.equals(Identifiers.certBag)) {
            this.mBagValue.setActual(new CertBag("certBag"));
        } else if (object.equals(Identifiers.crlBag)) {
            this.mBagValue.setActual(new CRLBag("crlBag"));
        } else if (object.equals(Identifiers.secretBag)) {
            this.mBagValue.setActual(new SecretBag("secretBag"));
        } else if (object.equals(Identifiers.safeContentsBag)) {
            this.mBagValue.setActual(new SafeContents("safeContents"));
        } else {
            throw new DecodeException("unimplemented SafeBag.BagId " + object.toString());
        }
    }

    public void addAttribute(ObjectIdentifier oid, AsnObject value) {
        PKCS12Attribute attribute = new PKCS12Attribute("attribute");
        attribute.getAttrId().copy(oid);
        attribute.getAttrValues().setComponentClass(value.getClass());
        attribute.getAttrValues().addComponent(value);
        this.getBagAttributes().addComponent(attribute);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

