/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.asn1.pkcs12;

import com.isnetworks.provider.asn1.AsnInteger;
import com.isnetworks.provider.asn1.DecodeException;
import com.isnetworks.provider.asn1.Sequence;
import com.isnetworks.provider.asn1.pkcs12.AuthenticatedSafe;
import com.isnetworks.provider.asn1.pkcs12.MacData;
import com.isnetworks.provider.asn1.pkcs7.ContentInfo;
import com.isnetworks.provider.asn1.pkcs7.Data;
import com.isnetworks.provider.asn1.pkcs7.Identifiers;
import com.isnetworks.provider.asn1.pkcs7.SignedData;
import java.math.BigInteger;

public class PFX
extends Sequence {
    public static final BigInteger V3 = new BigInteger("3");
    private AsnInteger mVersion = new AsnInteger("version");
    private ContentInfo mAuthSafe;
    private MacData mMacData;

    public PFX() {
        this.mVersion.setDefaultValue(V3);
        this.addComponent(this.mVersion);
        this.mAuthSafe = new ContentInfo("authSafe");
        this.addComponent(this.mAuthSafe);
        this.mMacData = new MacData("macData");
        this.mMacData.setOptional(true);
        this.addComponent(this.mMacData);
    }

    public PFX(String name) {
        this();
        this.setIdentifier(name);
    }

    public AsnInteger getVersion() {
        return this.mVersion;
    }

    public ContentInfo getAuthSafe() {
        return this.mAuthSafe;
    }

    public MacData getMacData() {
        return this.mMacData;
    }

    public AuthenticatedSafe getAuthenticatedSafe() throws DecodeException {
        if (this.getAuthSafe().getContentType().equals(Identifiers.data)) {
            byte[] safeBytes = (byte[])((Data)this.getAuthSafe().getContent().getActual()).getValue();
            AuthenticatedSafe safe = new AuthenticatedSafe("authenticatedSafe");
            if (safeBytes != null) {
                safe.decode(safeBytes);
            }
            return safe;
        }
        if (this.getAuthSafe().getContentType().equals(Identifiers.signedData)) {
            SignedData signed = (SignedData)this.getAuthSafe().getContent().getActual();
            byte[] safeBytes = (byte[])((Data)signed.getContentInfo().getContent().getActual()).getValue();
            AuthenticatedSafe safe = new AuthenticatedSafe("authenticatedSafe");
            if (safeBytes != null) {
                safe.decode(safeBytes);
            }
            return safe;
        }
        throw new DecodeException("Unsupported AuthenticatedSafe type");
    }
}

