/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.asn1.pkcs12;

import com.isnetworks.provider.asn1.Any;
import com.isnetworks.provider.asn1.AsnObject;
import com.isnetworks.provider.asn1.DecodeException;
import com.isnetworks.provider.asn1.DecodeListener;
import com.isnetworks.provider.asn1.IA5String;
import com.isnetworks.provider.asn1.ObjectIdentifier;
import com.isnetworks.provider.asn1.OctetString;
import com.isnetworks.provider.asn1.Sequence;
import com.isnetworks.provider.asn1.pkcs12.Identifiers;

public class CertBag
extends Sequence {
    private ObjectIdentifier mCertId = new ObjectIdentifier("certId");
    private Any mCertValue;

    public CertBag() {
        this.mCertId.addDecodeListener(new DecodeListener(){

            public void objectDecoded(AsnObject object) throws DecodeException {
                CertBag.this.determineContentType(object);
            }
        });
        this.addComponent(this.mCertId);
        this.mCertValue = new Any("certValue");
        this.mCertValue.setTag(128, 0, 2, false);
        this.addComponent(this.mCertValue);
    }

    public CertBag(String name) {
        this();
        this.setIdentifier(name);
    }

    public ObjectIdentifier getCertId() {
        return this.mCertId;
    }

    public Any getCertValue() {
        return this.mCertValue;
    }

    private void determineContentType(AsnObject object) throws DecodeException {
        if (object.equals(Identifiers.x509Certificate)) {
            this.mCertValue.setActual(new OctetString("certValue"));
        } else if (object.equals(Identifiers.sdsiCertificate)) {
            this.mCertValue.setActual(new IA5String("certValue"));
        } else {
            throw new DecodeException("unimplemented CertBag.CertId " + object.toString());
        }
    }
}

