/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.asn1.pkcs12;

import com.isnetworks.provider.asn1.Any;
import com.isnetworks.provider.asn1.AsnObject;
import com.isnetworks.provider.asn1.DecodeException;
import com.isnetworks.provider.asn1.DecodeListener;
import com.isnetworks.provider.asn1.ObjectIdentifier;
import com.isnetworks.provider.asn1.OctetString;
import com.isnetworks.provider.asn1.Sequence;
import com.isnetworks.provider.asn1.pkcs12.Identifiers;

public class CRLBag
extends Sequence {
    private ObjectIdentifier mCrlId = new ObjectIdentifier("crlId");
    private Any mCrlValue;

    public CRLBag() {
        this.mCrlId.addDecodeListener(new DecodeListener(){

            public void objectDecoded(AsnObject object) throws DecodeException {
                CRLBag.this.determineContentType(object);
            }
        });
        this.addComponent(this.mCrlId);
        this.mCrlValue = new Any("crlValue");
        this.mCrlValue.setTag(128, 0, 2, false);
        this.addComponent(this.mCrlValue);
    }

    public CRLBag(String name) {
        this();
        this.setIdentifier(name);
    }

    public ObjectIdentifier getCrlId() {
        return this.mCrlId;
    }

    public Any getCrlValue() {
        return this.mCrlValue;
    }

    private void determineContentType(AsnObject object) throws DecodeException {
        if (!object.equals(Identifiers.x509CRL)) {
            throw new DecodeException("unimplemented CertBag.CertId " + object.toString());
        }
        this.mCrlValue.setActual(new OctetString("crlValue"));
    }
}

