/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.asn1.pem2;

import com.isnetworks.provider.asn1.AsnObject;
import com.isnetworks.provider.asn1.ObjectIdentifier;
import com.isnetworks.provider.asn1.Sequence;
import com.isnetworks.provider.asn1.SequenceOf;
import com.isnetworks.provider.asn1.UTCTime;
import com.isnetworks.provider.asn1.pem2.CRLEntry;
import com.isnetworks.provider.asn1.x509.AlgorithmIdentifier;
import com.isnetworks.provider.asn1.x509.Name;
import com.isnetworks.provider.asn1.x509.SIGNED;

public class CertificateRevocationList
extends SIGNED {
    public CertificateRevocationList() {
        this.setToBeSigned(new ToBeSigned("tbs"));
    }

    public CertificateRevocationList(String identifier) {
        this();
        this.setIdentifier(identifier);
    }

    public void setAlgorithmIdentifierValues(ObjectIdentifier algid, AsnObject params) {
        super.setAlgorithmIdentifierValues(algid, params);
        this.getToBeSignedSignature().getAlgorithm().copy(algid);
        this.getToBeSignedSignature().getParameters().setActual(params);
    }

    public AlgorithmIdentifier getToBeSignedSignature() {
        return ((ToBeSigned)this.getToBeSigned()).getSignature();
    }

    public Name getIssuer() {
        return ((ToBeSigned)this.getToBeSigned()).getIssuer();
    }

    public UTCTime getLastUpdate() {
        return ((ToBeSigned)this.getToBeSigned()).getLastUpdate();
    }

    public UTCTime getNextUpdate() {
        return ((ToBeSigned)this.getToBeSigned()).getNextUpdate();
    }

    public SequenceOf getRevokedCertificates() {
        return ((ToBeSigned)this.getToBeSigned()).getRevokedCertificates();
    }

    public void addCRLEntry(CRLEntry crlEntry) {
        this.getRevokedCertificates().addComponent(crlEntry);
    }

    class ToBeSigned
    extends Sequence {
        private AlgorithmIdentifier mSignature = new AlgorithmIdentifier("signature");
        private Name mIssuer;
        private UTCTime mLastUpdate;
        private UTCTime mNextUpdate;
        private SequenceOf mRevokedCertificates;
        static /* synthetic */ Class class$com$isnetworks$provider$asn1$pem2$CRLEntry;

        public ToBeSigned() {
            this.addComponent(this.mSignature);
            this.mIssuer = new Name("issuer");
            this.addComponent(this.mIssuer);
            this.mLastUpdate = new UTCTime("lastUpdate");
            this.addComponent(this.mLastUpdate);
            this.mNextUpdate = new UTCTime("nextUpdate");
            this.addComponent(this.mNextUpdate);
            this.mRevokedCertificates = new SequenceOf("revokedCertificates");
            this.mRevokedCertificates.setComponentClass(class$com$isnetworks$provider$asn1$pem2$CRLEntry == null ? (class$com$isnetworks$provider$asn1$pem2$CRLEntry = ToBeSigned.class$("com.isnetworks.provider.asn1.pem2.CRLEntry")) : class$com$isnetworks$provider$asn1$pem2$CRLEntry);
            this.mRevokedCertificates.setOptional(true);
            this.addComponent(this.mRevokedCertificates);
        }

        public ToBeSigned(String identifier) {
            this();
            this.setIdentifier(identifier);
        }

        public AlgorithmIdentifier getSignature() {
            return this.mSignature;
        }

        public Name getIssuer() {
            return this.mIssuer;
        }

        public UTCTime getLastUpdate() {
            return this.mLastUpdate;
        }

        public UTCTime getNextUpdate() {
            return this.mNextUpdate;
        }

        public SequenceOf getRevokedCertificates() {
            return this.mRevokedCertificates;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

