/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.asn1;

import com.isnetworks.provider.asn1.AbstractPrimitiveObject;
import java.util.StringTokenizer;
import java.util.Vector;

public class ObjectIdentifier
extends AbstractPrimitiveObject {
    private long[] mValue;
    private long[] mDefaultValue;
    private static int exp2 = (int)Math.pow(128.0, 2.0);
    private static int exp3 = (int)Math.pow(128.0, 3.0);
    private static int[] mults = new int[]{1, 128, exp2, exp3};
    static /* synthetic */ Class class$com$isnetworks$provider$asn1$ObjectIdentifier;

    public ObjectIdentifier() {
        this.setType(6);
    }

    public ObjectIdentifier(String identifier) {
        this();
        this.setIdentifier(identifier);
    }

    protected Class getCopyableClass() {
        return class$com$isnetworks$provider$asn1$ObjectIdentifier == null ? (class$com$isnetworks$provider$asn1$ObjectIdentifier = ObjectIdentifier.class$("com.isnetworks.provider.asn1.ObjectIdentifier")) : class$com$isnetworks$provider$asn1$ObjectIdentifier;
    }

    public Object getValue() {
        this.evaluate();
        return this.mValue;
    }

    public void setValue(ObjectIdentifier rhs) {
        this.setValue(rhs.mValue);
    }

    public void setValue(String stringValue) {
        this.setValue(this.makeValue(stringValue));
    }

    public void setValue(Object value) {
        this.mValue = (long[])value;
    }

    public void setValue(ObjectIdentifier base, String stringSuffix) {
        this.setValue((long[])this.arraycat(base.mValue, this.makeValue(stringSuffix)));
    }

    public Object getDefaultValue() {
        return this.mDefaultValue;
    }

    public void setDefaultValue(Object value) {
        this.mDefaultValue = (long[])value;
    }

    public boolean isDefaultValue() {
        this.evaluate();
        if (this.mValue == null) {
            return true;
        }
        return this.mValue.equals(this.mDefaultValue);
    }

    public long[] makeValue(String stringValue) {
        Vector<Long> vectorValue = new Vector<Long>();
        StringTokenizer st = new StringTokenizer(stringValue, ".", false);
        while (st.hasMoreElements()) {
            vectorValue.addElement(new Long(st.nextToken()));
        }
        long[] arrayValue = new long[vectorValue.size()];
        int k = 0;
        while (k < vectorValue.size()) {
            arrayValue[k] = (Long)vectorValue.elementAt(k);
            ++k;
        }
        return arrayValue;
    }

    public String toString() {
        this.getValue();
        if (this.mValue != null) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.mValue[0]);
            int k = 1;
            while (k < this.mValue.length) {
                sb.append('.');
                sb.append(this.mValue[k]);
                ++k;
            }
            return sb.toString();
        }
        return null;
    }

    public int hashCode() {
        long[] value = (long[])this.getValue();
        if (value == null) {
            return super.hashCode();
        }
        long hash = value.length;
        int i = 0;
        while (i < value.length) {
            hash += value[i];
            ++i;
        }
        return (int)hash;
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        if (!(rhs instanceof ObjectIdentifier)) {
            return false;
        }
        long[] lhsValue = (long[])this.getValue();
        long[] rhsValue = (long[])((ObjectIdentifier)rhs).getValue();
        if (lhsValue == null) {
            return rhsValue == null;
        }
        if (lhsValue.length != rhsValue.length) {
            return false;
        }
        int i = 0;
        while (i < lhsValue.length) {
            if (lhsValue[i] != rhsValue[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void evaluate() {
        if (this.mDecodeTag != null && this.mValue == null) {
            byte[] octets = this.mDecodeTag.getEncodedContents();
            int valueX = 0;
            Vector<Integer> values = new Vector<Integer>();
            valueX = octets[0] / 40;
            values.addElement(new Integer(valueX));
            valueX = octets[0] % 40;
            values.addElement(new Integer(valueX));
            int i = 1;
            while (i < octets.length) {
                valueX = 0;
                int numBytes = 1;
                if ((octets[i] & 0x80) != 0) {
                    while ((octets[i + numBytes] & 0x80) != 0) {
                        ++numBytes;
                    }
                    ++numBytes;
                }
                int j = 0;
                while (j < numBytes) {
                    int exponent = numBytes - j - 1;
                    int multiplier = mults[exponent];
                    int k = octets[i + j] & 0x7F;
                    valueX += multiplier * k;
                    ++j;
                }
                values.addElement(new Integer(valueX));
                i += numBytes;
            }
            this.mValue = new long[values.size()];
            int i2 = 0;
            while (i2 < values.size()) {
                this.mValue[i2] = ((Integer)values.elementAt(i2)).longValue();
                ++i2;
            }
        }
    }

    protected byte[] makeContentsOctets() {
        Vector<byte[]> bytes = new Vector<byte[]>();
        byte[] ba = new byte[]{(byte)(this.mValue[0] * 40L + this.mValue[1])};
        bytes.addElement(ba);
        int cl = 1;
        int i = 2;
        while (i < this.mValue.length) {
            int num = (int)this.mValue[i];
            int l = 1;
            if (num / mults[3] > 0) {
                l = 4;
            } else if (num / mults[2] > 0) {
                l = 3;
            } else if (num / mults[1] > 0) {
                l = 2;
            }
            ba = new byte[l];
            int j = 0;
            while (j < l) {
                int k = l - j - 1;
                ba[j] = (byte)(num / mults[k]);
                num -= ba[j] * mults[k];
                if (j < l - 1) {
                    ba[j] = (byte)(ba[j] | 0xFFFFFF80);
                }
                ++j;
            }
            bytes.addElement(ba);
            cl += l;
            ++i;
        }
        byte[] contents = new byte[cl];
        int j = 0;
        int i2 = 0;
        while (i2 < bytes.size()) {
            ba = (byte[])bytes.elementAt(i2);
            System.arraycopy(ba, 0, contents, j, ba.length);
            j += ba.length;
            ++i2;
        }
        return contents;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

