/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.asn1;

import com.isnetworks.provider.asn1.DecodeStream;

public class DecodeTag {
    private byte[] mOctets;
    private int mOffset;
    private int mTagClass;
    private int mIdentifier;
    private int mTagLength;
    private int mContentLength;

    public DecodeTag() {
    }

    public DecodeTag(DecodeStream stream) {
        this.decode(stream);
    }

    public void decode(DecodeStream stream) {
        this.mOctets = stream.getBytes();
        this.mOffset = stream.getPosition();
        this.mIdentifier = stream.read();
        if (this.getTagNumber() == 31) {
            throw new UnsupportedOperationException("high-tag-number form (tag number > 30) not implemented.");
        }
        int length = stream.read();
        if ((length & 0x80) == 0) {
            boolean count = false;
            this.mContentLength = length & 0x7F;
        } else {
            int count = length & 0x7F;
            if (count == 0) {
                this.mContentLength = -1;
            } else if (count <= 4) {
                this.mContentLength = 0;
                int k = 0;
                while (k < count) {
                    this.mContentLength = this.mContentLength << 8 | stream.read() & 0xFF;
                    ++k;
                }
            } else {
                throw new UnsupportedOperationException("more than four length octets not supported.");
            }
        }
        this.mTagLength = stream.getPosition() - this.mOffset;
    }

    public byte[] getEncodedObject() {
        byte[] octets = new byte[this.mTagLength + this.mContentLength];
        System.arraycopy(this.mOctets, this.mOffset, octets, 0, octets.length);
        return octets;
    }

    public byte[] getEncodedContents() {
        byte[] octets = new byte[this.mContentLength];
        System.arraycopy(this.mOctets, this.getContentOffset(), octets, 0, octets.length);
        return octets;
    }

    public byte[] getOctets() {
        return this.mOctets;
    }

    public int getTagOffset() {
        return this.mOffset;
    }

    public int getContentOffset() {
        return this.mOffset + this.mTagLength;
    }

    public int getContentLength() {
        return this.mContentLength;
    }

    public void markContentEnd(DecodeStream stream) {
        if (this.mContentLength < 0) {
            this.mContentLength = stream.getPosition() - this.getContentOffset();
        }
    }

    public boolean isConstructed() {
        return (this.mIdentifier & 0x20) == 32;
    }

    public boolean isDefiniteLength() {
        return this.mContentLength >= 0;
    }

    public boolean isEndOfContents() {
        return this.mIdentifier == 0 && this.mContentLength == 0;
    }

    public int getTagClass() {
        return this.mIdentifier & 0xC0;
    }

    public int getTagNumber() {
        return this.mIdentifier & 0x1F;
    }

    public int getTagLength() {
        return this.mTagLength;
    }
}

