/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.asn1;

import com.isnetworks.provider.asn1.AbstractAsnObject;
import com.isnetworks.provider.asn1.AbstractStructuredObject;
import com.isnetworks.provider.asn1.AsnObject;
import com.isnetworks.provider.asn1.DecodeException;
import com.isnetworks.provider.asn1.DecodeStream;
import com.isnetworks.provider.asn1.DecodeTag;
import com.isnetworks.provider.asn1.EncodeException;

public class Choice
extends AbstractStructuredObject {
    private AsnObject mActual;
    static /* synthetic */ Class class$com$isnetworks$provider$asn1$Choice;

    public Choice() {
        this.setType(-1);
    }

    public Choice(String identifier) {
        this();
        this.setIdentifier(identifier);
    }

    public boolean equals(Object rhs) {
        if (rhs instanceof Choice) {
            Choice rhsChoice = (Choice)rhs;
            AsnObject actual = this.getActual();
            AsnObject rhsActual = rhsChoice.getActual();
            if (actual == null) {
                return rhsActual == null;
            }
            return actual.equals(rhsActual);
        }
        return false;
    }

    public void copy(AsnObject rhs) {
        super.copy(rhs);
        Choice choice = (Choice)rhs;
        int index = choice.indexOf(choice.getActual());
        if (index >= 0) {
            this.setActual(this.getComponent(index));
        } else {
            this.setActual(null);
        }
    }

    protected Class getCopyableClass() {
        return class$com$isnetworks$provider$asn1$Choice == null ? (class$com$isnetworks$provider$asn1$Choice = Choice.class$("com.isnetworks.provider.asn1.Choice")) : class$com$isnetworks$provider$asn1$Choice;
    }

    public AsnObject getActual() {
        return this.mActual;
    }

    public void setActual(AsnObject actual) {
        this.mActual = actual;
    }

    public Object getValue() {
        return this.mActual == null ? null : this.mActual.getValue();
    }

    public void setValue(Object value) {
        if (this.mActual == null) {
            throw new IllegalStateException("cannot setValue() without setActual()");
        }
        this.mActual.setValue(value);
    }

    public boolean isDefaultValue() {
        return this.mActual == null ? true : this.mActual.isDefaultValue();
    }

    public String toString() {
        return this.mActual == null ? null : this.mActual.toString();
    }

    public boolean matchTag(DecodeTag tag) {
        int i = 0;
        while (i < this.getComponentCount()) {
            AsnObject component = this.getComponent(i);
            if (component.matchTag(tag)) {
                this.mActual = component;
                return true;
            }
            ++i;
        }
        return false;
    }

    public byte[] encode() throws EncodeException {
        AbstractAsnObject.trace(this.getIdentifier() + " CHOICE");
        AbstractAsnObject.indent();
        byte[] octets = this.mActual.encode();
        if (this.mActual.getTagMethod() == 2) {
            byte[] identOctets = this.makeIdentifierOctets(this.mActual.getTagClass(), 32, this.mActual.getTagNumber());
            byte[] lengthOctets = this.makeLengthOctets(octets.length);
            byte[] tagOctets = (byte[])this.arraycat(identOctets, lengthOctets);
            octets = (byte[])this.arraycat(tagOctets, octets);
        }
        AbstractAsnObject.outdent();
        return octets;
    }

    protected byte[] makeContentsOctets() {
        throw new UnsupportedOperationException("Choice.makeContentsOctets()");
    }

    public void decode(DecodeStream stream) throws DecodeException {
        AbstractAsnObject.trace(this.getIdentifier() + " CHOICE");
        AbstractAsnObject.indent();
        stream.mark(0);
        DecodeTag tag = new DecodeTag(stream);
        stream.reset();
        this.mActual = null;
        int i = 0;
        while (i < this.getComponentCount()) {
            AsnObject component = this.getComponent(i);
            if (component.getTagNumber() == tag.getTagNumber()) {
                this.mActual = component;
                break;
            }
            ++i;
        }
        if (this.mActual == null) {
            throw new DecodeException(this.getIdentifier() + " (CHOICE): data doesn't match valid choices.");
        }
        if (this.mActual.getTagMethod() == 2) {
            stream.skip(tag.getTagLength());
        }
        this.mActual.decode(stream);
        AbstractAsnObject.outdent();
    }

    protected void decodeContentsConstructed(DecodeStream stream, int end) throws DecodeException {
        throw new UnsupportedOperationException("Choice.decodeContentsOctets()");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

