/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.asn1;

import com.isnetworks.provider.asn1.AbstractDataString;

public class BitString
extends AbstractDataString {
    public BitString() {
        this.setType(3);
    }

    public BitString(String identifier) {
        this();
        this.setIdentifier(identifier);
    }

    protected boolean getBit(int bitIndex) {
        int bitMask;
        int byteIndex;
        byte[] octets = (byte[])this.getValue();
        byte currentOctet = octets[byteIndex = bitIndex / 8];
        return (currentOctet & (bitMask = 128 >> bitIndex % 8)) != 0;
    }

    public void setBit(int bitIndex, boolean b) {
        this.checkArraySize(bitIndex);
        byte[] octets = (byte[])this.getValue();
        int byteIndex = bitIndex / 8;
        byte currentOctet = octets[byteIndex];
        int bitMask = 128 >> bitIndex % 8;
        octets[byteIndex] = b ? (byte)(currentOctet | bitMask) : (byte)(currentOctet & ~bitMask);
    }

    private void checkArraySize(int bitIndex) {
        byte[] value = (byte[])this.getValue();
        int minByteCount = bitIndex / 8 + 1;
        if (value == null || value.length < minByteCount) {
            byte[] newValue = new byte[minByteCount];
            if (value != null) {
                System.arraycopy(value, 0, newValue, 0, value.length);
            }
            this.setValue(newValue);
        }
    }

    protected byte[] makeContentsOctets() {
        byte[] value = (byte[])this.getValue();
        byte[] octets = new byte[value.length + 1];
        octets[0] = 0;
        System.arraycopy(this.getValue(), 0, octets, 1, value.length);
        return octets;
    }

    protected byte[] decodePrimitive() {
        byte[] src = this.mDecodeTag.getOctets();
        int contentOffset = this.mDecodeTag.getContentOffset();
        int srcOffset = contentOffset + 1;
        int length = this.mDecodeTag.getContentLength() - 1;
        byte[] dest = new byte[length];
        System.arraycopy(src, srcOffset, dest, 0, length);
        return dest;
    }

    public int getBitCount() {
        byte[] value = (byte[])this.getValue();
        return value == null ? 0 : value.length * 8;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        boolean spacer = true;
        byte[] octets = (byte[])this.getValue();
        if (octets == null) {
            sb.append("null");
        } else {
            sb.append("[");
            sb.append(this.getBitCount());
            sb.append(" bits] ");
            int k = 0;
            while (k < octets.length) {
                int i = octets[k];
                if (i < 0) {
                    i += 256;
                }
                if (spacer) {
                    sb.append(' ');
                }
                spacer = !spacer;
                String hex = Integer.toHexString(i);
                if (hex.length() == 1) {
                    sb.append('0');
                }
                sb.append(hex);
                ++k;
            }
        }
        return sb.toString();
    }
}

