/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.asn1;

import com.isnetworks.provider.asn1.AbstractAsnObject;
import com.isnetworks.provider.asn1.AbstractConstructedObject;
import com.isnetworks.provider.asn1.AsnObject;
import com.isnetworks.provider.asn1.DecodeException;
import com.isnetworks.provider.asn1.DecodeStream;
import com.isnetworks.provider.asn1.DecodeTag;
import com.isnetworks.provider.asn1.EncodeException;
import java.util.Vector;

public abstract class AbstractStructuredObject
extends AbstractConstructedObject {
    public String toString() {
        return this.getComponentCount() + " components";
    }

    public Object getValue() {
        try {
            throw new Exception();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UnsupportedOperationException("cannot getValue() on a structured type.");
        }
    }

    public void setValue(Object value) {
        throw new UnsupportedOperationException("cannot setValue() on a structured type.");
    }

    public Object getDefaultValue() {
        throw new UnsupportedOperationException("cannot getDefaultValue() on a structured type.");
    }

    public void setDefaultValue(Object value) {
        throw new UnsupportedOperationException("cannot setDefaultValue() on a structured type.");
    }

    public boolean equals(Object rhs) {
        if (this.getCopyableClass().isInstance(rhs)) {
            AbstractStructuredObject rhsStructured = (AbstractStructuredObject)rhs;
            if (this.getComponentCount() == rhsStructured.getComponentCount()) {
                int i = 0;
                while (i < this.getComponentCount()) {
                    if (!this.getComponent(i).equals(rhsStructured.getComponent(i))) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }

    public void copy(AsnObject rhs) {
        if (this.getCopyableClass().isInstance(rhs)) {
            AbstractStructuredObject rhsStructured = (AbstractStructuredObject)rhs;
            int i = 0;
            while (i < rhsStructured.getComponentCount()) {
                this.getComponent(i).copy(rhsStructured.getComponent(i));
                ++i;
            }
        }
    }

    public void copy(AsnObject rhs, Class componentClass) {
        if (this.getCopyableClass().isInstance(rhs)) {
            AbstractStructuredObject rhsStructured = (AbstractStructuredObject)rhs;
            try {
                this.clearComponents();
                int i = 0;
                while (i < rhsStructured.getComponentCount()) {
                    AsnObject component = (AsnObject)componentClass.newInstance();
                    component.copy(rhsStructured.getComponent(i));
                    this.addComponent(component);
                    ++i;
                }
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException("argument class " + componentClass.getName() + " caused InstantiationException");
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("argument class " + componentClass.getName() + " caused IllegalAccessException");
            }
        }
    }

    public void addComponent(AsnObject component, Class componentClass) {
        if (componentClass == null) {
            throw new IllegalStateException("SEQUENCE/SET OF must have a component class specified.");
        }
        if (!componentClass.isInstance(component)) {
            throw new IllegalArgumentException("tried to add " + component.getClass().getName() + " to " + this.getIdentifier() + " SEQUENCE/SET OF " + componentClass.getName());
        }
        component.setIdentifier(this.getIdentifier() + '-' + this.getComponentCount());
        super.addComponent(component);
    }

    protected Vector encodeComponents() throws EncodeException {
        Vector<byte[]> componentEncodings = new Vector<byte[]>(this.getComponentCount());
        int i = 0;
        while (i < this.getComponentCount()) {
            AsnObject component = this.getComponent(i);
            if (!component.isDefaultValue() || !component.isOptional()) {
                byte[] octets = component.encode();
                if (component.getTagMethod() == 2) {
                    byte[] identOctets = this.makeIdentifierOctets(component.getTagClass(), 32, component.getTagNumber());
                    byte[] lengthOctets = this.makeLengthOctets(octets.length);
                    byte[] tagOctets = (byte[])this.arraycat(identOctets, lengthOctets);
                    octets = (byte[])this.arraycat(tagOctets, octets);
                }
                componentEncodings.addElement(octets);
            }
            ++i;
        }
        return componentEncodings;
    }

    protected byte[] catentateComponentEncodings(Vector componentEncodings) {
        int length = 0;
        int i = 0;
        while (i < componentEncodings.size()) {
            byte[] componentOctets = (byte[])componentEncodings.elementAt(i);
            length += componentOctets.length;
            ++i;
        }
        byte[] octets = new byte[length];
        length = 0;
        i = 0;
        while (i < componentEncodings.size()) {
            byte[] componentOctets = (byte[])componentEncodings.elementAt(i);
            System.arraycopy(componentOctets, 0, octets, length, componentOctets.length);
            length += componentOctets.length;
            ++i;
        }
        return octets;
    }

    protected void decodeContentsConstructed(DecodeStream stream, int end) throws DecodeException {
        DecodeTag tag = new DecodeTag();
        int i = 0;
        while (i < this.getComponentCount() && !stream.atEnd(end)) {
            AsnObject component = this.getComponent(i);
            stream.mark(0);
            tag.decode(stream);
            stream.reset();
            if (component.matchTag(tag)) {
                if (component.getTagMethod() == 2) {
                    stream.skip(tag.getTagLength());
                }
                component.decode(stream);
                if (!(component.getTagMethod() != 2 || tag.isDefiniteLength() || stream.read() == 0 && stream.read() == 0)) {
                    throw new DecodeException("Illegal end-of-contents tag");
                }
            } else if (!component.isOptional()) {
                throw new DecodeException("missing non-optional component " + component.getIdentifier() + " of " + this.getIdentifier() + ". expected " + AbstractAsnObject.getTagNumberText(component.getTagNumber()) + ", got " + AbstractAsnObject.getTagNumberText(tag.getTagNumber()));
            }
            ++i;
        }
        stream.assertEnd(end);
    }

    protected void decodeContentsConstructed(DecodeStream stream, int end, Class componentClass) throws DecodeException {
        try {
            DecodeTag tag = new DecodeTag();
            while (!stream.atEnd(end)) {
                stream.mark(0);
                tag.decode(stream);
                stream.reset();
                AsnObject component = (AsnObject)componentClass.newInstance();
                if (component.matchTag(tag)) {
                    this.addComponent(component);
                    component.decode(stream);
                    continue;
                }
                throw new DecodeException("wrong type for SEQUENCE/SET OF.  expected " + AbstractAsnObject.getTagNumberText(component.getTagNumber()) + ", got " + AbstractAsnObject.getTagNumberText(tag.getTagNumber()));
            }
            stream.assertEnd(end);
        }
        catch (InstantiationException e) {
            throw new DecodeException("problem with class passed to AbstractStructuredObject.decodeContentsConstructed()", e);
        }
        catch (IllegalAccessException e) {
            throw new DecodeException("problem with class passed to AbstractStructuredObject.decodeContentsConstructed()", e);
        }
    }

    protected void evaluate() {
        throw new UnsupportedOperationException("cannot evaluate() a structured object.");
    }
}

