/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.asn1;

import com.isnetworks.provider.asn1.AbstractAsnObject;
import com.isnetworks.provider.asn1.AbstractConstructedObject;
import com.isnetworks.provider.asn1.AsnObject;
import com.isnetworks.provider.asn1.DecodeException;
import com.isnetworks.provider.asn1.DecodeStream;
import com.isnetworks.provider.asn1.DecodeTag;

public abstract class AbstractStringObject
extends AbstractConstructedObject {
    public int hashCode() {
        Object value = this.getValue();
        if (value == null) {
            return super.hashCode();
        }
        return value.hashCode();
    }

    protected void decodeContentsConstructed(DecodeStream stream, int end) throws DecodeException {
        try {
            int index = 0;
            DecodeTag tag = new DecodeTag();
            while (!stream.atEnd(end)) {
                stream.mark(0);
                tag.decode(stream);
                stream.reset();
                AsnObject component = (AsnObject)this.getClass().newInstance();
                component.setIdentifier(this.getIdentifier() + index++);
                if (component.matchTag(tag)) {
                    component.decode(stream);
                    this.addComponent(component);
                    continue;
                }
                throw new DecodeException("wrong type for constructed string object.  expected " + AbstractAsnObject.getTagNumberText(component.getTagNumber()) + ", got " + AbstractAsnObject.getTagNumberText(tag.getTagNumber()));
            }
            stream.assertEnd(end);
        }
        catch (InstantiationException e) {
            throw new DecodeException("bad news", e);
        }
        catch (IllegalAccessException e) {
            throw new DecodeException("bad news", e);
        }
    }
}

