/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.asn1;

import com.isnetworks.provider.asn1.AsnObject;
import com.isnetworks.provider.asn1.DecodeException;
import com.isnetworks.provider.asn1.DecodeListener;
import com.isnetworks.provider.asn1.DecodeStream;
import com.isnetworks.provider.asn1.DecodeTag;
import com.isnetworks.provider.asn1.EncodeException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Vector;

public abstract class AbstractAsnObject
implements AsnObject {
    protected String mIdentifier;
    protected int mTagClass = 0;
    protected int mTagNumber;
    protected int mTagMethod = 0;
    protected boolean mOptional = false;
    protected int mBaseTagNumber;
    protected DecodeTag mDecodeTag;
    protected Vector mDecodeListeners;
    public static final String ENCODE_PREFIX = " > ";
    public static final String DECODE_PREFIX = " < ";
    public static final String NO_PREFIX = " ";
    private static int mIndentLevel = 0;
    private static boolean mTraceEnable = false;
    private static String mTracePrefix = " ";
    private static final NumberFormat mTraceNumberFormat = new DecimalFormat("00000");
    private static final String mTraceNumberBlank = "     ";
    private static final String mTraceIndent = "  ";
    private static StringBuffer mTraceBuffer = new StringBuffer();

    public AbstractAsnObject() {
    }

    public AbstractAsnObject(String identifier) {
        this();
        this.setIdentifier(identifier);
    }

    public void setIdentifier(String identifier) {
        this.mIdentifier = identifier;
    }

    public String getIdentifier() {
        return this.mIdentifier;
    }

    public void setType(int type) {
        this.mTagNumber = type;
        this.mBaseTagNumber = type;
    }

    public void setTag(int tagClass, int tagNumber, int tagMethod, boolean optional) {
        this.mTagClass = tagClass;
        this.mTagNumber = tagNumber;
        this.mTagMethod = tagMethod;
        this.mOptional = optional;
    }

    public int getTagClass() {
        return this.mTagClass;
    }

    public int getTagNumber() {
        return this.mTagNumber;
    }

    public int getTagMethod() {
        return this.mTagMethod;
    }

    public void setOptional(boolean optional) {
        this.mOptional = optional;
    }

    public boolean isOptional() {
        return this.mOptional;
    }

    public byte[] getEncoded() {
        return this.mDecodeTag == null ? null : this.mDecodeTag.getEncodedObject();
    }

    public boolean equals(Object rhs) {
        Object value = this.getValue();
        if (this.getCopyableClass().isInstance(rhs)) {
            Object rhsValue = ((AsnObject)rhs).getValue();
            if (value == null) {
                return rhsValue == null;
            }
            return value.equals(rhsValue);
        }
        if (value != null && value.getClass().isInstance(rhs)) {
            return value.equals(rhs);
        }
        return false;
    }

    public void copy(AsnObject rhs) {
        if (!this.getCopyableClass().isInstance(rhs)) {
            throw new IllegalArgumentException("cannot copy values from " + rhs.getClass().getName() + " to " + this.getClass().getName() + ".  copyable base class is " + this.getCopyableClass().getName());
        }
        this.setValue(rhs.getValue());
    }

    protected abstract Class getCopyableClass();

    public String toString() {
        return this.getValue().toString();
    }

    public byte[] encode() throws EncodeException {
        AbstractAsnObject.trace(this.getAsnText());
        AbstractAsnObject.indent();
        if (mTraceEnable && !this.isConstructed()) {
            AbstractAsnObject.trace(this.toString());
        }
        byte[] contentsOctets = this.makeContentsOctets();
        byte[] tagOctets = this.makeTagOctets(contentsOctets.length);
        AbstractAsnObject.outdent();
        byte[] encodedOctets = (byte[])this.arraycat(tagOctets, contentsOctets);
        return encodedOctets;
    }

    protected abstract byte[] makeContentsOctets() throws EncodeException;

    public byte[] makeTagOctets(int contentsOctetsLength) {
        byte[] octets = (byte[])this.arraycat(this.makeIdentifierOctets(), this.makeLengthOctets(contentsOctetsLength));
        return octets;
    }

    public byte[] makeIdentifierOctets() {
        int tagClass = this.mTagMethod == 1 ? this.mTagClass : 0;
        int constructed = this.isConstructed() ? 32 : 0;
        int tagNumber = this.mTagMethod == 1 ? this.mTagNumber : this.mBaseTagNumber;
        return this.makeIdentifierOctets(tagClass, constructed, tagNumber);
    }

    protected boolean isConstructed() {
        switch (this.mBaseTagNumber) {
            case 16: 
            case 17: {
                return true;
            }
        }
        return false;
    }

    public byte[] makeIdentifierOctets(int tagClass, int constructed, int tagNumber) {
        if (tagNumber >= 31) {
            throw new UnsupportedOperationException("high-tag-number form (tag number > 30) not implemented.");
        }
        byte[] octets = new byte[]{(byte)(tagClass | constructed | tagNumber)};
        return octets;
    }

    protected byte[] makeLengthOctets(int length) {
        byte[] octets;
        if (length == 0) {
            octets = new byte[]{0};
        } else if (length < 128) {
            octets = new byte[]{(byte)length};
        } else {
            String ls = Integer.toString(length);
            BigInteger bi = new BigInteger(ls);
            octets = bi.toByteArray();
            if (octets[0] != 0) {
                byte[] temp = new byte[octets.length + 1];
                System.arraycopy(octets, 0, temp, 1, octets.length);
                octets = temp;
            }
            octets[0] = (byte)(0x80 | octets.length - 1);
        }
        return octets;
    }

    public void decode(byte[] octets) throws DecodeException {
        try {
            DecodeStream stream = new DecodeStream(octets);
            this.decode(stream);
        }
        catch (RuntimeException e) {
            throw new DecodeException("Invalid ASN.1 bytes", e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void decode(InputStream in) throws DecodeException {
        try {
            int i;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((i = in.read()) != -1) {
                void var3_4;
                out.write((int)var3_4);
            }
            this.decode(out.toByteArray());
        }
        catch (IOException e) {
            throw new DecodeException("Decoding failed.", e);
        }
        catch (RuntimeException e) {
            throw new DecodeException("Invalid ASN.1 bytes", e);
        }
    }

    public void decode(DecodeStream stream) throws DecodeException {
        try {
            this.mDecodeTag = new DecodeTag(stream);
            this.validateTag(this.mDecodeTag);
            AbstractAsnObject.trace(this.mDecodeTag.getTagOffset(), this.getAsnText() + " {" + this.mDecodeTag.getTagLength() + " + " + this.mDecodeTag.getContentLength() + "}");
            AbstractAsnObject.indent();
            if (this.mDecodeTag.isConstructed()) {
                int end = this.mDecodeTag.isDefiniteLength() ? this.mDecodeTag.getContentOffset() + this.mDecodeTag.getContentLength() : -1;
                this.decodeContentsConstructed(stream, end);
                this.mDecodeTag.markContentEnd(stream);
            } else {
                stream.skip(this.mDecodeTag.getContentLength());
                if (mTraceEnable) {
                    AbstractAsnObject.trace(this.toString());
                }
            }
            AbstractAsnObject.outdent();
            this.fireObjectDecoded();
        }
        catch (RuntimeException e) {
            throw new DecodeException("Invalid ASN.1 bytes", e);
        }
    }

    protected abstract void decodeContentsConstructed(DecodeStream var1, int var2) throws DecodeException;

    protected abstract void evaluate();

    public boolean matchTag(DecodeTag tag) {
        return tag.getTagNumber() == this.mTagNumber;
    }

    protected void validateTag(DecodeTag tag) throws DecodeException {
        if (this.mTagMethod == 1) {
            if (tag.getTagClass() != this.mTagClass) {
                throw new DecodeException(this.getIdentifier() + ": wrong tag class. expected " + AbstractAsnObject.getTagClassText(this.mTagClass) + " got " + AbstractAsnObject.getTagClassText(tag.getTagClass()));
            }
            if (tag.getTagNumber() != this.mTagNumber) {
                throw new DecodeException(this.getIdentifier() + ": wrong tag number. expected " + AbstractAsnObject.getTagNumberText(this.mTagNumber) + " got " + AbstractAsnObject.getTagNumberText(tag.getTagNumber()));
            }
        } else {
            if (tag.getTagClass() != 0) {
                throw new DecodeException(this.getIdentifier() + ": wrong tag class.  expected UNIVERSAL got " + AbstractAsnObject.getTagClassText(tag.getTagClass()));
            }
            if (tag.getTagNumber() != this.mBaseTagNumber) {
                throw new DecodeException(this.getIdentifier() + ": wrong tag number. expected " + AbstractAsnObject.getTagNumberText(this.mBaseTagNumber) + " got " + AbstractAsnObject.getTagNumberText(tag.getTagNumber()));
            }
        }
    }

    public void addDecodeListener(DecodeListener listener) {
        if (this.mDecodeListeners == null) {
            this.mDecodeListeners = new Vector();
        }
        this.mDecodeListeners.addElement(listener);
    }

    public void removeDecodeListener(DecodeListener listener) {
        this.mDecodeListeners.removeElement(listener);
    }

    protected void fireObjectDecoded() throws DecodeException {
        if (this.mDecodeListeners != null) {
            int i = 0;
            while (i < this.mDecodeListeners.size()) {
                DecodeListener listener = (DecodeListener)this.mDecodeListeners.elementAt(i);
                listener.objectDecoded(this);
                ++i;
            }
        }
    }

    public Object arraycat(Object lhs, Object rhs) {
        Class<?> rhsClass;
        Class<?> lhsClass = lhs.getClass();
        if (lhsClass != (rhsClass = rhs.getClass())) {
            throw new IllegalArgumentException("differing types passed to arraycat");
        }
        Class<?> componentClass = lhsClass.getComponentType();
        int lhsLength = Array.getLength(lhs);
        int rhsLength = Array.getLength(rhs);
        int catLength = lhsLength + rhsLength;
        Object cat = Array.newInstance(componentClass, catLength);
        System.arraycopy(lhs, 0, cat, 0, lhsLength);
        System.arraycopy(rhs, 0, cat, lhsLength, rhsLength);
        return cat;
    }

    public static void setTraceEnable(boolean enable) {
        mTraceEnable = enable;
    }

    public static void setTracePrefix(String tracePrefix) {
        mTracePrefix = tracePrefix;
    }

    protected static void indent() {
        ++mIndentLevel;
    }

    protected static void outdent() {
        --mIndentLevel;
    }

    protected static void trace(String message) {
        AbstractAsnObject.trace(mTraceNumberBlank, message);
    }

    protected static void trace(int byteOffset, String message) {
        AbstractAsnObject.trace(mTraceNumberFormat.format(byteOffset), message);
    }

    private static void trace(String byteOffset, String message) {
        if (mTraceEnable) {
            mTraceBuffer = new StringBuffer();
            mTraceBuffer.append(byteOffset);
            mTraceBuffer.append(mTracePrefix);
            int k = 0;
            while (k < mIndentLevel) {
                mTraceBuffer.append(mTraceIndent);
                ++k;
            }
            mTraceBuffer.append(message);
            System.out.println(mTraceBuffer);
        }
    }

    public String getAsnText() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getIdentifier());
        sb.append(' ');
        if (this.mTagMethod != 0) {
            sb.append('[');
            if (this.mTagClass != 128) {
                sb.append(AbstractAsnObject.getTagClassText(this.mTagClass));
                sb.append(' ');
            }
            sb.append(this.mTagNumber);
            sb.append("] ");
            sb.append(AbstractAsnObject.getTagMethodText(this.mTagMethod));
            sb.append(NO_PREFIX);
        }
        sb.append(AbstractAsnObject.getTagNumberText(this.mBaseTagNumber));
        if (this.mOptional) {
            sb.append(" OPTIONAL");
        }
        return sb.toString();
    }

    protected static String getTagClassText(int tagClass) {
        switch (tagClass) {
            case 0: {
                return "UNIVERSAL";
            }
            case 64: {
                return "APPLICATION";
            }
            case 128: {
                return "CONTEXT";
            }
            case 192: {
                return "PRIVATE";
            }
        }
        return Integer.toString(tagClass);
    }

    protected static String getTagMethodText(int tagMethod) {
        switch (tagMethod) {
            case 0: {
                return "NONE";
            }
            case 1: {
                return "IMPLICIT";
            }
            case 2: {
                return "EXPLICIT";
            }
        }
        return Integer.toString(tagMethod);
    }

    protected static String getTagNumberText(int tagNumber) {
        switch (tagNumber) {
            case -1: {
                return "<various>";
            }
            case 0: {
                return "ANY";
            }
            case 1: {
                return "BOOLEAN";
            }
            case 2: {
                return "INTEGER";
            }
            case 3: {
                return "BIT STRING";
            }
            case 4: {
                return "OCTET STRING";
            }
            case 5: {
                return "NULL";
            }
            case 6: {
                return "OBJECT IDENTIFIER";
            }
            case 7: {
                return "OBJECT DESCRIPTOR";
            }
            case 8: {
                return "EXTERNAL";
            }
            case 9: {
                return "REAL";
            }
            case 10: {
                return "ENUMERATED";
            }
            case 11: {
                return "EMBEDDED PDV";
            }
            case 12: {
                return "UTF8String";
            }
            case 16: {
                return "SEQUENCE";
            }
            case 17: {
                return "SET";
            }
            case 19: {
                return "PrintableString";
            }
            case 20: {
                return "T61String";
            }
            case 22: {
                return "IA5String";
            }
            case 23: {
                return "UTCTime";
            }
            case 24: {
                return "GeneralizedTime";
            }
            case 25: {
                return "GRAPHICSTR";
            }
            case 26: {
                return "VISIBLESTR";
            }
            case 27: {
                return "GENERALSTR";
            }
            case 28: {
                return "UNIVERSALSTR";
            }
            case 30: {
                return "BMPSTR";
            }
        }
        return Integer.toString(tagNumber);
    }

    public abstract boolean isDefaultValue();

    public abstract void setDefaultValue(Object var1);

    public abstract Object getDefaultValue();

    public abstract void setValue(Object var1);

    public abstract Object getValue();
}

