/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider;

public class Util {
    public static byte[] xor(byte[] b1, byte[] b2) {
        int length = Math.max(b1.length, b2.length);
        byte[] result = new byte[length];
        int shorterLength = Math.min(b1.length, b2.length);
        int i = 0;
        while (i < shorterLength) {
            result[i] = (byte)(b1[i] ^ b2[i]);
            ++i;
        }
        if (b1.length > b2.length) {
            System.arraycopy(b1, shorterLength, result, shorterLength, length - shorterLength);
        } else if (b2.length > b1.length) {
            System.arraycopy(b2, shorterLength, result, shorterLength, length - shorterLength);
        }
        return result;
    }

    public static byte[] intsToBytes(int i1, int i2) {
        byte[] result = new byte[]{(byte)(i1 >> 24 & 0xFF), (byte)(i1 >> 16 & 0xFF), (byte)(i1 >> 8 & 0xFF), (byte)(i1 & 0xFF), (byte)(i2 >> 24 & 0xFF), (byte)(i2 >> 16 & 0xFF), (byte)(i2 >> 8 & 0xFF), (byte)(i2 & 0xFF)};
        return result;
    }

    public static int bytesToInt(byte[] bytes, int offset) {
        int result = (bytes[offset++] & 0xFF) << 24;
        result |= (bytes[offset++] & 0xFF) << 16;
        result |= (bytes[offset++] & 0xFF) << 8;
        return result |= bytes[offset] & 0xFF;
    }

    public static byte[] intToBytes(int input) {
        byte[] result = new byte[]{(byte)(input >> 24 & 0xFF), (byte)(input >> 16 & 0xFF), (byte)(input >> 8 & 0xFF), (byte)(input & 0xFF)};
        return result;
    }

    public static byte[] intsToBytes(int[] input) {
        byte[] result = new byte[input.length * 4];
        int i = 0;
        while (i < input.length) {
            byte[] temp = Util.intToBytes(input[i]);
            System.arraycopy(temp, 0, result, i * 4, temp.length);
            ++i;
        }
        return result;
    }

    public static int bytesToShort(byte[] bytes, int offset) {
        int result = (bytes[offset + 1] & 0xFF) << 8;
        return result |= bytes[offset] & 0xFF;
    }

    public static byte[] shortsToBytes(int s1, int s2, int s3, int s4) {
        byte[] result = new byte[8];
        result[1] = (byte)(s1 >>> 8 & 0xFF);
        result[0] = (byte)(s1 & 0xFF);
        result[3] = (byte)(s2 >>> 8 & 0xFF);
        result[2] = (byte)(s2 & 0xFF);
        result[5] = (byte)(s3 >>> 8 & 0xFF);
        result[4] = (byte)(s3 & 0xFF);
        result[7] = (byte)(s4 >>> 8 & 0xFF);
        result[6] = (byte)(s4 & 0xFF);
        return result;
    }

    public static long bytesToLong(byte[] bytes) {
        long result = (long)(bytes[0] & 0xFF) << 56;
        result |= (long)((bytes[1] & 0xFF) << 48);
        result |= (long)((bytes[2] & 0xFF) << 40);
        result |= (long)((bytes[3] & 0xFF) << 32);
        result |= (long)((bytes[4] & 0xFF) << 24);
        result |= (long)((bytes[5] & 0xFF) << 16);
        result |= (long)((bytes[6] & 0xFF) << 8);
        return result |= (long)(bytes[7] & 0xFF);
    }

    public static int fixByte(byte b) {
        if (b < 0) {
            return b + 256;
        }
        return b;
    }

    public static String byteArrayToString(byte[] array) {
        StringBuffer sb = new StringBuffer();
        boolean spacer = true;
        if (array == null) {
            sb.append("null");
        } else {
            int k = 0;
            while (k < array.length) {
                int i = array[k];
                if (i < 0) {
                    i += 256;
                }
                if (spacer) {
                    sb.append(' ');
                }
                spacer = !spacer;
                String hex = Integer.toHexString(i);
                if (hex.length() == 1) {
                    sb.append('0');
                }
                sb.append(hex);
                ++k;
            }
        }
        return sb.toString();
    }

    public static String byteArrayToString(byte[][] array) {
        byte[] temp = new byte[array[0].length * array.length];
        int j = 0;
        while (j < array[0].length) {
            int i = 0;
            while (i < array.length) {
                temp[j * array.length + i] = array[i][j];
                ++i;
            }
            ++j;
        }
        return Util.byteArrayToString(temp);
    }

    public static String byteArrayToString2(byte[][] array) {
        byte[] temp = new byte[array[0].length * array.length];
        int i = 0;
        while (i < array.length) {
            int j = 0;
            while (j < array[0].length) {
                temp[i * array[0].length + j] = array[i][j];
                ++j;
            }
            ++i;
        }
        return Util.byteArrayToString(temp);
    }

    public static String intArrayToHexString(int[] array) {
        byte[] byteArray = Util.intsToBytes(array);
        return Util.byteArrayToString(byteArray);
    }
}

