/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider;

import com.isnetworks.provider.Padding;
import com.isnetworks.provider.Util;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;

public class PKCS5Padding
implements Padding {
    public byte[] encode(byte[] message, int blockSize) throws IllegalBlockSizeException {
        byte[] result = new byte[blockSize];
        System.arraycopy(message, 0, result, 0, message.length);
        int i = message.length;
        while (i < result.length) {
            result[i] = (byte)(result.length - message.length);
            ++i;
        }
        return result;
    }

    public byte[] decode(byte[] message) throws BadPaddingException {
        if (message.length == 0) {
            throw new BadPaddingException("Message not PKCS5 padded");
        }
        int paddingCount = Util.fixByte(message[message.length - 1]);
        if (paddingCount > message.length) {
            throw new BadPaddingException("Trying to decode improperly padded block - padding larger than block");
        }
        int i = 0;
        while (i < paddingCount) {
            if (Util.fixByte(message[message.length - 1 - i]) != paddingCount) {
                throw new BadPaddingException("Trying to decode improperly padded block - last " + paddingCount + " bytes should all be " + paddingCount);
            }
            ++i;
        }
        byte[] result = new byte[message.length - paddingCount];
        System.arraycopy(message, 0, result, 0, result.length);
        return result;
    }
}

