/*
 * Decompiled with CFR 0.152.
 */
package sun.text;

import java.text.CharacterIterator;
import sun.text.NormalizerImpl;
import sun.text.UCharacterIterator;
import sun.text.Utility;

public final class Normalizer
implements Cloneable {
    private char[] buffer = new char[100];
    private int bufferStart = 0;
    private int bufferPos = 0;
    private int bufferLimit = 0;
    private UCharacterIterator text;
    private Mode mode = COMPOSE;
    private int options = 0;
    private int currentIndex;
    private int nextIndex;
    public static final int IGNORE_HANGUL = 1;
    public static final int DONE = -1;
    public static final Mode NO_OP = new Mode(1);
    public static final Mode DECOMP = new NFDMode(2);
    public static final Mode DECOMP_COMPAT = new NFKDMode(3);
    public static final Mode COMPOSE = new NFCMode(4);
    public static final Mode COMPOSE_COMPAT = new NFKCMode(5);
    public static final Mode FCD = new FCDMode(6);
    public static final QuickCheckResult NO = new QuickCheckResult(0);
    public static final QuickCheckResult YES = new QuickCheckResult(1);
    public static final QuickCheckResult MAYBE = new QuickCheckResult(2);
    private static final int MAX_BUF_SIZE_COMPOSE = 2;
    private static final int MAX_BUF_SIZE_DECOMPOSE = 3;

    public Normalizer(String string, Mode mode, int n2) {
        this.text = UCharacterIterator.getInstance(string);
        this.mode = mode;
        this.options = n2;
    }

    public Normalizer(CharacterIterator characterIterator, Mode mode, int n2) {
        this.text = UCharacterIterator.getInstance((CharacterIterator)characterIterator.clone());
        this.mode = mode;
        this.options = n2;
    }

    private Normalizer(UCharacterIterator uCharacterIterator, Mode mode, int n2) {
        try {
            this.text = (UCharacterIterator)uCharacterIterator.clone();
            this.mode = mode;
            this.options = n2;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public Normalizer(String string, Mode mode) {
        this(string, mode, 0);
    }

    public Normalizer(CharacterIterator characterIterator, Mode mode) {
        this(characterIterator, mode, 0);
    }

    public Object clone() {
        try {
            Normalizer normalizer = (Normalizer)super.clone();
            normalizer.text = (UCharacterIterator)this.text.clone();
            if (this.buffer != null) {
                normalizer.buffer = new char[this.buffer.length];
                System.arraycopy(this.buffer, 0, normalizer.buffer, 0, this.buffer.length);
            }
            return normalizer;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public static String compose(String string, boolean bl2, int n2) {
        char[] cArray = new char[string.length() * 2];
        int n3 = 0;
        char[] cArray2 = string.toCharArray();
        while ((n3 = NormalizerImpl.compose(cArray2, 0, cArray2.length, cArray, 0, cArray.length, bl2, n2)) > cArray.length) {
            cArray = new char[n3];
        }
        return new String(cArray, 0, n3);
    }

    public static String decompose(String string, boolean bl2, int n2) {
        char[] cArray = new char[string.length() * 3];
        int[] nArray = new int[1];
        int n3 = 0;
        while ((n3 = NormalizerImpl.decompose(string.toCharArray(), 0, string.length(), cArray, 0, cArray.length, bl2, nArray, n2)) > cArray.length) {
            cArray = new char[n3];
        }
        return new String(cArray, 0, n3);
    }

    public static String decompose(String string, boolean bl2, int n2, boolean bl3) {
        char[] cArray = new char[string.length() * 3];
        int[] nArray = new int[1];
        while (true) {
            int n3;
            if ((n3 = NormalizerImpl.decompose(string.toCharArray(), 0, string.length(), cArray, 0, cArray.length, bl2, nArray, n2)) <= cArray.length) {
                if (!bl3) {
                    return new String(cArray, 0, n3);
                }
                StringBuffer stringBuffer = new StringBuffer();
                return new String(cArray, 0, n3);
            }
            cArray = new char[n3];
        }
    }

    public static String normalize(String string, Mode mode, int n2) {
        return mode.normalize(string, n2);
    }

    private static int normalize(char[] cArray, int n2, int n3, char[] cArray2, int n4, int n5, Mode mode, int n6) {
        int n7 = mode.normalize(cArray, n2, n3, cArray2, n4, n5, n6);
        if (n7 <= n5 - n4) {
            return n7;
        }
        throw new IndexOutOfBoundsException(Integer.toString(n7));
    }

    public static QuickCheckResult quickCheck(String string, Mode mode, int n2) {
        return mode.quickCheck(string.toCharArray(), 0, string.length(), true, n2);
    }

    public static final int getClass(int n2) {
        return NormalizerImpl.getCombiningClass(n2);
    }

    public int current() {
        if (this.bufferPos < this.bufferLimit || this.nextNormalize()) {
            return this.getCodePointAt(this.bufferPos);
        }
        return -1;
    }

    public int next() {
        if (this.bufferPos < this.bufferLimit || this.nextNormalize()) {
            int n2 = this.getCodePointAt(this.bufferPos);
            this.bufferPos += n2 > 65535 ? 2 : 1;
            return n2;
        }
        return -1;
    }

    public int previous() {
        if (this.bufferPos > 0 || this.previousNormalize()) {
            int n2 = this.getCodePointAt(this.bufferPos - 1);
            this.bufferPos -= n2 > 65535 ? 2 : 1;
            return n2;
        }
        return -1;
    }

    public void reset() {
        this.currentIndex = this.nextIndex = this.text.getBeginIndex();
        this.text.setIndex(this.currentIndex);
        this.clearBuffer();
    }

    public void setIndexOnly(int n2) {
        this.text.setIndex(n2);
        this.currentIndex = this.nextIndex = n2;
        this.clearBuffer();
    }

    public int setIndex(int n2) {
        this.setIndexOnly(n2);
        return this.current();
    }

    public int getBeginIndex() {
        return 0;
    }

    public int getEndIndex() {
        return this.text.getLength();
    }

    public int first() {
        this.reset();
        return this.next();
    }

    public int last() {
        this.text.setToLimit();
        this.currentIndex = this.nextIndex = this.text.getIndex();
        this.clearBuffer();
        return this.previous();
    }

    public int getIndex() {
        if (this.bufferPos < this.bufferLimit) {
            return this.currentIndex;
        }
        return this.nextIndex;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setOption(int n2, boolean bl2) {
        this.options = bl2 ? (this.options |= n2) : (this.options &= ~n2);
    }

    public int getOption(int n2) {
        if ((this.options & n2) != 0) {
            return 1;
        }
        return 0;
    }

    public void setText(String string) {
        UCharacterIterator uCharacterIterator = UCharacterIterator.getInstance(string);
        if (uCharacterIterator == null) {
            throw new InternalError("Could not create a new UCharacterIterator");
        }
        this.text = uCharacterIterator;
        this.reset();
    }

    public void setText(CharacterIterator characterIterator) {
        UCharacterIterator uCharacterIterator = UCharacterIterator.getInstance(characterIterator);
        if (uCharacterIterator == null) {
            throw new InternalError("Could not create a new UCharacterIterator");
        }
        this.text = uCharacterIterator;
        this.reset();
    }

    private static long getPrevNorm32(UCharacterIterator uCharacterIterator, int n2, int n3, char[] cArray) {
        int n4 = 0;
        n4 = uCharacterIterator.previous();
        if (n4 == -1) {
            return 0L;
        }
        cArray[0] = (char)n4;
        cArray[1] = '\u0000';
        if (cArray[0] < n2) {
            return 0L;
        }
        if (cArray[0] < '\ud800' || cArray[0] > '\udfff') {
            return NormalizerImpl.getNorm32(cArray[0]);
        }
        if (Character.isHighSurrogate(cArray[0]) || uCharacterIterator.getIndex() == 0) {
            cArray[1] = (char)uCharacterIterator.current();
            return 0L;
        }
        cArray[1] = (char)uCharacterIterator.previous();
        if (Character.isHighSurrogate(cArray[1])) {
            long l2 = NormalizerImpl.getNorm32(cArray[1]);
            if ((l2 & (long)n3) == 0L) {
                return 0L;
            }
            return NormalizerImpl.getNorm32FromSurrogatePair(l2, cArray[0]);
        }
        uCharacterIterator.moveIndex(1);
        return 0L;
    }

    private static int findPreviousIterationBoundary(UCharacterIterator uCharacterIterator, IsPrevBoundary isPrevBoundary, int n2, int n3, char[] cArray, int[] nArray) {
        char[] cArray2 = new char[2];
        nArray[0] = cArray.length;
        cArray2[0] = '\u0000';
        while (uCharacterIterator.getIndex() > 0 && cArray2[0] != '\uffffffff') {
            boolean bl2 = isPrevBoundary.isPrevBoundary(uCharacterIterator, n2, n3, cArray2);
            if (nArray[0] < (cArray2[1] == '\u0000' ? 1 : 2)) {
                char[] cArray3 = new char[cArray.length * 2];
                System.arraycopy(cArray, nArray[0], cArray3, cArray3.length - (cArray.length - nArray[0]), cArray.length - nArray[0]);
                nArray[0] = nArray[0] + (cArray3.length - cArray.length);
                cArray = cArray3;
                cArray3 = null;
            }
            nArray[0] = nArray[0] - 1;
            cArray[nArray[0]] = cArray2[0];
            if (cArray2[1] != '\u0000') {
                nArray[0] = nArray[0] - 1;
                cArray[nArray[0]] = cArray2[1];
            }
            if (!bl2) continue;
            break;
        }
        return cArray.length - nArray[0];
    }

    private static int previous(UCharacterIterator uCharacterIterator, char[] cArray, int n2, int n3, Mode mode, boolean bl2, boolean[] blArray, int n4) {
        int[] nArray = new int[1];
        int n5 = n3 - n2;
        int n6 = 0;
        char[] cArray2 = new char[100];
        if (blArray != null) {
            blArray[0] = false;
        }
        char c2 = (char)mode.getMinC();
        int n7 = mode.getMask();
        IsPrevBoundary isPrevBoundary = mode.getPrevBoundary();
        if (isPrevBoundary == null) {
            n6 = 0;
            int n8 = uCharacterIterator.previous();
            if (n8 >= 0) {
                int n9;
                n6 = 1;
                if (Character.isLowSurrogate((char)n8) && (n9 = uCharacterIterator.previous()) != -1) {
                    if (Character.isHighSurrogate((char)n9)) {
                        if (n5 >= 2) {
                            cArray[1] = (char)n8;
                            n6 = 2;
                        }
                        n8 = n9;
                    } else {
                        uCharacterIterator.moveIndex(1);
                    }
                }
                if (n5 > 0) {
                    cArray[0] = (char)n8;
                }
            }
            return n6;
        }
        int n10 = Normalizer.findPreviousIterationBoundary(uCharacterIterator, isPrevBoundary, c2, n7, cArray2, nArray);
        if (n10 > 0) {
            if (bl2) {
                n6 = Normalizer.normalize(cArray2, nArray[0], nArray[0] + n10, cArray, n2, n3, mode, n4);
                if (blArray != null) {
                    blArray[0] = n6 != n10 || Utility.arrayRegionMatches(cArray2, 0, cArray, n2, n3);
                }
            } else if (n5 > 0) {
                System.arraycopy(cArray2, nArray[0], cArray, 0, n10 < n5 ? n10 : n5);
            }
        }
        return n6;
    }

    private static long getNextNorm32(UCharacterIterator uCharacterIterator, int n2, int n3, int[] nArray) {
        nArray[0] = uCharacterIterator.next();
        nArray[1] = 0;
        if (nArray[0] < n2) {
            return 0L;
        }
        long l2 = NormalizerImpl.getNorm32((char)nArray[0]);
        if (Character.isHighSurrogate((char)nArray[0])) {
            if (uCharacterIterator.current() != -1 && Character.isLowSurrogate((char)(nArray[1] = uCharacterIterator.current()))) {
                uCharacterIterator.moveIndex(1);
                if ((l2 & (long)n3) == 0L) {
                    return 0L;
                }
                return NormalizerImpl.getNorm32FromSurrogatePair(l2, (char)nArray[1]);
            }
            return 0L;
        }
        return l2;
    }

    private static int findNextIterationBoundary(UCharacterIterator uCharacterIterator, IsNextBoundary isNextBoundary, int n2, int n3, char[] cArray) {
        int[] nArray = new int[2];
        int n4 = 0;
        if (uCharacterIterator.current() == -1) {
            return 0;
        }
        nArray[0] = uCharacterIterator.next();
        cArray[0] = (char)nArray[0];
        n4 = 1;
        if (Character.isHighSurrogate((char)nArray[0]) && uCharacterIterator.current() != -1) {
            nArray[1] = uCharacterIterator.next();
            if (Character.isLowSurrogate((char)nArray[1])) {
                cArray[n4++] = (char)nArray[1];
            } else {
                uCharacterIterator.moveIndex(-1);
            }
        }
        while (uCharacterIterator.current() != -1) {
            if (isNextBoundary.isNextBoundary(uCharacterIterator, n2, n3, nArray)) {
                uCharacterIterator.moveIndex(nArray[1] == 0 ? -1 : -2);
                break;
            }
            if (n4 + (nArray[1] == 0 ? 1 : 2) <= cArray.length) {
                cArray[n4++] = (char)nArray[0];
                if (nArray[1] == 0) continue;
                cArray[n4++] = (char)nArray[1];
                continue;
            }
            char[] cArray2 = new char[cArray.length * 2];
            System.arraycopy(cArray, 0, cArray2, 0, n4);
            cArray = cArray2;
            cArray[n4++] = (char)nArray[0];
            if (nArray[1] == 0) continue;
            cArray[n4++] = (char)nArray[1];
        }
        return n4;
    }

    private static int next(UCharacterIterator uCharacterIterator, char[] cArray, int n2, int n3, Mode mode, boolean bl2, boolean[] blArray, int n4) {
        char[] cArray2 = new char[100];
        int n5 = n3 - n2;
        int n6 = 0;
        int[] nArray = new int[1];
        if (blArray != null) {
            blArray[0] = false;
        }
        char c2 = (char)mode.getMinC();
        int n7 = mode.getMask();
        IsNextBoundary isNextBoundary = mode.getNextBoundary();
        if (isNextBoundary == null) {
            n6 = 0;
            int n8 = uCharacterIterator.next();
            if (n8 != -1) {
                int n9;
                n6 = 1;
                if (Character.isHighSurrogate((char)n8) && (n9 = uCharacterIterator.next()) != -1) {
                    if (Character.isLowSurrogate((char)n9)) {
                        if (n5 >= 2) {
                            cArray[1] = (char)n9;
                            n6 = 2;
                        }
                    } else {
                        uCharacterIterator.moveIndex(-1);
                    }
                }
                if (n5 > 0) {
                    cArray[0] = (char)n8;
                }
            }
            return n6;
        }
        int n10 = Normalizer.findNextIterationBoundary(uCharacterIterator, isNextBoundary, c2, n7, cArray2);
        if (n10 > 0) {
            if (bl2) {
                n6 = mode.normalize(cArray2, nArray[0], n10, cArray, n2, n3, n4);
                if (blArray != null) {
                    blArray[0] = n6 != n10 || Utility.arrayRegionMatches(cArray2, nArray[0], cArray, n2, n6);
                }
            } else if (n5 > 0) {
                System.arraycopy(cArray2, 0, cArray, n2, Math.min(n10, n5));
            }
        }
        return n6;
    }

    private void clearBuffer() {
        this.bufferPos = 0;
        this.bufferStart = 0;
        this.bufferLimit = 0;
    }

    private boolean nextNormalize() {
        this.clearBuffer();
        this.currentIndex = this.nextIndex;
        this.text.setIndex(this.nextIndex);
        this.bufferLimit = Normalizer.next(this.text, this.buffer, this.bufferStart, this.buffer.length, this.mode, true, null, this.options);
        this.nextIndex = this.text.getIndex();
        return this.bufferLimit > 0;
    }

    private boolean previousNormalize() {
        this.clearBuffer();
        this.nextIndex = this.currentIndex;
        this.text.setIndex(this.currentIndex);
        this.bufferLimit = Normalizer.previous(this.text, this.buffer, this.bufferStart, this.buffer.length, this.mode, true, null, this.options);
        this.currentIndex = this.text.getIndex();
        this.bufferPos = this.bufferLimit;
        return this.bufferLimit > 0;
    }

    private int getCodePointAt(int n2) {
        if (Character.isHighSurrogate(this.buffer[n2])) {
            if (n2 + 1 < this.bufferLimit && Character.isLowSurrogate(this.buffer[n2 + 1])) {
                return Character.toCodePoint(this.buffer[n2], this.buffer[n2 + 1]);
            }
        } else if (Character.isLowSurrogate(this.buffer[n2]) && n2 > 0 && Character.isHighSurrogate(this.buffer[n2 - 1])) {
            return Character.toCodePoint(this.buffer[n2 - 1], this.buffer[n2]);
        }
        return this.buffer[n2];
    }

    private static final class FCDMode
    extends Mode {
        private FCDMode(int n2) {
            super(n2);
        }

        protected QuickCheckResult quickCheck(char[] cArray, int n2, int n3, boolean bl2, int n4) {
            return NormalizerImpl.checkFCD(cArray, n2, n3, n4) ? YES : NO;
        }
    }

    private static interface IsNextBoundary {
        public boolean isNextBoundary(UCharacterIterator var1, int var2, int var3, int[] var4);
    }

    private static final class IsNextNFDSafe
    implements IsNextBoundary {
        private IsNextNFDSafe() {
        }

        public boolean isNextBoundary(UCharacterIterator uCharacterIterator, int n2, int n3, int[] nArray) {
            return NormalizerImpl.isNFDSafe(Normalizer.getNextNorm32(uCharacterIterator, n2, n3, nArray), n3, n3 & 0x3F);
        }
    }

    private static final class IsNextTrueStarter
    implements IsNextBoundary {
        private IsNextTrueStarter() {
        }

        public boolean isNextBoundary(UCharacterIterator uCharacterIterator, int n2, int n3, int[] nArray) {
            int n4 = n3 << 2 & 0xF;
            long l2 = Normalizer.getNextNorm32(uCharacterIterator, n2, n3 | n4, nArray);
            return NormalizerImpl.isTrueStarter(l2, n3, n4);
        }
    }

    private static interface IsPrevBoundary {
        public boolean isPrevBoundary(UCharacterIterator var1, int var2, int var3, char[] var4);
    }

    private static final class IsPrevNFDSafe
    implements IsPrevBoundary {
        private IsPrevNFDSafe() {
        }

        public boolean isPrevBoundary(UCharacterIterator uCharacterIterator, int n2, int n3, char[] cArray) {
            return NormalizerImpl.isNFDSafe(Normalizer.getPrevNorm32(uCharacterIterator, n2, n3, cArray), n3, n3 & 0x3F);
        }
    }

    private static final class IsPrevTrueStarter
    implements IsPrevBoundary {
        private IsPrevTrueStarter() {
        }

        public boolean isPrevBoundary(UCharacterIterator uCharacterIterator, int n2, int n3, char[] cArray) {
            int n4 = n3 << 2 & 0xF;
            long l2 = Normalizer.getPrevNorm32(uCharacterIterator, n2, n3 | n4, cArray);
            return NormalizerImpl.isTrueStarter(l2, n3, n4);
        }
    }

    public static class Mode {
        private int modeValue;

        private Mode(int n2) {
            this.modeValue = n2;
        }

        protected int normalize(char[] cArray, int n2, int n3, char[] cArray2, int n4, int n5, int n6) {
            int n7 = n3 - n2;
            int n8 = n5 - n4;
            if (n7 > n8) {
                return n7;
            }
            System.arraycopy(cArray, n2, cArray2, n4, n7);
            return n7;
        }

        protected String normalize(String string, int n2) {
            return string;
        }

        protected int getMinC() {
            return -1;
        }

        protected int getMask() {
            return -1;
        }

        protected IsPrevBoundary getPrevBoundary() {
            return null;
        }

        protected IsNextBoundary getNextBoundary() {
            return null;
        }

        protected QuickCheckResult quickCheck(char[] cArray, int n2, int n3, boolean bl2, int n4) {
            if (bl2) {
                return MAYBE;
            }
            return NO;
        }
    }

    private static final class NFCMode
    extends Mode {
        private NFCMode(int n2) {
            super(n2);
        }

        protected int normalize(char[] cArray, int n2, int n3, char[] cArray2, int n4, int n5, int n6) {
            return NormalizerImpl.compose(cArray, n2, n3, cArray2, n4, n5, false, n6);
        }

        protected String normalize(String string, int n2) {
            return Normalizer.compose(string, false, n2);
        }

        protected int getMinC() {
            return NormalizerImpl.getFromIndexesArr(6);
        }

        protected IsPrevBoundary getPrevBoundary() {
            return new IsPrevTrueStarter();
        }

        protected IsNextBoundary getNextBoundary() {
            return new IsNextTrueStarter();
        }

        protected int getMask() {
            return 65297;
        }

        protected QuickCheckResult quickCheck(char[] cArray, int n2, int n3, boolean bl2, int n4) {
            return NormalizerImpl.quickCheck(cArray, n2, n3, NormalizerImpl.getFromIndexesArr(6), 17, bl2, n4);
        }
    }

    private static final class NFDMode
    extends Mode {
        private NFDMode(int n2) {
            super(n2);
        }

        protected int normalize(char[] cArray, int n2, int n3, char[] cArray2, int n4, int n5, int n6) {
            int[] nArray = new int[1];
            return NormalizerImpl.decompose(cArray, n2, n3, cArray2, n4, n5, false, nArray, n6);
        }

        protected String normalize(String string, int n2) {
            return Normalizer.decompose(string, false, n2);
        }

        protected int getMinC() {
            return 768;
        }

        protected IsPrevBoundary getPrevBoundary() {
            return new IsPrevNFDSafe();
        }

        protected IsNextBoundary getNextBoundary() {
            return new IsNextNFDSafe();
        }

        protected int getMask() {
            return 65284;
        }

        protected QuickCheckResult quickCheck(char[] cArray, int n2, int n3, boolean bl2, int n4) {
            return NormalizerImpl.quickCheck(cArray, n2, n3, NormalizerImpl.getFromIndexesArr(8), 4, bl2, n4);
        }
    }

    private static final class NFKCMode
    extends Mode {
        private NFKCMode(int n2) {
            super(n2);
        }

        protected int normalize(char[] cArray, int n2, int n3, char[] cArray2, int n4, int n5, int n6) {
            return NormalizerImpl.compose(cArray, n2, n3, cArray2, n4, n5, true, n6);
        }

        protected String normalize(String string, int n2) {
            return Normalizer.compose(string, true, n2);
        }

        protected int getMinC() {
            return NormalizerImpl.getFromIndexesArr(7);
        }

        protected IsPrevBoundary getPrevBoundary() {
            return new IsPrevTrueStarter();
        }

        protected IsNextBoundary getNextBoundary() {
            return new IsNextTrueStarter();
        }

        protected int getMask() {
            return 65314;
        }

        protected QuickCheckResult quickCheck(char[] cArray, int n2, int n3, boolean bl2, int n4) {
            return NormalizerImpl.quickCheck(cArray, n2, n3, NormalizerImpl.getFromIndexesArr(7), 34, bl2, n4);
        }
    }

    private static final class NFKDMode
    extends Mode {
        private NFKDMode(int n2) {
            super(n2);
        }

        protected int normalize(char[] cArray, int n2, int n3, char[] cArray2, int n4, int n5, int n6) {
            int[] nArray = new int[1];
            return NormalizerImpl.decompose(cArray, n2, n3, cArray2, n4, n5, true, nArray, n6);
        }

        protected String normalize(String string, int n2) {
            return Normalizer.decompose(string, true, n2);
        }

        protected int getMinC() {
            return 768;
        }

        protected IsPrevBoundary getPrevBoundary() {
            return new IsPrevNFDSafe();
        }

        protected IsNextBoundary getNextBoundary() {
            return new IsNextNFDSafe();
        }

        protected int getMask() {
            return 65288;
        }

        protected QuickCheckResult quickCheck(char[] cArray, int n2, int n3, boolean bl2, int n4) {
            return NormalizerImpl.quickCheck(cArray, n2, n3, NormalizerImpl.getFromIndexesArr(9), 8, bl2, n4);
        }
    }

    public static final class QuickCheckResult {
        private int resultValue;

        private QuickCheckResult(int n2) {
            this.resultValue = n2;
        }
    }
}

