/*
 * Decompiled with CFR 0.152.
 */
package sun.swing.plaf.synth;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.basic.BasicDirectoryModel;
import javax.swing.plaf.synth.SynthContext;
import sun.awt.shell.ShellFolder;
import sun.swing.FilePane;
import sun.swing.plaf.synth.SynthFileChooserUI;

public class SynthFileChooserUIImpl
extends SynthFileChooserUI {
    private JLabel lookInLabel;
    private JComboBox directoryComboBox;
    private DirectoryComboBoxModel directoryComboBoxModel;
    private Action directoryComboBoxAction = new DirectoryComboBoxAction();
    private FilterComboBoxModel filterComboBoxModel;
    private JTextField fileNameTextField;
    private FilePane filePane;
    private boolean useShellFolder;
    private JPanel buttonPanel;
    private JPanel bottomPanel;
    private JComboBox filterComboBox;
    private static final Dimension hstrut5 = new Dimension(5, 1);
    private static final Dimension vstrut5 = new Dimension(1, 5);
    private static Dimension LIST_PREF_SIZE = new Dimension(405, 135);
    private int lookInLabelMnemonic = 0;
    private String lookInLabelText = null;
    private String saveInLabelText = null;
    private int fileNameLabelMnemonic = 0;
    private String fileNameLabelText = null;
    private int filesOfTypeLabelMnemonic = 0;
    private String filesOfTypeLabelText = null;
    static final int space = 10;

    public SynthFileChooserUIImpl(JFileChooser jFileChooser) {
        super(jFileChooser);
    }

    public void installComponents(JFileChooser jFileChooser) {
        super.installComponents(jFileChooser);
        SynthContext synthContext = this.getContext(jFileChooser, 1);
        this.updateUseShellFolder();
        jFileChooser.setLayout(new BorderLayout(0, 11));
        JPanel jPanel = new JPanel(new BorderLayout(11, 0));
        jFileChooser.add((Component)jPanel, "North");
        this.lookInLabel = new JLabel(this.lookInLabelText);
        this.lookInLabel.setDisplayedMnemonic(this.lookInLabelMnemonic);
        jPanel.add((Component)this.lookInLabel, "Before");
        this.directoryComboBox = new JComboBox();
        this.directoryComboBox.getAccessibleContext().setAccessibleDescription(this.lookInLabelText);
        this.directoryComboBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        this.lookInLabel.setLabelFor(this.directoryComboBox);
        this.directoryComboBoxModel = this.createDirectoryComboBoxModel(jFileChooser);
        this.directoryComboBox.setModel(this.directoryComboBoxModel);
        this.directoryComboBox.addActionListener(this.directoryComboBoxAction);
        this.directoryComboBox.setRenderer(this.createDirectoryComboBoxRenderer(jFileChooser));
        this.directoryComboBox.setAlignmentX(0.0f);
        this.directoryComboBox.setAlignmentY(0.0f);
        this.directoryComboBox.setMaximumRowCount(8);
        jPanel.add((Component)this.directoryComboBox, "Center");
        this.filePane = new FilePane(new SynthFileChooserUIAccessor());
        jFileChooser.addPropertyChangeListener(this.filePane);
        JPopupMenu jPopupMenu = this.filePane.getComponentPopupMenu();
        if (jPopupMenu != null) {
            jPopupMenu.insert(this.getChangeToParentDirectoryAction(), 0);
            if (File.separatorChar == '/') {
                jPopupMenu.insert(this.getGoHomeAction(), 1);
            }
        }
        jFileChooser.add((Component)this.getAccessoryPanel(), "After");
        JComponent jComponent = jFileChooser.getAccessory();
        if (jComponent != null) {
            this.getAccessoryPanel().add(jComponent);
            System.out.println("added accessory");
        }
        this.filePane.setPreferredSize(LIST_PREF_SIZE);
        jFileChooser.add((Component)this.filePane, "Center");
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new BoxLayout(this.bottomPanel, 1));
        jFileChooser.add((Component)this.bottomPanel, "South");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 2));
        this.bottomPanel.add(jPanel2);
        this.bottomPanel.add(Box.createRigidArea(new Dimension(1, 5)));
        AlignedLabel alignedLabel = new AlignedLabel(this.fileNameLabelText);
        alignedLabel.setDisplayedMnemonic(this.fileNameLabelMnemonic);
        jPanel2.add(alignedLabel);
        this.fileNameTextField = new JTextField(35){

            public Dimension getMaximumSize() {
                return new Dimension(Short.MAX_VALUE, super.getPreferredSize().height);
            }
        };
        jPanel2.add(this.fileNameTextField);
        alignedLabel.setLabelFor(this.fileNameTextField);
        this.fileNameTextField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                if (!SynthFileChooserUIImpl.this.getFileChooser().isMultiSelectionEnabled()) {
                    SynthFileChooserUIImpl.this.filePane.clearSelection();
                }
            }
        });
        if (jFileChooser.isMultiSelectionEnabled()) {
            this.setFileName(this.fileNameString(jFileChooser.getSelectedFiles()));
        } else {
            this.setFileName(this.fileNameString(jFileChooser.getSelectedFile()));
        }
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 2));
        this.bottomPanel.add(jPanel3);
        AlignedLabel alignedLabel2 = new AlignedLabel(this.filesOfTypeLabelText);
        alignedLabel2.setDisplayedMnemonic(this.filesOfTypeLabelMnemonic);
        jPanel3.add(alignedLabel2);
        this.filterComboBoxModel = this.createFilterComboBoxModel();
        jFileChooser.addPropertyChangeListener(this.filterComboBoxModel);
        this.filterComboBox = new JComboBox(this.filterComboBoxModel);
        this.filterComboBox.getAccessibleContext().setAccessibleDescription(this.filesOfTypeLabelText);
        alignedLabel2.setLabelFor(this.filterComboBox);
        this.filterComboBox.setRenderer(this.createFilterComboBoxRenderer());
        jPanel3.add(this.filterComboBox);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new ButtonAreaLayout());
        this.buttonPanel.add(this.getApproveButton(jFileChooser));
        this.buttonPanel.add(this.getCancelButton(jFileChooser));
        if (jFileChooser.getControlButtonsAreShown()) {
            this.addControlButtons();
        }
        SynthFileChooserUIImpl.groupLabels(new AlignedLabel[]{alignedLabel, alignedLabel2});
    }

    private void updateUseShellFolder() {
        JFileChooser jFileChooser = this.getFileChooser();
        Boolean bl2 = (Boolean)jFileChooser.getClientProperty("FileChooser.useShellFolder");
        if (bl2 != null) {
            this.useShellFolder = bl2;
        } else {
            File[] fileArray;
            this.useShellFolder = false;
            File[] fileArray2 = jFileChooser.getFileSystemView().getRoots();
            if (fileArray2 != null && fileArray2.length == 1 && (fileArray = (File[])ShellFolder.get("fileChooserComboBoxFolders")) != null && fileArray.length > 0 && fileArray2[0] == fileArray[0]) {
                this.useShellFolder = true;
            }
        }
    }

    private String fileNameString(File file) {
        if (file == null) {
            return null;
        }
        JFileChooser jFileChooser = this.getFileChooser();
        if (jFileChooser.isDirectorySelectionEnabled() && !jFileChooser.isFileSelectionEnabled()) {
            return file.getPath();
        }
        return file.getName();
    }

    private String fileNameString(File[] fileArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; fileArray != null && i2 < fileArray.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(" ");
            }
            if (fileArray.length > 1) {
                stringBuffer.append("\"");
            }
            stringBuffer.append(this.fileNameString(fileArray[i2]));
            if (fileArray.length <= 1) continue;
            stringBuffer.append("\"");
        }
        return stringBuffer.toString();
    }

    public void uninstallUI(JComponent jComponent) {
        jComponent.removePropertyChangeListener(this.filterComboBoxModel);
        jComponent.removePropertyChangeListener(this.filePane);
        super.uninstallUI(jComponent);
    }

    protected void installStrings(JFileChooser jFileChooser) {
        super.installStrings(jFileChooser);
        Locale locale = jFileChooser.getLocale();
        this.lookInLabelMnemonic = this.getMnemonic("FileChooser.lookInLabelMnemonic", locale);
        this.lookInLabelText = UIManager.getString((Object)"FileChooser.lookInLabelText", locale);
        this.saveInLabelText = UIManager.getString((Object)"FileChooser.saveInLabelText", locale);
        this.fileNameLabelMnemonic = this.getMnemonic("FileChooser.fileNameLabelMnemonic", locale);
        this.fileNameLabelText = UIManager.getString((Object)"FileChooser.fileNameLabelText", locale);
        this.filesOfTypeLabelMnemonic = this.getMnemonic("FileChooser.filesOfTypeLabelMnemonic", locale);
        this.filesOfTypeLabelText = UIManager.getString((Object)"FileChooser.filesOfTypeLabelText", locale);
    }

    private int getMnemonic(String string, Locale locale) {
        String string2 = (String)UIManager.get(string, locale);
        if (string2 != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public String getFileName() {
        if (this.fileNameTextField != null) {
            return this.fileNameTextField.getText();
        }
        return null;
    }

    public void setFileName(String string) {
        if (this.fileNameTextField != null) {
            this.fileNameTextField.setText(string);
        }
    }

    protected void doSelectedFileChanged(PropertyChangeEvent propertyChangeEvent) {
        super.doSelectedFileChanged(propertyChangeEvent);
        File file = (File)propertyChangeEvent.getNewValue();
        JFileChooser jFileChooser = this.getFileChooser();
        if (file != null && (jFileChooser.isFileSelectionEnabled() && !file.isDirectory() || file.isDirectory() && jFileChooser.isDirectorySelectionEnabled())) {
            this.setFileName(this.fileNameString(file));
        }
    }

    protected void doSelectedFilesChanged(PropertyChangeEvent propertyChangeEvent) {
        super.doSelectedFilesChanged(propertyChangeEvent);
        File[] fileArray = (File[])propertyChangeEvent.getNewValue();
        JFileChooser jFileChooser = this.getFileChooser();
        if (fileArray != null && fileArray.length > 0 && (fileArray.length > 1 || jFileChooser.isDirectorySelectionEnabled() || !fileArray[0].isDirectory())) {
            this.setFileName(this.fileNameString(fileArray));
        }
    }

    protected void doDirectoryChanged(PropertyChangeEvent propertyChangeEvent) {
        super.doDirectoryChanged(propertyChangeEvent);
        JFileChooser jFileChooser = this.getFileChooser();
        FileSystemView fileSystemView = jFileChooser.getFileSystemView();
        File file = this.getFileChooser().getCurrentDirectory();
        if (file != null) {
            ComboBoxModel comboBoxModel;
            JComponent jComponent = this.getDirectoryComboBox();
            if (jComponent instanceof JComboBox && (comboBoxModel = ((JComboBox)jComponent).getModel()) instanceof DirectoryComboBoxModel) {
                ((DirectoryComboBoxModel)comboBoxModel).addItem(file);
            }
            if (jFileChooser.isDirectorySelectionEnabled() && !jFileChooser.isFileSelectionEnabled()) {
                if (fileSystemView.isFileSystem(file)) {
                    this.setFileName(file.getPath());
                } else {
                    this.setFileName(null);
                }
            }
        }
    }

    protected void doFileSelectionModeChanged(PropertyChangeEvent propertyChangeEvent) {
        super.doFileSelectionModeChanged(propertyChangeEvent);
        JFileChooser jFileChooser = this.getFileChooser();
        File file = jFileChooser.getCurrentDirectory();
        if (file != null && jFileChooser.isDirectorySelectionEnabled() && !jFileChooser.isFileSelectionEnabled() && jFileChooser.getFileSystemView().isFileSystem(file)) {
            this.setFileName(file.getPath());
        } else {
            this.setFileName(null);
        }
    }

    protected void doAccessoryChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.getAccessoryPanel() != null) {
            JComponent jComponent;
            if (propertyChangeEvent.getOldValue() != null) {
                this.getAccessoryPanel().remove((JComponent)propertyChangeEvent.getOldValue());
            }
            if ((jComponent = (JComponent)propertyChangeEvent.getNewValue()) != null) {
                this.getAccessoryPanel().add((Component)jComponent, "Center");
            }
        }
    }

    protected void doControlButtonsChanged(PropertyChangeEvent propertyChangeEvent) {
        super.doControlButtonsChanged(propertyChangeEvent);
        if (this.getFileChooser().getControlButtonsAreShown()) {
            this.addControlButtons();
        } else {
            this.removeControlButtons();
        }
    }

    protected void addControlButtons() {
        if (this.bottomPanel != null) {
            this.bottomPanel.add(this.buttonPanel);
        }
    }

    protected void removeControlButtons() {
        if (this.bottomPanel != null) {
            this.bottomPanel.remove(this.buttonPanel);
        }
    }

    protected JComponent getDirectoryComboBox() {
        return this.directoryComboBox;
    }

    protected Action getDirectoryComboBoxAction() {
        return this.directoryComboBoxAction;
    }

    protected DirectoryComboBoxRenderer createDirectoryComboBoxRenderer(JFileChooser jFileChooser) {
        return new DirectoryComboBoxRenderer();
    }

    protected DirectoryComboBoxModel createDirectoryComboBoxModel(JFileChooser jFileChooser) {
        return new DirectoryComboBoxModel();
    }

    protected FilterComboBoxRenderer createFilterComboBoxRenderer() {
        return new FilterComboBoxRenderer();
    }

    protected FilterComboBoxModel createFilterComboBoxModel() {
        return new FilterComboBoxModel();
    }

    private static void groupLabels(AlignedLabel[] alignedLabelArray) {
        for (int i2 = 0; i2 < alignedLabelArray.length; ++i2) {
            AlignedLabel.access$902(alignedLabelArray[i2], alignedLabelArray);
        }
    }

    private class AlignedLabel
    extends JLabel {
        private AlignedLabel[] group;
        private int maxWidth;

        AlignedLabel(String string) {
            super(string);
            this.maxWidth = 0;
            this.setAlignmentX(0.0f);
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            return new Dimension(this.getMaxWidth() + 11, dimension.height);
        }

        private int getMaxWidth() {
            if (this.maxWidth == 0 && this.group != null) {
                int n2;
                int n3 = 0;
                for (n2 = 0; n2 < this.group.length; ++n2) {
                    n3 = Math.max(this.group[n2].getSuperPreferredWidth(), n3);
                }
                for (n2 = 0; n2 < this.group.length; ++n2) {
                    this.group[n2].maxWidth = n3;
                }
            }
            return this.maxWidth;
        }

        private int getSuperPreferredWidth() {
            return super.getPreferredSize().width;
        }

        static /* synthetic */ AlignedLabel[] access$902(AlignedLabel alignedLabel, AlignedLabel[] alignedLabelArray) {
            alignedLabel.group = alignedLabelArray;
            return alignedLabelArray;
        }
    }

    private static class ButtonAreaLayout
    implements LayoutManager {
        private int hGap = 5;
        private int topMargin = 17;

        private ButtonAreaLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void layoutContainer(Container container) {
            Component[] componentArray = container.getComponents();
            if (componentArray != null && componentArray.length > 0) {
                int n2;
                int n3;
                int n4 = componentArray.length;
                Dimension[] dimensionArray = new Dimension[n4];
                Insets insets = container.getInsets();
                int n5 = insets.top + this.topMargin;
                int n6 = 0;
                for (n3 = 0; n3 < n4; ++n3) {
                    dimensionArray[n3] = componentArray[n3].getPreferredSize();
                    n6 = Math.max(n6, dimensionArray[n3].width);
                }
                if (container.getComponentOrientation().isLeftToRight()) {
                    n3 = container.getSize().width - insets.left - n6;
                    n2 = this.hGap + n6;
                } else {
                    n3 = insets.left;
                    n2 = -(this.hGap + n6);
                }
                for (int i2 = n4 - 1; i2 >= 0; --i2) {
                    componentArray[i2].setBounds(n3, n5, n6, dimensionArray[i2].height);
                    n3 -= n2;
                }
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            Component[] componentArray;
            if (container != null && (componentArray = container.getComponents()) != null && componentArray.length > 0) {
                int n2 = componentArray.length;
                int n3 = 0;
                Insets insets = container.getInsets();
                int n4 = this.topMargin + insets.top + insets.bottom;
                int n5 = insets.left + insets.right;
                int n6 = 0;
                for (int i2 = 0; i2 < n2; ++i2) {
                    Dimension dimension = componentArray[i2].getPreferredSize();
                    n3 = Math.max(n3, dimension.height);
                    n6 = Math.max(n6, dimension.width);
                }
                return new Dimension(n5 + n2 * n6 + (n2 - 1) * this.hGap, n4 + n3);
            }
            return new Dimension(0, 0);
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.minimumLayoutSize(container);
        }

        public void removeLayoutComponent(Component component) {
        }
    }

    protected class DirectoryComboBoxAction
    extends AbstractAction {
        protected DirectoryComboBoxAction() {
            super("DirectoryComboBoxAction");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SynthFileChooserUIImpl.this.directoryComboBox.hidePopup();
            JComponent jComponent = SynthFileChooserUIImpl.this.getDirectoryComboBox();
            if (jComponent instanceof JComboBox) {
                File file = (File)((JComboBox)jComponent).getSelectedItem();
                SynthFileChooserUIImpl.this.getFileChooser().setCurrentDirectory(file);
            }
        }
    }

    protected class DirectoryComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        Vector directories = new Vector();
        int[] depths = null;
        File selectedDirectory = null;
        JFileChooser chooser = SynthFileChooserUIImpl.this.getFileChooser();
        FileSystemView fsv = this.chooser.getFileSystemView();

        public DirectoryComboBoxModel() {
            File file = SynthFileChooserUIImpl.this.getFileChooser().getCurrentDirectory();
            if (file != null) {
                this.addItem(file);
            }
        }

        public void addItem(File file) {
            if (file == null) {
                return;
            }
            int n2 = this.directories.size();
            this.directories.clear();
            if (n2 > 0) {
                this.fireIntervalRemoved(this, 0, n2);
            }
            File[] fileArray = SynthFileChooserUIImpl.this.useShellFolder ? (File[])ShellFolder.get("fileChooserComboBoxFolders") : this.fsv.getRoots();
            this.directories.addAll(Arrays.asList(fileArray));
            File file2 = null;
            try {
                file2 = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                file2 = file;
            }
            try {
                File file3;
                File file4 = file3 = SynthFileChooserUIImpl.this.useShellFolder ? ShellFolder.getShellFolder(file2) : file2;
                Vector<File> vector = new Vector<File>(10);
                do {
                    vector.addElement(file4);
                } while ((file4 = file4.getParentFile()) != null);
                int n3 = vector.size();
                for (int i2 = 0; i2 < n3; ++i2) {
                    file4 = (File)vector.get(i2);
                    if (!this.directories.contains(file4)) continue;
                    int n4 = this.directories.indexOf(file4);
                    for (int i3 = i2 - 1; i3 >= 0; --i3) {
                        this.directories.insertElementAt(vector.get(i3), n4 + i2 - i3);
                    }
                    break;
                }
                this.calculateDepths();
                this.setSelectedItem(file3);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.calculateDepths();
            }
        }

        private void calculateDepths() {
            this.depths = new int[this.directories.size()];
            block0: for (int i2 = 0; i2 < this.depths.length; ++i2) {
                File file = (File)this.directories.get(i2);
                File file2 = file.getParentFile();
                this.depths[i2] = 0;
                if (file2 == null) continue;
                for (int i3 = i2 - 1; i3 >= 0; --i3) {
                    if (!file2.equals((File)this.directories.get(i3))) continue;
                    this.depths[i2] = this.depths[i3] + 1;
                    continue block0;
                }
            }
        }

        public int getDepth(int n2) {
            return this.depths != null && n2 >= 0 && n2 < this.depths.length ? this.depths[n2] : 0;
        }

        public void setSelectedItem(Object object) {
            this.selectedDirectory = (File)object;
            this.fireContentsChanged(this, -1, -1);
        }

        public Object getSelectedItem() {
            return this.selectedDirectory;
        }

        public int getSize() {
            return this.directories.size();
        }

        public Object getElementAt(int n2) {
            return this.directories.elementAt(n2);
        }
    }

    class DirectoryComboBoxRenderer
    extends DefaultListCellRenderer {
        IndentIcon ii;

        DirectoryComboBoxRenderer() {
            this.ii = new IndentIcon();
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
            Icon icon;
            super.getListCellRendererComponent(jList, object, n2, bl2, bl3);
            if (object == null) {
                this.setText("");
                return this;
            }
            File file = (File)object;
            this.setText(SynthFileChooserUIImpl.this.getFileChooser().getName(file));
            this.ii.icon = icon = SynthFileChooserUIImpl.this.getFileChooser().getIcon(file);
            this.ii.depth = SynthFileChooserUIImpl.this.directoryComboBoxModel.getDepth(n2);
            this.setIcon(this.ii);
            return this;
        }
    }

    protected class FilterComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        protected FileFilter[] filters;

        protected FilterComboBoxModel() {
            this.filters = SynthFileChooserUIImpl.this.getFileChooser().getChoosableFileFilters();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == "ChoosableFileFilterChangedProperty") {
                this.filters = (FileFilter[])propertyChangeEvent.getNewValue();
                this.fireContentsChanged(this, -1, -1);
            } else if (string == "fileFilterChanged") {
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public void setSelectedItem(Object object) {
            if (object != null) {
                SynthFileChooserUIImpl.this.getFileChooser().setFileFilter((FileFilter)object);
                SynthFileChooserUIImpl.this.setFileName(null);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public Object getSelectedItem() {
            FileFilter fileFilter = SynthFileChooserUIImpl.this.getFileChooser().getFileFilter();
            boolean bl2 = false;
            if (fileFilter != null) {
                for (int i2 = 0; i2 < this.filters.length; ++i2) {
                    if (this.filters[i2] != fileFilter) continue;
                    bl2 = true;
                }
                if (!bl2) {
                    SynthFileChooserUIImpl.this.getFileChooser().addChoosableFileFilter(fileFilter);
                }
            }
            return SynthFileChooserUIImpl.this.getFileChooser().getFileFilter();
        }

        public int getSize() {
            if (this.filters != null) {
                return this.filters.length;
            }
            return 0;
        }

        public Object getElementAt(int n2) {
            if (n2 > this.getSize() - 1) {
                return SynthFileChooserUIImpl.this.getFileChooser().getFileFilter();
            }
            if (this.filters != null) {
                return this.filters[n2];
            }
            return null;
        }
    }

    public class FilterComboBoxRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
            super.getListCellRendererComponent(jList, object, n2, bl2, bl3);
            if (object != null && object instanceof FileFilter) {
                this.setText(((FileFilter)object).getDescription());
            }
            return this;
        }
    }

    class IndentIcon
    implements Icon {
        Icon icon = null;
        int depth = 0;

        IndentIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            if (this.icon != null) {
                if (component.getComponentOrientation().isLeftToRight()) {
                    this.icon.paintIcon(component, graphics, n2 + this.depth * 10, n3);
                } else {
                    this.icon.paintIcon(component, graphics, n2, n3);
                }
            }
        }

        public int getIconWidth() {
            return (this.icon != null ? this.icon.getIconWidth() : 0) + this.depth * 10;
        }

        public int getIconHeight() {
            return this.icon != null ? this.icon.getIconHeight() : 0;
        }
    }

    private class SynthFileChooserUIAccessor
    implements FilePane.FileChooserUIAccessor {
        private SynthFileChooserUIAccessor() {
        }

        public JFileChooser getFileChooser() {
            return SynthFileChooserUIImpl.this.getFileChooser();
        }

        public BasicDirectoryModel getModel() {
            return SynthFileChooserUIImpl.this.getModel();
        }

        public JPanel createList() {
            return null;
        }

        public JPanel createDetailsView() {
            return null;
        }

        public boolean isDirectorySelected() {
            return SynthFileChooserUIImpl.this.isDirectorySelected();
        }

        public File getDirectory() {
            return SynthFileChooserUIImpl.this.getDirectory();
        }

        public Action getChangeToParentDirectoryAction() {
            return SynthFileChooserUIImpl.this.getChangeToParentDirectoryAction();
        }

        public Action getApproveSelectionAction() {
            return SynthFileChooserUIImpl.this.getApproveSelectionAction();
        }

        public Action getNewFolderAction() {
            return SynthFileChooserUIImpl.this.getNewFolderAction();
        }

        public MouseListener createDoubleClickListener(JList jList) {
            return SynthFileChooserUIImpl.this.createDoubleClickListener(this.getFileChooser(), jList);
        }

        public ListSelectionListener createListSelectionListener() {
            return SynthFileChooserUIImpl.this.createListSelectionListener(this.getFileChooser());
        }
    }
}

