/*
 * Decompiled with CFR 0.152.
 */
package sun.management.snmp.util;

import com.sun.jmx.snmp.SnmpOid;
import java.util.Arrays;
import java.util.Comparator;
import java.util.TreeMap;
import sun.management.snmp.util.SnmpTableHandler;

public class SnmpCachedData
implements SnmpTableHandler {
    public static final Comparator oidComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            return ((SnmpOid)object).compareTo((SnmpOid)object2);
        }

        public boolean equals(Object object, Object object2) {
            if (object == object2) {
                return true;
            }
            return object.equals(object2);
        }
    };
    public final long lastUpdated;
    public final SnmpOid[] indexes;
    public final Object[] datas;

    public SnmpCachedData(long l2, SnmpOid[] snmpOidArray, Object[] objectArray) {
        this.lastUpdated = l2;
        this.indexes = snmpOidArray;
        this.datas = objectArray;
    }

    public SnmpCachedData(long l2, TreeMap treeMap) {
        this(l2, treeMap, true);
    }

    public SnmpCachedData(long l2, TreeMap treeMap, boolean bl2) {
        int n2 = treeMap.size();
        this.lastUpdated = l2;
        this.indexes = new SnmpOid[n2];
        this.datas = new Object[n2];
        if (bl2) {
            treeMap.keySet().toArray(this.indexes);
            treeMap.values().toArray(this.datas);
        } else {
            treeMap.values().toArray(this.datas);
        }
    }

    public final int find(SnmpOid snmpOid) {
        return Arrays.binarySearch(this.indexes, snmpOid, oidComparator);
    }

    public Object getData(SnmpOid snmpOid) {
        int n2 = this.find(snmpOid);
        if (n2 < 0 || n2 >= this.datas.length) {
            return null;
        }
        return this.datas[n2];
    }

    public SnmpOid getNext(SnmpOid snmpOid) {
        if (snmpOid == null) {
            if (this.indexes.length > 0) {
                return this.indexes[0];
            }
            return null;
        }
        int n2 = this.find(snmpOid);
        if (n2 > -1) {
            if (n2 < this.indexes.length - 1) {
                return this.indexes[n2 + 1];
            }
            return null;
        }
        int n3 = -n2 - 1;
        if (n3 > -1 && n3 < this.indexes.length) {
            return this.indexes[n3];
        }
        return null;
    }

    public boolean contains(SnmpOid snmpOid) {
        int n2 = this.find(snmpOid);
        return n2 > -1 && n2 < this.indexes.length;
    }
}

