/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import sun.awt.image.ImageDecoder;
import sun.awt.image.InputStreamImageSource;

public class URLImageSource
extends InputStreamImageSource {
    URL url;
    URLConnection conn;
    String actualHost;
    int actualPort;

    public URLImageSource(URL uRL) {
        block7: {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                try {
                    Permission permission = uRL.openConnection().getPermission();
                    if (permission == null) break block7;
                    try {
                        securityManager.checkPermission(permission);
                    }
                    catch (SecurityException securityException) {
                        if (permission instanceof FilePermission && permission.getActions().indexOf("read") != -1) {
                            securityManager.checkRead(permission.getName());
                            break block7;
                        }
                        if (permission instanceof SocketPermission && permission.getActions().indexOf("connect") != -1) {
                            securityManager.checkConnect(uRL.getHost(), uRL.getPort());
                            break block7;
                        }
                        throw securityException;
                    }
                }
                catch (IOException iOException) {
                    securityManager.checkConnect(uRL.getHost(), uRL.getPort());
                }
            }
        }
        this.url = uRL;
    }

    public URLImageSource(String string) throws MalformedURLException {
        this(new URL(null, string));
    }

    public URLImageSource(URL uRL, URLConnection uRLConnection) {
        this(uRL);
        this.conn = uRLConnection;
    }

    public URLImageSource(URLConnection uRLConnection) {
        this(uRLConnection.getURL(), uRLConnection);
    }

    final boolean checkSecurity(Object object, boolean bl2) {
        if (this.actualHost != null) {
            try {
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    securityManager.checkConnect(this.actualHost, this.actualPort, object);
                }
            }
            catch (SecurityException securityException) {
                if (!bl2) {
                    throw securityException;
                }
                return false;
            }
        }
        return true;
    }

    private synchronized URLConnection getConnection() throws IOException {
        URLConnection uRLConnection;
        if (this.conn != null) {
            uRLConnection = this.conn;
            this.conn = null;
        } else {
            uRLConnection = this.url.openConnection();
        }
        return uRLConnection;
    }

    protected ImageDecoder getDecoder() {
        Object object;
        InputStream inputStream = null;
        String string = null;
        try {
            object = this.getConnection();
            inputStream = ((URLConnection)object).getInputStream();
            string = ((URLConnection)object).getContentType();
            URL uRL = ((URLConnection)object).getURL();
            if (!(uRL == this.url || uRL.getHost().equals(this.url.getHost()) && uRL.getPort() == this.url.getPort())) {
                if (!(this.actualHost == null || this.actualHost.equals(uRL.getHost()) && this.actualPort == uRL.getPort())) {
                    throw new SecurityException("image moved!");
                }
                this.actualHost = uRL.getHost();
                this.actualPort = uRL.getPort();
            }
        }
        catch (IOException iOException) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
            return null;
        }
        object = this.decoderForType(inputStream, string);
        if (object == null) {
            object = this.getDecoder(inputStream);
        }
        return object;
    }
}

