/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.Color;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import sun.awt.image.ImageDecoder;
import sun.awt.image.ImageFormatException;
import sun.awt.image.InputStreamImageSource;
import sun.awt.image.PNGFilterInputStream;

public class PNGImageDecoder
extends ImageDecoder {
    private static final int GRAY = 0;
    private static final int PALETTE = 1;
    private static final int COLOR = 2;
    private static final int ALPHA = 4;
    private static final int bKGDChunk = 1649100612;
    private static final int cHRMChunk = 1665684045;
    private static final int gAMAChunk = 1732332865;
    private static final int hISTChunk = 1749635924;
    private static final int IDATChunk = 1229209940;
    private static final int IENDChunk = 1229278788;
    private static final int IHDRChunk = 1229472850;
    private static final int PLTEChunk = 1347179589;
    private static final int pHYsChunk = 1883789683;
    private static final int sBITChunk = 1933723988;
    private static final int tEXtChunk = 1950701684;
    private static final int tIMEChunk = 1950960965;
    private static final int tRNSChunk = 1951551059;
    private static final int zTXtChunk = 2052348020;
    private int width;
    private int height;
    private int bitDepth;
    private int colorType;
    private int compressionMethod;
    private int filterMethod;
    private int interlaceMethod;
    private int gamma = 100000;
    private Hashtable properties;
    private ColorModel cm;
    private byte[] red_map;
    private byte[] green_map;
    private byte[] blue_map;
    private byte[] alpha_map;
    private int transparentPixel = -1;
    private static ColorModel[] greyModels = new ColorModel[4];
    private static final byte[] startingRow = new byte[]{0, 0, 0, 4, 0, 2, 0, 1};
    private static final byte[] startingCol = new byte[]{0, 0, 4, 0, 2, 0, 1, 0};
    private static final byte[] rowIncrement = new byte[]{1, 8, 8, 8, 4, 4, 2, 2};
    private static final byte[] colIncrement = new byte[]{1, 8, 8, 4, 4, 2, 2, 1};
    private static final byte[] blockHeight = new byte[]{1, 8, 8, 4, 4, 2, 2, 1};
    private static final byte[] blockWidth = new byte[]{1, 8, 4, 4, 2, 2, 1, 1};
    int pos;
    int limit;
    int chunkStart;
    int chunkKey;
    int chunkLength;
    int chunkCRC;
    boolean seenEOF;
    private static final byte[] signature = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    PNGFilterInputStream inputStream;
    InputStream underlyingInputStream;
    byte[] inbuf = new byte[4096];
    private static boolean checkCRC = true;
    private static final int[] crc_table = new int[256];

    private void property(String string, Object object) {
        if (object == null) {
            return;
        }
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        this.properties.put(string, object);
    }

    private void property(String string, float f2) {
        this.property(string, new Float(f2));
    }

    private final void pngassert(boolean bl2) throws IOException {
        if (!bl2) {
            PNGException pNGException = new PNGException("Broken file");
            pNGException.printStackTrace();
            throw pNGException;
        }
    }

    protected boolean handleChunk(int n2, byte[] byArray, int n3, int n4) throws IOException {
        switch (n2) {
            case 1649100612: {
                Color color = null;
                switch (this.colorType) {
                    case 2: 
                    case 6: {
                        this.pngassert(n4 == 6);
                        color = new Color(byArray[n3] & 0xFF, byArray[n3 + 2] & 0xFF, byArray[n3 + 4] & 0xFF);
                        break;
                    }
                    case 3: 
                    case 7: {
                        this.pngassert(n4 == 1);
                        int n5 = byArray[n3] & 0xFF;
                        this.pngassert(this.red_map != null && n5 < this.red_map.length);
                        color = new Color(this.red_map[n5] & 0xFF, this.green_map[n5] & 0xFF, this.blue_map[n5] & 0xFF);
                        break;
                    }
                    case 0: 
                    case 4: {
                        this.pngassert(n4 == 2);
                        int n6 = byArray[n3] & 0xFF;
                        color = new Color(n6, n6, n6);
                    }
                }
                if (color == null) break;
                this.property("background", color);
                break;
            }
            case 1665684045: {
                this.property("chromaticities", new Chromaticities(this.getInt(n3), this.getInt(n3 + 4), this.getInt(n3 + 8), this.getInt(n3 + 12), this.getInt(n3 + 16), this.getInt(n3 + 20), this.getInt(n3 + 24), this.getInt(n3 + 28)));
                break;
            }
            case 1732332865: {
                if (n4 != 4) {
                    throw new PNGException("bogus gAMA");
                }
                this.gamma = this.getInt(n3);
                if (this.gamma == 100000) break;
                this.property("gamma", (float)this.gamma / 100000.0f);
                break;
            }
            case 1749635924: {
                break;
            }
            case 1229209940: {
                return false;
            }
            case 1229278788: {
                break;
            }
            case 1229472850: {
                if (n4 != 13 || (this.width = this.getInt(n3)) == 0 || (this.height = this.getInt(n3 + 4)) == 0) {
                    throw new PNGException("bogus IHDR");
                }
                this.bitDepth = this.getByte(n3 + 8);
                this.colorType = this.getByte(n3 + 9);
                this.compressionMethod = this.getByte(n3 + 10);
                this.filterMethod = this.getByte(n3 + 11);
                this.interlaceMethod = this.getByte(n3 + 12);
                break;
            }
            case 1347179589: {
                int n7 = n4 / 3;
                this.red_map = new byte[n7];
                this.green_map = new byte[n7];
                this.blue_map = new byte[n7];
                int n8 = 0;
                int n9 = n3;
                while (n8 < n7) {
                    this.red_map[n8] = byArray[n9];
                    this.green_map[n8] = byArray[n9 + 1];
                    this.blue_map[n8] = byArray[n9 + 2];
                    ++n8;
                    n9 += 3;
                }
                break;
            }
            case 1883789683: {
                break;
            }
            case 1933723988: {
                break;
            }
            case 1950701684: {
                int n10;
                for (n10 = 0; n10 < n4 && byArray[n3 + n10] != 0; ++n10) {
                }
                if (n10 >= n4) break;
                String string = new String(byArray, n3, n10);
                String string2 = new String(byArray, n3 + n10 + 1, n4 - n10 - 1);
                this.property(string, string2);
                break;
            }
            case 1950960965: {
                this.property("modtime", new GregorianCalendar(this.getShort(n3 + 0), this.getByte(n3 + 2) - 1, this.getByte(n3 + 3), this.getByte(n3 + 4), this.getByte(n3 + 5), this.getByte(n3 + 6)).getTime());
                break;
            }
            case 1951551059: {
                switch (this.colorType) {
                    case 3: 
                    case 7: {
                        int n11 = n4;
                        if (this.red_map != null) {
                            n11 = this.red_map.length;
                        }
                        this.alpha_map = new byte[n11];
                        System.arraycopy(byArray, n3, this.alpha_map, 0, n4 < n11 ? n4 : n11);
                        while (--n11 >= n4) {
                            this.alpha_map[n11] = -1;
                        }
                        break;
                    }
                    case 2: 
                    case 6: {
                        this.pngassert(n4 == 6);
                        this.transparentPixel = (byArray[n3 + 0] & 0xFF) << 16 | (byArray[n3 + 2] & 0xFF) << 8 | byArray[n3 + 4] & 0xFF;
                        break;
                    }
                    case 0: 
                    case 4: {
                        this.pngassert(n4 == 2);
                        int n12 = byArray[n3] & 0xFF;
                        this.transparentPixel = n12 << 16 | n12 << 8 | n12;
                    }
                }
                break;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void produceImage() throws IOException, ImageFormatException {
        try {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            for (int i2 = 0; i2 < signature.length; ++i2) {
                if ((signature[i2] & 0xFF) == this.underlyingInputStream.read()) continue;
                throw new PNGException("Chunk signature mismatch");
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new InflaterInputStream(this.inputStream, new Inflater()));
            this.getData();
            byte[] byArray = null;
            int[] nArray = null;
            int n8 = this.width;
            int n9 = 0;
            switch (this.bitDepth) {
                case 1: {
                    n9 = 0;
                    break;
                }
                case 2: {
                    n9 = 1;
                    break;
                }
                case 4: {
                    n9 = 2;
                    break;
                }
                case 8: {
                    n9 = 3;
                    break;
                }
                case 16: {
                    n9 = 4;
                    break;
                }
                default: {
                    throw new PNGException("invalid depth");
                }
            }
            if (this.interlaceMethod != 0) {
                n8 *= this.height;
                n7 = this.width;
            } else {
                n7 = 0;
            }
            int n10 = this.colorType | this.bitDepth << 3;
            int n11 = (1 << (this.bitDepth >= 8 ? 8 : this.bitDepth)) - 1;
            switch (this.colorType) {
                case 3: 
                case 7: {
                    if (this.red_map == null) {
                        throw new PNGException("palette expected");
                    }
                    this.cm = this.alpha_map == null ? new IndexColorModel(this.bitDepth, this.red_map.length, this.red_map, this.green_map, this.blue_map) : new IndexColorModel(this.bitDepth, this.red_map.length, this.red_map, this.green_map, this.blue_map, this.alpha_map);
                    byArray = new byte[n8];
                    break;
                }
                case 0: {
                    n6 = n9 >= 4 ? 3 : n9;
                    this.cm = greyModels[n6];
                    if (this.cm == null) {
                        n5 = 1 << (1 << n6);
                        byte[] byArray2 = new byte[n5];
                        for (n4 = 0; n4 < n5; ++n4) {
                            byArray2[n4] = (byte)(255 * n4 / (n5 - 1));
                        }
                        PNGImageDecoder.greyModels[n6] = this.cm = new IndexColorModel(this.bitDepth, byArray2.length, byArray2, byArray2, byArray2);
                    }
                    byArray = new byte[n8];
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    this.cm = ColorModel.getRGBdefault();
                    nArray = new int[n8];
                    break;
                }
                default: {
                    throw new PNGException("invalid color type");
                }
            }
            this.setDimensions(this.width, this.height);
            this.setColorModel(this.cm);
            n6 = this.interlaceMethod != 0 ? 6 : 30;
            this.setHints(n6);
            this.headerComplete();
            n5 = (this.colorType & 1) != 0 ? 1 : ((this.colorType & 2) != 0 ? 3 : 1) + ((this.colorType & 4) != 0 ? 1 : 0);
            int n12 = n5 * this.bitDepth;
            n4 = n12 + 7 >> 3;
            if (this.interlaceMethod == 0) {
                n3 = -1;
                n2 = 0;
            } else {
                n3 = 0;
                n2 = 7;
            }
            while (++n3 <= n2) {
                int n13 = startingRow[n3];
                byte by = rowIncrement[n3];
                byte by2 = colIncrement[n3];
                byte by3 = blockWidth[n3];
                byte by4 = blockHeight[n3];
                int n14 = startingCol[n3];
                int n15 = (this.width - n14 + (by2 - 1)) / by2;
                int n16 = n15 * n12 + 7 >> 3;
                if (n16 == 0) continue;
                int n17 = this.interlaceMethod == 0 ? by * this.width : 0;
                int n18 = n7 * n13;
                boolean bl2 = true;
                byte[] byArray3 = new byte[n16];
                byte[] byArray4 = new byte[n16];
                while (n13 < this.height) {
                    int n19;
                    int n20;
                    int n21 = ((InputStream)bufferedInputStream).read();
                    for (n19 = 0; n19 < n16; n19 += n20) {
                        n20 = ((InputStream)bufferedInputStream).read(byArray3, n19, n16 - n19);
                        if (n20 > 0) continue;
                        throw new PNGException("missing data");
                    }
                    this.filterRow(byArray3, bl2 ? null : byArray4, n21, n16, n4);
                    n20 = 0;
                    block43: for (n19 = n14; n19 < this.width; n19 += by2) {
                        if (nArray != null) {
                            switch (n10) {
                                case 70: {
                                    nArray[n19 + n18] = (byArray3[n20] & 0xFF) << 16 | (byArray3[n20 + 1] & 0xFF) << 8 | byArray3[n20 + 2] & 0xFF | (byArray3[n20 + 3] & 0xFF) << 24;
                                    n20 += 4;
                                    continue block43;
                                }
                                case 134: {
                                    nArray[n19 + n18] = (byArray3[n20] & 0xFF) << 16 | (byArray3[n20 + 2] & 0xFF) << 8 | byArray3[n20 + 4] & 0xFF | (byArray3[n20 + 6] & 0xFF) << 24;
                                    n20 += 8;
                                    continue block43;
                                }
                                case 66: {
                                    nArray[n19 + n18] = (byArray3[n20] & 0xFF) << 16 | (byArray3[n20 + 1] & 0xFF) << 8 | byArray3[n20 + 2] & 0xFF | 0xFF000000;
                                    n20 += 3;
                                    continue block43;
                                }
                                case 130: {
                                    nArray[n19 + n18] = (byArray3[n20] & 0xFF) << 16 | (byArray3[n20 + 2] & 0xFF) << 8 | byArray3[n20 + 4] & 0xFF | 0xFF000000;
                                    n20 += 6;
                                    continue block43;
                                }
                                case 68: {
                                    int n22 = byArray3[n20] & 0xFF;
                                    nArray[n19 + n18] = n22 << 16 | n22 << 8 | n22 | (byArray3[n20 + 1] & 0xFF) << 24;
                                    n20 += 2;
                                    continue block43;
                                }
                                case 132: {
                                    int n22 = byArray3[n20] & 0xFF;
                                    nArray[n19 + n18] = n22 << 16 | n22 << 8 | n22 | (byArray3[n20 + 2] & 0xFF) << 24;
                                    n20 += 4;
                                    continue block43;
                                }
                                default: {
                                    throw new PNGException("illegal type/depth");
                                }
                            }
                        }
                        switch (this.bitDepth) {
                            case 1: {
                                byArray[n19 + n18] = (byte)(byArray3[n20 >> 3] >> 7 - (n20 & 7) & 1);
                                ++n20;
                                continue block43;
                            }
                            case 2: {
                                byArray[n19 + n18] = (byte)(byArray3[n20 >> 2] >> (3 - (n20 & 3)) * 2 & 3);
                                ++n20;
                                continue block43;
                            }
                            case 4: {
                                byArray[n19 + n18] = (byte)(byArray3[n20 >> 1] >> (1 - (n20 & 1)) * 4 & 0xF);
                                ++n20;
                                continue block43;
                            }
                            case 8: {
                                byArray[n19 + n18] = byArray3[n20++];
                                continue block43;
                            }
                            case 16: {
                                byArray[n19 + n18] = byArray3[n20];
                                n20 += 2;
                                continue block43;
                            }
                            default: {
                                throw new PNGException("illegal type/depth");
                            }
                        }
                    }
                    if (this.interlaceMethod == 0) {
                        if (nArray != null) {
                            this.sendPixels(0, n13, this.width, 1, nArray, 0, this.width);
                        } else {
                            this.sendPixels(0, n13, this.width, 1, byArray, 0, this.width);
                        }
                    }
                    n13 += by;
                    n18 += by * n7;
                    byte[] byArray5 = byArray3;
                    byArray3 = byArray4;
                    byArray4 = byArray5;
                    bl2 = false;
                }
                if (this.interlaceMethod == 0) continue;
                if (nArray != null) {
                    this.sendPixels(0, 0, this.width, this.height, nArray, 0, this.width);
                    continue;
                }
                this.sendPixels(0, 0, this.width, this.height, byArray, 0, this.width);
            }
            this.imageComplete(3, true);
        }
        catch (IOException iOException) {
            if (!this.aborted) {
                this.property("error", iOException);
                this.imageComplete(3, true);
                throw iOException;
            }
        }
        finally {
            try {
                this.close();
            }
            catch (Throwable throwable) {}
        }
    }

    private boolean sendPixels(int n2, int n3, int n4, int n5, int[] nArray, int n6, int n7) {
        int n8 = this.setPixels(n2, n3, n4, n5, this.cm, nArray, n6, n7);
        if (n8 <= 0) {
            this.aborted = true;
        }
        return !this.aborted;
    }

    private boolean sendPixels(int n2, int n3, int n4, int n5, byte[] byArray, int n6, int n7) {
        int n8 = this.setPixels(n2, n3, n4, n5, this.cm, byArray, n6, n7);
        if (n8 <= 0) {
            this.aborted = true;
        }
        return !this.aborted;
    }

    private void filterRow(byte[] byArray, byte[] byArray2, int n2, int n3, int n4) throws IOException {
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                int n5;
                for (n5 = n4; n5 < n3; ++n5) {
                    int n6 = n5;
                    byArray[n6] = (byte)(byArray[n6] + byArray[n5 - n4]);
                }
                break;
            }
            case 2: {
                int n5;
                if (byArray2 == null) break;
                for (n5 = 0; n5 < n3; ++n5) {
                    int n7 = n5;
                    byArray[n7] = (byte)(byArray[n7] + byArray2[n5]);
                }
                break;
            }
            case 3: {
                int n5;
                if (byArray2 != null) {
                    while (n5 < n4) {
                        int n8 = n5;
                        byArray[n8] = (byte)(byArray[n8] + ((0xFF & byArray2[n5]) >> 1));
                        ++n5;
                    }
                    while (n5 < n3) {
                        int n9 = n5;
                        byArray[n9] = (byte)(byArray[n9] + ((byArray2[n5] & 0xFF) + (byArray[n5 - n4] & 0xFF) >> 1));
                        ++n5;
                    }
                } else {
                    for (n5 = n4; n5 < n3; ++n5) {
                        int n10 = n5;
                        byArray[n10] = (byte)(byArray[n10] + ((byArray[n5 - n4] & 0xFF) >> 1));
                    }
                }
                break;
            }
            case 4: {
                int n5;
                if (byArray2 != null) {
                    while (n5 < n4) {
                        int n11 = n5;
                        byArray[n11] = (byte)(byArray[n11] + byArray2[n5]);
                        ++n5;
                    }
                    while (n5 < n3) {
                        int n12 = byArray[n5 - n4] & 0xFF;
                        int n13 = byArray2[n5] & 0xFF;
                        int n14 = byArray2[n5 - n4] & 0xFF;
                        int n15 = n12 + n13 - n14;
                        int n16 = n15 > n12 ? n15 - n12 : n12 - n15;
                        int n17 = n15 > n13 ? n15 - n13 : n13 - n15;
                        int n18 = n15 > n14 ? n15 - n14 : n14 - n15;
                        int n19 = n5;
                        byArray[n19] = (byte)(byArray[n19] + (n16 <= n17 && n16 <= n18 ? n12 : (n17 <= n18 ? n13 : n14)));
                        ++n5;
                    }
                } else {
                    for (n5 = n4; n5 < n3; ++n5) {
                        int n20 = n5;
                        byArray[n20] = (byte)(byArray[n20] + byArray[n5 - n4]);
                    }
                }
                break;
            }
            default: {
                throw new PNGException("Illegal filter");
            }
        }
    }

    public PNGImageDecoder(InputStreamImageSource inputStreamImageSource, InputStream inputStream) throws IOException {
        super(inputStreamImageSource, inputStream);
        this.inputStream = new PNGFilterInputStream(this, inputStream);
        this.underlyingInputStream = this.inputStream.underlyingInputStream;
    }

    private void fill() throws IOException {
        if (!this.seenEOF) {
            if (this.pos > 0 && this.pos < this.limit) {
                System.arraycopy(this.inbuf, this.pos, this.inbuf, 0, this.limit - this.pos);
                this.limit -= this.pos;
                this.pos = 0;
            } else if (this.pos >= this.limit) {
                this.pos = 0;
                this.limit = 0;
            }
            int n2 = this.inbuf.length;
            while (this.limit < n2) {
                int n3 = this.underlyingInputStream.read(this.inbuf, this.limit, n2 - this.limit);
                if (n3 <= 0) {
                    this.seenEOF = true;
                    break;
                }
                this.limit += n3;
            }
        }
    }

    private boolean need(int n2) throws IOException {
        if (this.limit - this.pos >= n2) {
            return true;
        }
        this.fill();
        if (this.limit - this.pos >= n2) {
            return true;
        }
        if (this.seenEOF) {
            return false;
        }
        byte[] byArray = new byte[n2 + 100];
        System.arraycopy(this.inbuf, this.pos, byArray, 0, this.limit - this.pos);
        this.limit -= this.pos;
        this.pos = 0;
        this.inbuf = byArray;
        this.fill();
        return this.limit - this.pos >= n2;
    }

    private final int getInt(int n2) {
        return (this.inbuf[n2] & 0xFF) << 24 | (this.inbuf[n2 + 1] & 0xFF) << 16 | (this.inbuf[n2 + 2] & 0xFF) << 8 | this.inbuf[n2 + 3] & 0xFF;
    }

    private final int getShort(int n2) {
        return (short)((this.inbuf[n2] & 0xFF) << 8 | this.inbuf[n2 + 1] & 0xFF);
    }

    private final int getByte(int n2) {
        return this.inbuf[n2] & 0xFF;
    }

    private final boolean getChunk() throws IOException {
        this.chunkLength = 0;
        if (!this.need(8)) {
            return false;
        }
        this.chunkLength = this.getInt(this.pos);
        this.chunkKey = this.getInt(this.pos + 4);
        if (this.chunkLength < 0) {
            throw new PNGException("bogus length: " + this.chunkLength);
        }
        if (!this.need(this.chunkLength + 12)) {
            return false;
        }
        this.chunkCRC = this.getInt(this.pos + 8 + this.chunkLength);
        this.chunkStart = this.pos + 8;
        int n2 = PNGImageDecoder.crc(this.inbuf, this.pos + 4, this.chunkLength + 4);
        if (this.chunkCRC != n2 && checkCRC) {
            throw new PNGException("crc corruption");
        }
        this.pos += this.chunkLength + 12;
        return true;
    }

    private void readAll() throws IOException {
        while (this.getChunk()) {
            this.handleChunk(this.chunkKey, this.inbuf, this.chunkStart, this.chunkLength);
        }
    }

    boolean getData() throws IOException {
        while (this.chunkLength == 0 && this.getChunk()) {
            if (!this.handleChunk(this.chunkKey, this.inbuf, this.chunkStart, this.chunkLength)) continue;
            this.chunkLength = 0;
        }
        return this.chunkLength > 0;
    }

    public static boolean getCheckCRC() {
        return checkCRC;
    }

    public static void setCheckCRC(boolean bl2) {
        checkCRC = bl2;
    }

    protected void wrc(int n2) {
        if ((n2 &= 0xFF) <= 32 || n2 > 122) {
            n2 = 63;
        }
        System.out.write(n2);
    }

    protected void wrk(int n2) {
        this.wrc(n2 >> 24);
        this.wrc(n2 >> 16);
        this.wrc(n2 >> 8);
        this.wrc(n2);
    }

    public void print() {
        this.wrk(this.chunkKey);
        System.out.print(" " + this.chunkLength + "\n");
    }

    private static int update_crc(int n2, byte[] byArray, int n3, int n4) {
        int n5 = n2;
        while (--n4 >= 0) {
            n5 = crc_table[(n5 ^ byArray[n3++]) & 0xFF] ^ n5 >>> 8;
        }
        return n5;
    }

    private static int crc(byte[] byArray, int n2, int n3) {
        return ~PNGImageDecoder.update_crc(-1, byArray, n2, n3);
    }

    static {
        for (int i2 = 0; i2 < 256; ++i2) {
            int n2 = i2;
            for (int i3 = 0; i3 < 8; ++i3) {
                if ((n2 & 1) != 0) {
                    n2 = 0xEDB88320 ^ n2 >>> 1;
                    continue;
                }
                n2 >>>= 1;
            }
            PNGImageDecoder.crc_table[i2] = n2;
        }
    }

    public static class Chromaticities {
        public float whiteX;
        public float whiteY;
        public float redX;
        public float redY;
        public float greenX;
        public float greenY;
        public float blueX;
        public float blueY;

        Chromaticities(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
            this.whiteX = (float)n2 / 100000.0f;
            this.whiteY = (float)n3 / 100000.0f;
            this.redX = (float)n4 / 100000.0f;
            this.redY = (float)n5 / 100000.0f;
            this.greenX = (float)n6 / 100000.0f;
            this.greenY = (float)n7 / 100000.0f;
            this.blueX = (float)n8 / 100000.0f;
            this.blueY = (float)n9 / 100000.0f;
        }

        public String toString() {
            return "Chromaticities(white=" + this.whiteX + "," + this.whiteY + ";red=" + this.redX + "," + this.redY + ";green=" + this.greenX + "," + this.greenY + ";blue=" + this.blueX + "," + this.blueY + ")";
        }
    }

    public class PNGException
    extends IOException {
        PNGException(String string) {
            super(string);
        }
    }
}

