/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;

public class RepaintArea {
    private static final int MAX_BENEFIT_RATIO = 4;
    private static final int HORIZONTAL = 0;
    private static final int VERTICAL = 1;
    private static final int UPDATE = 2;
    private static final int RECT_COUNT = 3;
    private Rectangle[] paintRects = new Rectangle[3];

    public RepaintArea() {
    }

    private RepaintArea(RepaintArea repaintArea) {
        for (int i2 = 0; i2 < 3; ++i2) {
            this.paintRects[i2] = repaintArea.paintRects[i2];
        }
    }

    public synchronized void add(Rectangle rectangle, int n2) {
        if (rectangle.isEmpty()) {
            return;
        }
        int n3 = 2;
        if (n2 == 800) {
            int n4 = n3 = rectangle.width > rectangle.height ? 0 : 1;
        }
        if (this.paintRects[n3] != null) {
            this.paintRects[n3].add(rectangle);
        } else {
            this.paintRects[n3] = new Rectangle(rectangle);
        }
    }

    private synchronized RepaintArea cloneAndReset() {
        RepaintArea repaintArea = new RepaintArea(this);
        for (int i2 = 0; i2 < 3; ++i2) {
            this.paintRects[i2] = null;
        }
        return repaintArea;
    }

    public boolean isEmpty() {
        for (int i2 = 0; i2 < 3; ++i2) {
            if (this.paintRects[i2] == null) continue;
            return false;
        }
        return true;
    }

    public synchronized void constrain(int n2, int n3, int n4, int n5) {
        for (int i2 = 0; i2 < 3; ++i2) {
            int n6;
            int n7;
            Rectangle rectangle = this.paintRects[i2];
            if (rectangle == null) continue;
            if (rectangle.x < n2) {
                rectangle.width -= n2 - rectangle.x;
                rectangle.x = n2;
            }
            if (rectangle.y < n3) {
                rectangle.height -= n3 - rectangle.y;
                rectangle.y = n3;
            }
            if ((n7 = rectangle.x + rectangle.width - n2 - n4) > 0) {
                rectangle.width -= n7;
            }
            if ((n6 = rectangle.y + rectangle.height - n3 - n5) > 0) {
                rectangle.height -= n6;
            }
            if (rectangle.width > 0 && rectangle.height > 0) continue;
            this.paintRects[i2] = null;
        }
    }

    public synchronized void subtract(int n2, int n3, int n4, int n5) {
        Rectangle rectangle = new Rectangle(n2, n3, n4, n5);
        for (int i2 = 0; i2 < 3; ++i2) {
            if (!RepaintArea.subtract(this.paintRects[i2], rectangle) || this.paintRects[i2] == null || !this.paintRects[i2].isEmpty()) continue;
            this.paintRects[i2] = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Object object, boolean bl2) {
        Component component = (Component)object;
        if (this.isEmpty()) {
            return;
        }
        if (!component.isVisible()) {
            return;
        }
        RepaintArea repaintArea = this.cloneAndReset();
        if (!RepaintArea.subtract(repaintArea.paintRects[1], repaintArea.paintRects[0])) {
            RepaintArea.subtract(repaintArea.paintRects[0], repaintArea.paintRects[1]);
        }
        if (repaintArea.paintRects[0] != null && repaintArea.paintRects[1] != null) {
            Rectangle rectangle = repaintArea.paintRects[0].union(repaintArea.paintRects[1]);
            int n2 = rectangle.width * rectangle.height;
            int n3 = n2 - repaintArea.paintRects[0].width * repaintArea.paintRects[0].height - repaintArea.paintRects[1].width * repaintArea.paintRects[1].height;
            if (4 * n3 < n2) {
                repaintArea.paintRects[0] = rectangle;
                repaintArea.paintRects[1] = null;
            }
        }
        for (int i2 = 0; i2 < this.paintRects.length; ++i2) {
            Graphics graphics;
            if (repaintArea.paintRects[i2] == null || repaintArea.paintRects[i2].isEmpty() || (graphics = component.getGraphics()) == null) continue;
            try {
                graphics.setClip(repaintArea.paintRects[i2]);
                if (i2 == 2) {
                    this.updateComponent(component, graphics);
                    continue;
                }
                if (bl2) {
                    graphics.clearRect(repaintArea.paintRects[i2].x, repaintArea.paintRects[i2].y, repaintArea.paintRects[i2].width, repaintArea.paintRects[i2].height);
                }
                this.paintComponent(component, graphics);
                continue;
            }
            finally {
                graphics.dispose();
            }
        }
    }

    protected void updateComponent(Component component, Graphics graphics) {
        if (component != null) {
            component.update(graphics);
        }
    }

    protected void paintComponent(Component component, Graphics graphics) {
        if (component != null) {
            component.paint(graphics);
        }
    }

    static boolean subtract(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle == null || rectangle2 == null) {
            return true;
        }
        Rectangle rectangle3 = rectangle.intersection(rectangle2);
        if (rectangle3.isEmpty()) {
            return true;
        }
        if (rectangle.x == rectangle3.x && rectangle.y == rectangle3.y) {
            if (rectangle.width == rectangle3.width) {
                rectangle.y += rectangle3.height;
                rectangle.height -= rectangle3.height;
                return true;
            }
            if (rectangle.height == rectangle3.height) {
                rectangle.x += rectangle3.width;
                rectangle.width -= rectangle3.width;
                return true;
            }
        } else if (rectangle.x + rectangle.width == rectangle3.x + rectangle3.width && rectangle.y + rectangle.height == rectangle3.y + rectangle3.height) {
            if (rectangle.width == rectangle3.width) {
                rectangle.height -= rectangle3.height;
                return true;
            }
            if (rectangle.height == rectangle3.height) {
                rectangle.width -= rectangle3.width;
                return true;
            }
        }
        return false;
    }
}

