/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Shape;
import java.awt.Toolkit;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.GlyphView;
import javax.swing.text.StateInvariantError;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.TabableView;
import javax.swing.text.ViewFactory;

public class LabelView
extends GlyphView
implements TabableView {
    private Font font;
    private Color fg;
    private Color bg;
    private boolean underline;
    private boolean strike;
    private boolean superscript;
    private boolean subscript;

    public LabelView(Element element) {
        super(element);
    }

    final void sync() {
        if (this.font == null) {
            this.setPropertiesFromAttributes();
        }
    }

    protected void setUnderline(boolean bl2) {
        this.underline = bl2;
    }

    protected void setStrikeThrough(boolean bl2) {
        this.strike = bl2;
    }

    protected void setSuperscript(boolean bl2) {
        this.superscript = bl2;
    }

    protected void setSubscript(boolean bl2) {
        this.subscript = bl2;
    }

    protected void setBackground(Color color) {
        this.bg = color;
    }

    protected void setPropertiesFromAttributes() {
        AttributeSet attributeSet = this.getAttributes();
        if (attributeSet != null) {
            Document document = this.getDocument();
            if (document instanceof StyledDocument) {
                StyledDocument styledDocument = (StyledDocument)document;
                this.font = styledDocument.getFont(attributeSet);
                this.fg = styledDocument.getForeground(attributeSet);
                this.bg = attributeSet.isDefined(StyleConstants.Background) ? styledDocument.getBackground(attributeSet) : null;
                this.setUnderline(StyleConstants.isUnderline(attributeSet));
                this.setStrikeThrough(StyleConstants.isStrikeThrough(attributeSet));
                this.setSuperscript(StyleConstants.isSuperscript(attributeSet));
                this.setSubscript(StyleConstants.isSubscript(attributeSet));
            } else {
                throw new StateInvariantError("LabelView needs StyledDocument");
            }
        }
    }

    @Deprecated
    protected FontMetrics getFontMetrics() {
        this.sync();
        Container container = this.getContainer();
        return container != null ? container.getFontMetrics(this.font) : Toolkit.getDefaultToolkit().getFontMetrics(this.font);
    }

    public Color getBackground() {
        this.sync();
        return this.bg;
    }

    public Color getForeground() {
        this.sync();
        return this.fg;
    }

    public Font getFont() {
        this.sync();
        return this.font;
    }

    public boolean isUnderline() {
        this.sync();
        return this.underline;
    }

    public boolean isStrikeThrough() {
        this.sync();
        return this.strike;
    }

    public boolean isSubscript() {
        this.sync();
        return this.subscript;
    }

    public boolean isSuperscript() {
        this.sync();
        return this.superscript;
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.font = null;
        super.changedUpdate(documentEvent, shape, viewFactory);
    }
}

