/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import com.sun.java.swing.SwingUtilities2;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.text.BreakIterator;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.SegmentCache;
import javax.swing.text.StateInvariantError;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.TabExpander;
import javax.swing.text.TabableView;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class GlyphView
extends View
implements TabableView,
Cloneable {
    private byte[] selections = null;
    int offset = 0;
    int length = 0;
    boolean impliedCR;
    private static final String IMPLIED_CR = "CR";
    boolean skipWidth;
    TabExpander expander;
    int x;
    GlyphPainter painter;
    static GlyphPainter defaultPainter;

    public GlyphView(Element element) {
        super(element);
        Element element2 = element.getParentElement();
        AttributeSet attributeSet = element.getAttributes();
        this.impliedCR = attributeSet != null && attributeSet.getAttribute(IMPLIED_CR) != null && element2 != null && element2.getElementCount() > 1;
        this.skipWidth = element.getName().equals("br");
    }

    protected final Object clone() {
        Object object;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            object = null;
        }
        return object;
    }

    public GlyphPainter getGlyphPainter() {
        return this.painter;
    }

    public void setGlyphPainter(GlyphPainter glyphPainter) {
        this.painter = glyphPainter;
    }

    public Segment getText(int n2, int n3) {
        Segment segment = SegmentCache.getSharedSegment();
        try {
            Document document = this.getDocument();
            document.getText(n2, n3 - n2, segment);
        }
        catch (BadLocationException badLocationException) {
            throw new StateInvariantError("GlyphView: Stale view: " + badLocationException);
        }
        return segment;
    }

    public Color getBackground() {
        AttributeSet attributeSet;
        Document document = this.getDocument();
        if (document instanceof StyledDocument && (attributeSet = this.getAttributes()).isDefined(StyleConstants.Background)) {
            return ((StyledDocument)document).getBackground(attributeSet);
        }
        return null;
    }

    public Color getForeground() {
        Document document = this.getDocument();
        if (document instanceof StyledDocument) {
            AttributeSet attributeSet = this.getAttributes();
            return ((StyledDocument)document).getForeground(attributeSet);
        }
        Container container = this.getContainer();
        if (container != null) {
            return container.getForeground();
        }
        return null;
    }

    public Font getFont() {
        Document document = this.getDocument();
        if (document instanceof StyledDocument) {
            AttributeSet attributeSet = this.getAttributes();
            return ((StyledDocument)document).getFont(attributeSet);
        }
        Container container = this.getContainer();
        if (container != null) {
            return container.getFont();
        }
        return null;
    }

    public boolean isUnderline() {
        AttributeSet attributeSet = this.getAttributes();
        return StyleConstants.isUnderline(attributeSet);
    }

    public boolean isStrikeThrough() {
        AttributeSet attributeSet = this.getAttributes();
        return StyleConstants.isStrikeThrough(attributeSet);
    }

    public boolean isSubscript() {
        AttributeSet attributeSet = this.getAttributes();
        return StyleConstants.isSubscript(attributeSet);
    }

    public boolean isSuperscript() {
        AttributeSet attributeSet = this.getAttributes();
        return StyleConstants.isSuperscript(attributeSet);
    }

    public TabExpander getTabExpander() {
        return this.expander;
    }

    protected void checkPainter() {
        if (this.painter == null) {
            if (defaultPainter == null) {
                String string = "javax.swing.text.GlyphPainter1";
                try {
                    ClassLoader classLoader = this.getClass().getClassLoader();
                    Class<?> clazz = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
                    Object obj = clazz.newInstance();
                    if (obj instanceof GlyphPainter) {
                        defaultPainter = (GlyphPainter)obj;
                    }
                }
                catch (Throwable throwable) {
                    throw new StateInvariantError("GlyphView: Can't load glyph painter: " + string);
                }
            }
            this.setGlyphPainter(defaultPainter.getPainter(this, this.getStartOffset(), this.getEndOffset()));
        }
    }

    public float getTabbedSpan(float f2, TabExpander tabExpander) {
        this.checkPainter();
        TabExpander tabExpander2 = this.expander;
        this.expander = tabExpander;
        if (this.expander != tabExpander2) {
            this.preferenceChanged(null, true, false);
        }
        this.x = (int)f2;
        int n2 = this.getStartOffset();
        int n3 = this.getEndOffset();
        float f3 = this.painter.getSpan(this, n2, n3, this.expander, f2);
        return f3;
    }

    public float getPartialSpan(int n2, int n3) {
        this.checkPainter();
        float f2 = this.painter.getSpan(this, n2, n3, this.expander, this.x);
        return f2;
    }

    public int getStartOffset() {
        Element element = this.getElement();
        return this.length > 0 ? element.getStartOffset() + this.offset : element.getStartOffset();
    }

    public int getEndOffset() {
        Element element = this.getElement();
        return this.length > 0 ? element.getStartOffset() + this.offset + this.length : element.getEndOffset();
    }

    private void initSelections(int n2, int n3) {
        int n4 = n3 - n2 + 1;
        if (this.selections == null || n4 > this.selections.length) {
            this.selections = new byte[n4];
            return;
        }
        int n5 = 0;
        while (n5 < n4) {
            this.selections[n5++] = 0;
        }
    }

    public void paint(Graphics graphics, Shape shape) {
        Object object;
        JTextComponent jTextComponent;
        this.checkPainter();
        boolean bl2 = false;
        Container container = this.getContainer();
        int n2 = this.getStartOffset();
        int n3 = this.getEndOffset();
        Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
        Color color = this.getBackground();
        Color color2 = this.getForeground();
        if (container instanceof JTextComponent && !(jTextComponent = (JTextComponent)container).isEnabled()) {
            color2 = jTextComponent.getDisabledTextColor();
        }
        if (color != null) {
            graphics.setColor(color);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        if (container instanceof JTextComponent && (object = (jTextComponent = (JTextComponent)container).getHighlighter()) instanceof LayeredHighlighter) {
            ((LayeredHighlighter)object).paintLayeredHighlights(graphics, n2, n3, shape, jTextComponent, this);
        }
        if (Utilities.isComposedTextElement(this.getElement())) {
            Utilities.paintComposedText(graphics, shape.getBounds(), this);
            bl2 = true;
        } else if (container instanceof JTextComponent) {
            Highlighter.Highlight[] highlightArray;
            jTextComponent = (JTextComponent)container;
            object = jTextComponent.getSelectedTextColor();
            if (jTextComponent.getHighlighter() != null && object != null && !((Color)object).equals(color2) && (highlightArray = jTextComponent.getHighlighter().getHighlights()).length != 0) {
                int n4;
                int n5;
                int n6;
                boolean bl3 = false;
                int n7 = 0;
                for (n6 = 0; n6 < highlightArray.length; ++n6) {
                    Highlighter.Highlight highlight = highlightArray[n6];
                    n5 = highlight.getStartOffset();
                    n4 = highlight.getEndOffset();
                    if (n5 > n3 || n4 < n2 || !SwingUtilities2.useSelectedTextColor(highlight, jTextComponent)) continue;
                    if (n5 <= n2 && n4 >= n3) {
                        this.paintTextUsingColor(graphics, shape, (Color)object, n2, n3);
                        bl2 = true;
                        break;
                    }
                    if (!bl3) {
                        this.initSelections(n2, n3);
                        bl3 = true;
                    }
                    n5 = Math.max(n2, n5);
                    n4 = Math.min(n3, n4);
                    this.paintTextUsingColor(graphics, shape, (Color)object, n5, n4);
                    int n8 = n5 - n2;
                    this.selections[n8] = (byte)(this.selections[n8] + 1);
                    int n9 = n4 - n2;
                    this.selections[n9] = (byte)(this.selections[n9] - 1);
                    ++n7;
                }
                if (!bl2 && n7 > 0) {
                    n6 = -1;
                    int n10 = 0;
                    n5 = n3 - n2;
                    while (n6++ < n5) {
                        while (n6 < n5 && this.selections[n6] == 0) {
                            ++n6;
                        }
                        if (n10 != n6) {
                            this.paintTextUsingColor(graphics, shape, color2, n2 + n10, n2 + n6);
                        }
                        n4 = 0;
                        while (n6 < n5 && (n4 += this.selections[n6]) != 0) {
                            ++n6;
                        }
                        n10 = n6;
                    }
                    bl2 = true;
                }
            }
        }
        if (!bl2) {
            this.paintTextUsingColor(graphics, shape, color2, n2, n3);
        }
    }

    final void paintTextUsingColor(Graphics graphics, Shape shape, Color color, int n2, int n3) {
        graphics.setColor(color);
        this.painter.paint(this, graphics, shape, n2, n3);
        boolean bl2 = this.isUnderline();
        boolean bl3 = this.isStrikeThrough();
        if (bl2 || bl3) {
            int n4;
            Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            View view = this.getParent();
            if (view != null && view.getEndOffset() == n3) {
                Segment segment = this.getText(n2, n3);
                while (segment.count > 0 && Character.isWhitespace(segment.array[segment.count - 1])) {
                    --n3;
                    --segment.count;
                }
                SegmentCache.releaseSharedSegment(segment);
            }
            int n5 = rectangle.x;
            int n6 = this.getStartOffset();
            if (n6 != n2) {
                n5 += (int)this.painter.getSpan(this, n6, n2, this.getTabExpander(), n5);
            }
            int n7 = n5 + (int)this.painter.getSpan(this, n2, n3, this.getTabExpander(), n5);
            int n8 = (int)this.painter.getDescent(this);
            int n9 = rectangle.y + rectangle.height - (int)this.painter.getDescent(this);
            if (bl2) {
                n4 = n9;
                graphics.drawLine(n5, ++n4, n7, n4);
            }
            if (bl3) {
                n4 = n9;
                graphics.drawLine(n5, n4 -= (int)(this.painter.getAscent(this) * 0.3f), n7, n4);
            }
        }
    }

    public float getPreferredSpan(int n2) {
        if (this.impliedCR) {
            return 0.0f;
        }
        this.checkPainter();
        int n3 = this.getStartOffset();
        int n4 = this.getEndOffset();
        switch (n2) {
            case 0: {
                if (this.skipWidth) {
                    return 0.0f;
                }
                float f2 = this.painter.getSpan(this, n3, n4, this.expander, this.x);
                return Math.max(f2, 1.0f);
            }
            case 1: {
                float f3 = this.painter.getHeight(this);
                if (this.isSuperscript()) {
                    f3 += f3 / 3.0f;
                }
                return f3;
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + n2);
    }

    public float getAlignment(int n2) {
        this.checkPainter();
        if (n2 == 1) {
            boolean bl2 = this.isSuperscript();
            boolean bl3 = this.isSubscript();
            float f2 = this.painter.getHeight(this);
            float f3 = this.painter.getDescent(this);
            float f4 = this.painter.getAscent(this);
            float f5 = bl2 ? 1.0f : (bl3 ? (f2 > 0.0f ? (f2 - (f3 + f4 / 2.0f)) / f2 : 0.0f) : (f2 > 0.0f ? (f2 - f3) / f2 : 0.0f));
            return f5;
        }
        return super.getAlignment(n2);
    }

    public Shape modelToView(int n2, Shape shape, Position.Bias bias) throws BadLocationException {
        this.checkPainter();
        return this.painter.modelToView(this, n2, bias, shape);
    }

    public int viewToModel(float f2, float f3, Shape shape, Position.Bias[] biasArray) {
        this.checkPainter();
        return this.painter.viewToModel(this, f2, f3, shape, biasArray);
    }

    public int getBreakWeight(int n2, float f2, float f3) {
        if (n2 == 0) {
            this.checkPainter();
            int n3 = this.getStartOffset();
            int n4 = this.painter.getBoundedPosition(this, n3, f2, f3);
            if (n4 == n3) {
                return 0;
            }
            if (this.getBreakSpot(n3, n4) != -1) {
                return 2000;
            }
            return 1000;
        }
        return super.getBreakWeight(n2, f2, f3);
    }

    public View breakView(int n2, int n3, float f2, float f3) {
        if (n2 == 0) {
            this.checkPainter();
            int n4 = this.painter.getBoundedPosition(this, n3, f2, f3);
            int n5 = this.getBreakSpot(n3, n4);
            if (n5 != -1) {
                n4 = n5;
            }
            if (n3 == this.getStartOffset() && n4 == this.getEndOffset()) {
                return this;
            }
            GlyphView glyphView = (GlyphView)this.createFragment(n3, n4);
            glyphView.x = (int)f2;
            return glyphView;
        }
        return this;
    }

    private int getBreakSpot(int n2, int n3) {
        Document document = this.getDocument();
        if (document != null && Boolean.TRUE.equals(document.getProperty(AbstractDocument.MultiByteProperty))) {
            return this.getBreakSpotUseBreakIterator(n2, n3);
        }
        return this.getBreakSpotUseWhitespace(n2, n3);
    }

    private int getBreakSpotUseWhitespace(int n2, int n3) {
        Segment segment = this.getText(n2, n3);
        char c2 = segment.last();
        while (c2 != '\uffff') {
            if (Character.isWhitespace(c2)) {
                SegmentCache.releaseSharedSegment(segment);
                return segment.getIndex() - segment.getBeginIndex() + 1 + n2;
            }
            c2 = segment.previous();
        }
        SegmentCache.releaseSharedSegment(segment);
        return -1;
    }

    private int getBreakSpotUseBreakIterator(int n2, int n3) {
        int n4;
        int n5;
        int n6;
        Element element = this.getElement().getParentElement();
        Container container = this.getContainer();
        if (element == null) {
            n6 = n2;
            n5 = n3;
        } else {
            n6 = element.getStartOffset();
            n5 = element.getEndOffset();
        }
        BreakIterator breakIterator = container != null ? BreakIterator.getLineInstance(container.getLocale()) : BreakIterator.getLineInstance();
        Segment segment = this.getText(n6, n5);
        segment.first();
        breakIterator.setText(segment);
        if (n3 == n5) {
            n4 = breakIterator.last();
        } else if (n3 + 1 == n5) {
            n4 = breakIterator.next(segment.offset + segment.count - 2);
            if (n4 >= segment.count + segment.offset) {
                n4 = breakIterator.preceding(segment.offset + segment.count - 1);
            }
        } else {
            n4 = breakIterator.preceding(n3 - n6 + segment.offset + 1);
        }
        int n7 = -1;
        if (n4 != -1 && (n4 = n4 - segment.offset + n6) > n2) {
            if (n2 == n6 && n4 == n2) {
                n7 = -1;
            } else if (n4 <= n3) {
                n7 = n4;
            }
        }
        SegmentCache.releaseSharedSegment(segment);
        return n7;
    }

    public View createFragment(int n2, int n3) {
        this.checkPainter();
        Element element = this.getElement();
        GlyphView glyphView = (GlyphView)this.clone();
        glyphView.offset = n2 - element.getStartOffset();
        glyphView.length = n3 - n2;
        glyphView.painter = this.painter.getPainter(glyphView, n2, n3);
        return glyphView;
    }

    public int getNextVisualPositionFrom(int n2, Position.Bias bias, Shape shape, int n3, Position.Bias[] biasArray) throws BadLocationException {
        return this.painter.getNextVisualPositionFrom(this, n2, bias, shape, n3, biasArray);
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.syncCR();
        this.preferenceChanged(null, true, false);
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.syncCR();
        this.preferenceChanged(null, true, false);
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.syncCR();
        this.preferenceChanged(null, true, true);
    }

    private void syncCR() {
        if (this.impliedCR) {
            Element element = this.getElement().getParentElement();
            this.impliedCR = element != null && element.getElementCount() > 1;
        }
    }

    public static abstract class GlyphPainter {
        public abstract float getSpan(GlyphView var1, int var2, int var3, TabExpander var4, float var5);

        public abstract float getHeight(GlyphView var1);

        public abstract float getAscent(GlyphView var1);

        public abstract float getDescent(GlyphView var1);

        public abstract void paint(GlyphView var1, Graphics var2, Shape var3, int var4, int var5);

        public abstract Shape modelToView(GlyphView var1, int var2, Position.Bias var3, Shape var4) throws BadLocationException;

        public abstract int viewToModel(GlyphView var1, float var2, float var3, Shape var4, Position.Bias[] var5);

        public abstract int getBoundedPosition(GlyphView var1, int var2, float var3, float var4);

        public GlyphPainter getPainter(GlyphView glyphView, int n2, int n3) {
            return this;
        }

        public int getNextVisualPositionFrom(GlyphView glyphView, int n2, Position.Bias bias, Shape shape, int n3, Position.Bias[] biasArray) throws BadLocationException {
            int n4 = glyphView.getStartOffset();
            int n5 = glyphView.getEndOffset();
            switch (n3) {
                case 1: 
                case 5: {
                    Point point;
                    if (n2 != -1) {
                        return -1;
                    }
                    Container container = glyphView.getContainer();
                    if (!(container instanceof JTextComponent)) break;
                    Caret caret = ((JTextComponent)container).getCaret();
                    Point point2 = point = caret != null ? caret.getMagicCaretPosition() : null;
                    if (point == null) {
                        biasArray[0] = Position.Bias.Forward;
                        return n4;
                    }
                    int n6 = glyphView.viewToModel(point.x, 0.0f, shape, biasArray);
                    return n6;
                }
                case 3: {
                    if (n4 == glyphView.getDocument().getLength()) {
                        if (n2 == -1) {
                            biasArray[0] = Position.Bias.Forward;
                            return n4;
                        }
                        return -1;
                    }
                    if (n2 == -1) {
                        biasArray[0] = Position.Bias.Forward;
                        return n4;
                    }
                    if (n2 == n5) {
                        return -1;
                    }
                    if (++n2 == n5) {
                        return -1;
                    }
                    biasArray[0] = Position.Bias.Forward;
                    return n2;
                }
                case 7: {
                    if (n4 == glyphView.getDocument().getLength()) {
                        if (n2 == -1) {
                            biasArray[0] = Position.Bias.Forward;
                            return n4;
                        }
                        return -1;
                    }
                    if (n2 == -1) {
                        biasArray[0] = Position.Bias.Forward;
                        return n5 - 1;
                    }
                    if (n2 == n4) {
                        return -1;
                    }
                    biasArray[0] = Position.Bias.Forward;
                    return n2 - 1;
                }
                default: {
                    throw new IllegalArgumentException("Bad direction: " + n3);
                }
            }
            return n2;
        }
    }
}

