/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import javax.swing.DefaultDesktopManager;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.DesktopIconUI;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;

public class BasicDesktopIconUI
extends DesktopIconUI {
    protected JInternalFrame.JDesktopIcon desktopIcon;
    protected JInternalFrame frame;
    protected JComponent iconPane;
    MouseInputListener mouseInputListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicDesktopIconUI();
    }

    public void installUI(JComponent jComponent) {
        DesktopManager desktopManager;
        JDesktopPane jDesktopPane;
        this.desktopIcon = (JInternalFrame.JDesktopIcon)jComponent;
        this.frame = this.desktopIcon.getInternalFrame();
        this.installDefaults();
        this.installComponents();
        JInternalFrame jInternalFrame = this.desktopIcon.getInternalFrame();
        if (jInternalFrame.isIcon() && jInternalFrame.getParent() == null && (jDesktopPane = this.desktopIcon.getDesktopPane()) != null && (desktopManager = jDesktopPane.getDesktopManager()) instanceof DefaultDesktopManager) {
            desktopManager.iconifyFrame(jInternalFrame);
        }
        this.installListeners();
        JLayeredPane.putLayer(this.desktopIcon, JLayeredPane.getLayer(this.frame));
    }

    public void uninstallUI(JComponent jComponent) {
        DesktopManager desktopManager;
        JDesktopPane jDesktopPane;
        this.uninstallDefaults();
        this.uninstallComponents();
        JInternalFrame jInternalFrame = this.desktopIcon.getInternalFrame();
        if (jInternalFrame.isIcon() && (jDesktopPane = this.desktopIcon.getDesktopPane()) != null && (desktopManager = jDesktopPane.getDesktopManager()) instanceof DefaultDesktopManager) {
            jInternalFrame.putClientProperty("wasIconOnce", null);
            this.desktopIcon.setLocation(Integer.MIN_VALUE, 0);
        }
        this.uninstallListeners();
        this.frame = null;
        this.desktopIcon = null;
    }

    protected void installComponents() {
        this.iconPane = new BasicInternalFrameTitlePane(this.frame);
        this.desktopIcon.setLayout(new BorderLayout());
        this.desktopIcon.add((Component)this.iconPane, "Center");
    }

    protected void uninstallComponents() {
        this.desktopIcon.remove(this.iconPane);
        this.desktopIcon.setLayout(null);
        this.iconPane = null;
    }

    protected void installListeners() {
        this.mouseInputListener = this.createMouseInputListener();
        this.desktopIcon.addMouseMotionListener(this.mouseInputListener);
        this.desktopIcon.addMouseListener(this.mouseInputListener);
    }

    protected void uninstallListeners() {
        this.desktopIcon.removeMouseMotionListener(this.mouseInputListener);
        this.desktopIcon.removeMouseListener(this.mouseInputListener);
        this.mouseInputListener = null;
    }

    protected void installDefaults() {
        LookAndFeel.installBorder(this.desktopIcon, "DesktopIcon.border");
        LookAndFeel.installProperty(this.desktopIcon, "opaque", Boolean.TRUE);
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.desktopIcon);
    }

    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return this.desktopIcon.getLayout().preferredLayoutSize(this.desktopIcon);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = new Dimension(this.iconPane.getMinimumSize());
        Border border = this.frame.getBorder();
        if (border != null) {
            dimension.height += border.getBorderInsets((Component)this.frame).bottom + border.getBorderInsets((Component)this.frame).top;
        }
        return dimension;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.iconPane.getMaximumSize();
    }

    public Insets getInsets(JComponent jComponent) {
        JInternalFrame jInternalFrame = this.desktopIcon.getInternalFrame();
        Border border = jInternalFrame.getBorder();
        if (border != null) {
            return border.getBorderInsets(jInternalFrame);
        }
        return new Insets(0, 0, 0, 0);
    }

    public void deiconize() {
        try {
            this.frame.setIcon(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public class MouseInputHandler
    extends MouseInputAdapter {
        int _x;
        int _y;
        int __x;
        int __y;
        Rectangle startingBounds;

        public void mouseReleased(MouseEvent mouseEvent) {
            this._x = 0;
            this._y = 0;
            this.__x = 0;
            this.__y = 0;
            this.startingBounds = null;
            JDesktopPane jDesktopPane = BasicDesktopIconUI.this.desktopIcon.getDesktopPane();
            if (jDesktopPane != null) {
                DesktopManager desktopManager = jDesktopPane.getDesktopManager();
                desktopManager.endDraggingFrame(BasicDesktopIconUI.this.desktopIcon);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY(), null);
            this.__x = mouseEvent.getX();
            this.__y = mouseEvent.getY();
            this._x = point.x;
            this._y = point.y;
            this.startingBounds = BasicDesktopIconUI.this.desktopIcon.getBounds();
            JDesktopPane jDesktopPane = BasicDesktopIconUI.this.desktopIcon.getDesktopPane();
            if (jDesktopPane != null) {
                DesktopManager desktopManager = jDesktopPane.getDesktopManager();
                desktopManager.beginDraggingFrame(BasicDesktopIconUI.this.desktopIcon);
            }
            try {
                BasicDesktopIconUI.this.frame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            if (BasicDesktopIconUI.this.desktopIcon.getParent() instanceof JLayeredPane) {
                ((JLayeredPane)BasicDesktopIconUI.this.desktopIcon.getParent()).moveToFront(BasicDesktopIconUI.this.desktopIcon);
            }
            if (mouseEvent.getClickCount() > 1 && BasicDesktopIconUI.this.frame.isIconifiable() && BasicDesktopIconUI.this.frame.isIcon()) {
                BasicDesktopIconUI.this.deiconize();
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            JDesktopPane jDesktopPane;
            Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY(), null);
            Insets insets = BasicDesktopIconUI.this.desktopIcon.getInsets();
            int n2 = ((JComponent)BasicDesktopIconUI.this.desktopIcon.getParent()).getWidth();
            int n3 = ((JComponent)BasicDesktopIconUI.this.desktopIcon.getParent()).getHeight();
            if (this.startingBounds == null) {
                return;
            }
            int n4 = this.startingBounds.x - (this._x - point.x);
            int n5 = this.startingBounds.y - (this._y - point.y);
            if (n4 + insets.left <= -this.__x) {
                n4 = -this.__x - insets.left;
            }
            if (n5 + insets.top <= -this.__y) {
                n5 = -this.__y - insets.top;
            }
            if (n4 + this.__x + insets.right > n2) {
                n4 = n2 - this.__x - insets.right;
            }
            if (n5 + this.__y + insets.bottom > n3) {
                n5 = n3 - this.__y - insets.bottom;
            }
            if ((jDesktopPane = BasicDesktopIconUI.this.desktopIcon.getDesktopPane()) != null) {
                DesktopManager desktopManager = jDesktopPane.getDesktopManager();
                desktopManager.dragFrame(BasicDesktopIconUI.this.desktopIcon, n4, n5);
            } else {
                this.moveAndRepaint(BasicDesktopIconUI.this.desktopIcon, n4, n5, BasicDesktopIconUI.this.desktopIcon.getWidth(), BasicDesktopIconUI.this.desktopIcon.getHeight());
            }
        }

        public void moveAndRepaint(JComponent jComponent, int n2, int n3, int n4, int n5) {
            Rectangle rectangle = jComponent.getBounds();
            jComponent.setBounds(n2, n3, n4, n5);
            SwingUtilities.computeUnion(n2, n3, n4, n5, rectangle);
            jComponent.getParent().repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }
}

