/*
 * Decompiled with CFR 0.152.
 */
package java.security.spec;

import java.math.BigInteger;
import java.security.spec.ECField;
import java.util.Arrays;

public class ECFieldF2m
implements ECField {
    private int m;
    private int[] ks;
    private BigInteger rp;

    public ECFieldF2m(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("m is not positive");
        }
        this.m = n2;
        this.ks = null;
        this.rp = null;
    }

    public ECFieldF2m(int n2, BigInteger bigInteger) {
        this.m = n2;
        this.rp = bigInteger;
        if (n2 <= 0) {
            throw new IllegalArgumentException("m is not positive");
        }
        int n3 = this.rp.bitCount();
        if (!this.rp.testBit(0) || !this.rp.testBit(n2) || n3 != 3 && n3 != 5) {
            throw new IllegalArgumentException("rp does not represent a valid reduction polynomial");
        }
        BigInteger bigInteger2 = this.rp.clearBit(0).clearBit(n2);
        this.ks = new int[n3 - 2];
        for (int i2 = this.ks.length - 1; i2 >= 0; --i2) {
            int n4;
            this.ks[i2] = n4 = bigInteger2.getLowestSetBit();
            bigInteger2 = bigInteger2.clearBit(n4);
        }
    }

    public ECFieldF2m(int n2, int[] nArray) {
        int n3;
        this.m = n2;
        this.ks = (int[])nArray.clone();
        if (n2 <= 0) {
            throw new IllegalArgumentException("m is not positive");
        }
        if (this.ks.length != 1 && this.ks.length != 3) {
            throw new IllegalArgumentException("length of ks is neither 1 nor 3");
        }
        for (n3 = 0; n3 < this.ks.length; ++n3) {
            if (this.ks[n3] < 1 || this.ks[n3] > n2 - 1) {
                throw new IllegalArgumentException("ks[" + n3 + "] is out of range");
            }
            if (n3 == 0 || this.ks[n3] < this.ks[n3 - 1]) continue;
            throw new IllegalArgumentException("values in ks are not in descending order");
        }
        this.rp = BigInteger.ONE;
        this.rp = this.rp.setBit(n2);
        for (n3 = 0; n3 < this.ks.length; ++n3) {
            this.rp = this.rp.setBit(this.ks[n3]);
        }
    }

    public int getFieldSize() {
        return this.m;
    }

    public int getM() {
        return this.m;
    }

    public BigInteger getReductionPolynomial() {
        return this.rp;
    }

    public int[] getMidTermsOfReductionPolynomial() {
        if (this.ks == null) {
            return null;
        }
        return (int[])this.ks.clone();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ECFieldF2m) {
            return this.m == ((ECFieldF2m)object).m && Arrays.equals(this.ks, ((ECFieldF2m)object).ks);
        }
        return false;
    }

    public int hashCode() {
        int n2 = this.m << 5;
        return n2 += this.rp == null ? 0 : this.rp.hashCode();
    }
}

