/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;

public final class BandedSampleModel
extends ComponentSampleModel {
    public BandedSampleModel(int n2, int n3, int n4, int n5) {
        super(n2, n3, n4, 1, n3, BandedSampleModel.createIndicesArray(n5), BandedSampleModel.createOffsetArray(n5));
    }

    public BandedSampleModel(int n2, int n3, int n4, int n5, int[] nArray, int[] nArray2) {
        super(n2, n3, n4, 1, n5, nArray, nArray2);
    }

    public SampleModel createCompatibleSampleModel(int n2, int n3) {
        int[] nArray = this.numBanks == 1 ? this.orderBands(this.bandOffsets, n2 * n3) : new int[this.bandOffsets.length];
        BandedSampleModel bandedSampleModel = new BandedSampleModel(this.dataType, n2, n3, n2, this.bankIndices, nArray);
        return bandedSampleModel;
    }

    public SampleModel createSubsetSampleModel(int[] nArray) {
        if (nArray.length > this.bankIndices.length) {
            throw new RasterFormatException("There are only " + this.bankIndices.length + " bands");
        }
        int[] nArray2 = new int[nArray.length];
        int[] nArray3 = new int[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray2[i2] = this.bankIndices[nArray[i2]];
            nArray3[i2] = this.bandOffsets[nArray[i2]];
        }
        return new BandedSampleModel(this.dataType, this.width, this.height, this.scanlineStride, nArray2, nArray3);
    }

    public DataBuffer createDataBuffer() {
        DataBuffer dataBuffer = null;
        int n2 = this.scanlineStride * this.height;
        switch (this.dataType) {
            case 0: {
                dataBuffer = new DataBufferByte(n2, this.numBanks);
                break;
            }
            case 1: {
                dataBuffer = new DataBufferUShort(n2, this.numBanks);
                break;
            }
            case 2: {
                dataBuffer = new DataBufferShort(n2, this.numBanks);
                break;
            }
            case 3: {
                dataBuffer = new DataBufferInt(n2, this.numBanks);
                break;
            }
            case 4: {
                dataBuffer = new DataBufferFloat(n2, this.numBanks);
                break;
            }
            case 5: {
                dataBuffer = new DataBufferDouble(n2, this.numBanks);
                break;
            }
            default: {
                throw new IllegalArgumentException("dataType is not one of the supported types.");
            }
        }
        return dataBuffer;
    }

    public Object getDataElements(int n2, int n3, Object object, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n4 = this.getTransferType();
        int n5 = this.getNumDataElements();
        int n6 = n3 * this.scanlineStride + n2;
        switch (n4) {
            case 0: {
                byte[] byArray = object == null ? new byte[n5] : (byte[])object;
                for (int i2 = 0; i2 < n5; ++i2) {
                    byArray[i2] = (byte)dataBuffer.getElem(this.bankIndices[i2], n6 + this.bandOffsets[i2]);
                }
                object = byArray;
                break;
            }
            case 1: 
            case 2: {
                short[] sArray = object == null ? new short[n5] : (short[])object;
                for (int i3 = 0; i3 < n5; ++i3) {
                    sArray[i3] = (short)dataBuffer.getElem(this.bankIndices[i3], n6 + this.bandOffsets[i3]);
                }
                object = sArray;
                break;
            }
            case 3: {
                int[] nArray = object == null ? new int[n5] : (int[])object;
                for (int i4 = 0; i4 < n5; ++i4) {
                    nArray[i4] = dataBuffer.getElem(this.bankIndices[i4], n6 + this.bandOffsets[i4]);
                }
                object = nArray;
                break;
            }
            case 4: {
                float[] fArray = object == null ? new float[n5] : (float[])object;
                for (int i5 = 0; i5 < n5; ++i5) {
                    fArray[i5] = dataBuffer.getElemFloat(this.bankIndices[i5], n6 + this.bandOffsets[i5]);
                }
                object = fArray;
                break;
            }
            case 5: {
                double[] dArray = object == null ? new double[n5] : (double[])object;
                for (int i6 = 0; i6 < n5; ++i6) {
                    dArray[i6] = dataBuffer.getElemDouble(this.bankIndices[i6], n6 + this.bandOffsets[i6]);
                }
                object = dArray;
            }
        }
        return object;
    }

    public int[] getPixel(int n2, int n3, int[] nArray, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] nArray2 = nArray != null ? nArray : new int[this.numBands];
        int n4 = n3 * this.scanlineStride + n2;
        for (int i2 = 0; i2 < this.numBands; ++i2) {
            nArray2[i2] = dataBuffer.getElem(this.bankIndices[i2], n4 + this.bandOffsets[i2]);
        }
        return nArray2;
    }

    public int[] getPixels(int n2, int n3, int n4, int n5, int[] nArray, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 + n4 > this.width || n3 + n5 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] nArray2 = nArray != null ? nArray : new int[n4 * n5 * this.numBands];
        for (int i2 = 0; i2 < this.numBands; ++i2) {
            int n6 = n3 * this.scanlineStride + n2 + this.bandOffsets[i2];
            int n7 = i2;
            int n8 = this.bankIndices[i2];
            for (int i3 = 0; i3 < n5; ++i3) {
                int n9 = n6;
                for (int i4 = 0; i4 < n4; ++i4) {
                    nArray2[n7] = dataBuffer.getElem(n8, n9++);
                    n7 += this.numBands;
                }
                n6 += this.scanlineStride;
            }
        }
        return nArray2;
    }

    public int getSample(int n2, int n3, int n4, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n5 = dataBuffer.getElem(this.bankIndices[n4], n3 * this.scanlineStride + n2 + this.bandOffsets[n4]);
        return n5;
    }

    public float getSampleFloat(int n2, int n3, int n4, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        float f2 = dataBuffer.getElemFloat(this.bankIndices[n4], n3 * this.scanlineStride + n2 + this.bandOffsets[n4]);
        return f2;
    }

    public double getSampleDouble(int n2, int n3, int n4, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        double d2 = dataBuffer.getElemDouble(this.bankIndices[n4], n3 * this.scanlineStride + n2 + this.bandOffsets[n4]);
        return d2;
    }

    public int[] getSamples(int n2, int n3, int n4, int n5, int n6, int[] nArray, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 + n4 > this.width || n3 + n5 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] nArray2 = nArray != null ? nArray : new int[n4 * n5];
        int n7 = n3 * this.scanlineStride + n2 + this.bandOffsets[n6];
        int n8 = 0;
        int n9 = this.bankIndices[n6];
        for (int i2 = 0; i2 < n5; ++i2) {
            int n10 = n7;
            for (int i3 = 0; i3 < n4; ++i3) {
                nArray2[n8++] = dataBuffer.getElem(n9, n10++);
            }
            n7 += this.scanlineStride;
        }
        return nArray2;
    }

    public void setDataElements(int n2, int n3, Object object, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n4 = this.getTransferType();
        int n5 = this.getNumDataElements();
        int n6 = n3 * this.scanlineStride + n2;
        switch (n4) {
            case 0: {
                byte[] byArray = (byte[])object;
                for (int i2 = 0; i2 < n5; ++i2) {
                    dataBuffer.setElem(this.bankIndices[i2], n6 + this.bandOffsets[i2], byArray[i2] & 0xFF);
                }
                break;
            }
            case 1: 
            case 2: {
                short[] sArray = (short[])object;
                for (int i3 = 0; i3 < n5; ++i3) {
                    dataBuffer.setElem(this.bankIndices[i3], n6 + this.bandOffsets[i3], sArray[i3] & 0xFFFF);
                }
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                for (int i4 = 0; i4 < n5; ++i4) {
                    dataBuffer.setElem(this.bankIndices[i4], n6 + this.bandOffsets[i4], nArray[i4]);
                }
                break;
            }
            case 4: {
                float[] fArray = (float[])object;
                for (int i5 = 0; i5 < n5; ++i5) {
                    dataBuffer.setElemFloat(this.bankIndices[i5], n6 + this.bandOffsets[i5], fArray[i5]);
                }
                break;
            }
            case 5: {
                double[] dArray = (double[])object;
                for (int i6 = 0; i6 < n5; ++i6) {
                    dataBuffer.setElemDouble(this.bankIndices[i6], n6 + this.bandOffsets[i6], dArray[i6]);
                }
                break;
            }
        }
    }

    public void setPixel(int n2, int n3, int[] nArray, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n4 = n3 * this.scanlineStride + n2;
        for (int i2 = 0; i2 < this.numBands; ++i2) {
            dataBuffer.setElem(this.bankIndices[i2], n4 + this.bandOffsets[i2], nArray[i2]);
        }
    }

    public void setPixels(int n2, int n3, int n4, int n5, int[] nArray, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 + n4 > this.width || n3 + n5 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        for (int i2 = 0; i2 < this.numBands; ++i2) {
            int n6 = n3 * this.scanlineStride + n2 + this.bandOffsets[i2];
            int n7 = i2;
            int n8 = this.bankIndices[i2];
            for (int i3 = 0; i3 < n5; ++i3) {
                int n9 = n6;
                for (int i4 = 0; i4 < n4; ++i4) {
                    dataBuffer.setElem(n8, n9++, nArray[n7]);
                    n7 += this.numBands;
                }
                n6 += this.scanlineStride;
            }
        }
    }

    public void setSample(int n2, int n3, int n4, int n5, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        dataBuffer.setElem(this.bankIndices[n4], n3 * this.scanlineStride + n2 + this.bandOffsets[n4], n5);
    }

    public void setSample(int n2, int n3, int n4, float f2, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        dataBuffer.setElemFloat(this.bankIndices[n4], n3 * this.scanlineStride + n2 + this.bandOffsets[n4], f2);
    }

    public void setSample(int n2, int n3, int n4, double d2, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        dataBuffer.setElemDouble(this.bankIndices[n4], n3 * this.scanlineStride + n2 + this.bandOffsets[n4], d2);
    }

    public void setSamples(int n2, int n3, int n4, int n5, int n6, int[] nArray, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 + n4 > this.width || n3 + n5 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n7 = n3 * this.scanlineStride + n2 + this.bandOffsets[n6];
        int n8 = 0;
        int n9 = this.bankIndices[n6];
        for (int i2 = 0; i2 < n5; ++i2) {
            int n10 = n7;
            for (int i3 = 0; i3 < n4; ++i3) {
                dataBuffer.setElem(n9, n10++, nArray[n8++]);
            }
            n7 += this.scanlineStride;
        }
    }

    private static int[] createOffsetArray(int n2) {
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = 0;
        }
        return nArray;
    }

    private static int[] createIndicesArray(int n2) {
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = i2;
        }
        return nArray;
    }

    public int hashCode() {
        return super.hashCode() ^ 2;
    }
}

