/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.Constants;
import com.sun.org.apache.bcel.internal.classfile.Constant;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.ExceptionThrower;
import com.sun.org.apache.bcel.internal.generic.FieldOrMethod;
import com.sun.org.apache.bcel.internal.generic.StackConsumer;
import com.sun.org.apache.bcel.internal.generic.StackProducer;
import com.sun.org.apache.bcel.internal.generic.Type;
import com.sun.org.apache.bcel.internal.generic.TypedInstruction;
import java.util.StringTokenizer;

public abstract class InvokeInstruction
extends FieldOrMethod
implements ExceptionThrower,
TypedInstruction,
StackConsumer,
StackProducer {
    InvokeInstruction() {
    }

    protected InvokeInstruction(short s2, int n2) {
        super(s2, n2);
    }

    public String toString(ConstantPool constantPool) {
        Constant constant = constantPool.getConstant(this.index);
        StringTokenizer stringTokenizer = new StringTokenizer(constantPool.constantToString(constant));
        return Constants.OPCODE_NAMES[this.opcode] + " " + stringTokenizer.nextToken().replace('.', '/') + stringTokenizer.nextToken();
    }

    public int consumeStack(ConstantPoolGen constantPoolGen) {
        String string = this.getSignature(constantPoolGen);
        Type[] typeArray = Type.getArgumentTypes(string);
        int n2 = this.opcode == 184 ? 0 : 1;
        int n3 = typeArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 += typeArray[i2].getSize();
        }
        return n2;
    }

    public int produceStack(ConstantPoolGen constantPoolGen) {
        return this.getReturnType(constantPoolGen).getSize();
    }

    public Type getType(ConstantPoolGen constantPoolGen) {
        return this.getReturnType(constantPoolGen);
    }

    public String getMethodName(ConstantPoolGen constantPoolGen) {
        return this.getName(constantPoolGen);
    }

    public Type getReturnType(ConstantPoolGen constantPoolGen) {
        return Type.getReturnType(this.getSignature(constantPoolGen));
    }

    public Type[] getArgumentTypes(ConstantPoolGen constantPoolGen) {
        return Type.getArgumentTypes(this.getSignature(constantPoolGen));
    }
}

