/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.Constants;
import com.sun.org.apache.bcel.internal.classfile.Constant;
import com.sun.org.apache.bcel.internal.classfile.ConstantCP;
import com.sun.org.apache.bcel.internal.classfile.ConstantClass;
import com.sun.org.apache.bcel.internal.classfile.ConstantDouble;
import com.sun.org.apache.bcel.internal.classfile.ConstantFloat;
import com.sun.org.apache.bcel.internal.classfile.ConstantInteger;
import com.sun.org.apache.bcel.internal.classfile.ConstantLong;
import com.sun.org.apache.bcel.internal.classfile.ConstantNameAndType;
import com.sun.org.apache.bcel.internal.classfile.ConstantString;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.Node;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ConstantPool
implements Cloneable,
Node {
    private int constant_pool_count;
    private Constant[] constant_pool;

    public ConstantPool(Constant[] constantArray) {
        this.setConstantPool(constantArray);
    }

    ConstantPool(DataInputStream dataInputStream) throws IOException, ClassFormatError {
        this.constant_pool_count = dataInputStream.readUnsignedShort();
        this.constant_pool = new Constant[this.constant_pool_count];
        for (int i2 = 1; i2 < this.constant_pool_count; ++i2) {
            this.constant_pool[i2] = Constant.readConstant(dataInputStream);
            byte by = this.constant_pool[i2].getTag();
            if (by != 6 && by != 5) continue;
            ++i2;
        }
    }

    public void accept(Visitor visitor) {
        visitor.visitConstantPool(this);
    }

    public String constantToString(Constant constant) throws ClassFormatError {
        String string;
        byte by = constant.getTag();
        switch (by) {
            case 7: {
                int n2 = ((ConstantClass)constant).getNameIndex();
                constant = this.getConstant(n2, (byte)1);
                string = Utility.compactClassName(((ConstantUtf8)constant).getBytes(), false);
                break;
            }
            case 8: {
                int n3 = ((ConstantString)constant).getStringIndex();
                constant = this.getConstant(n3, (byte)1);
                string = "\"" + ConstantPool.escape(((ConstantUtf8)constant).getBytes()) + "\"";
                break;
            }
            case 1: {
                string = ((ConstantUtf8)constant).getBytes();
                break;
            }
            case 6: {
                string = "" + ((ConstantDouble)constant).getBytes();
                break;
            }
            case 4: {
                string = "" + ((ConstantFloat)constant).getBytes();
                break;
            }
            case 5: {
                string = "" + ((ConstantLong)constant).getBytes();
                break;
            }
            case 3: {
                string = "" + ((ConstantInteger)constant).getBytes();
                break;
            }
            case 12: {
                string = this.constantToString(((ConstantNameAndType)constant).getNameIndex(), (byte)1) + " " + this.constantToString(((ConstantNameAndType)constant).getSignatureIndex(), (byte)1);
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                string = this.constantToString(((ConstantCP)constant).getClassIndex(), (byte)7) + "." + this.constantToString(((ConstantCP)constant).getNameAndTypeIndex(), (byte)12);
                break;
            }
            default: {
                throw new RuntimeException("Unknown constant type " + by);
            }
        }
        return string;
    }

    private static final String escape(String string) {
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2 + 5);
        char[] cArray = string.toCharArray();
        block7: for (int i2 = 0; i2 < n2; ++i2) {
            switch (cArray[i2]) {
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block7;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block7;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block7;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    continue block7;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block7;
                }
                default: {
                    stringBuffer.append(cArray[i2]);
                }
            }
        }
        return stringBuffer.toString();
    }

    public String constantToString(int n2, byte by) throws ClassFormatError {
        Constant constant = this.getConstant(n2, by);
        return this.constantToString(constant);
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.constant_pool_count);
        for (int i2 = 1; i2 < this.constant_pool_count; ++i2) {
            if (this.constant_pool[i2] == null) continue;
            this.constant_pool[i2].dump(dataOutputStream);
        }
    }

    public Constant getConstant(int n2) {
        if (n2 >= this.constant_pool.length || n2 < 0) {
            throw new ClassFormatError("Invalid constant pool reference: " + n2 + ". Constant pool size is: " + this.constant_pool.length);
        }
        return this.constant_pool[n2];
    }

    public Constant getConstant(int n2, byte by) throws ClassFormatError {
        Constant constant = this.getConstant(n2);
        if (constant == null) {
            throw new ClassFormatError("Constant pool at index " + n2 + " is null.");
        }
        if (constant.getTag() == by) {
            return constant;
        }
        throw new ClassFormatError("Expected class `" + Constants.CONSTANT_NAMES[by] + "' at index " + n2 + " and got " + constant);
    }

    public Constant[] getConstantPool() {
        return this.constant_pool;
    }

    public String getConstantString(int n2, byte by) throws ClassFormatError {
        int n3;
        Constant constant = this.getConstant(n2, by);
        switch (by) {
            case 7: {
                n3 = ((ConstantClass)constant).getNameIndex();
                break;
            }
            case 8: {
                n3 = ((ConstantString)constant).getStringIndex();
                break;
            }
            default: {
                throw new RuntimeException("getConstantString called with illegal tag " + by);
            }
        }
        constant = this.getConstant(n3, (byte)1);
        return ((ConstantUtf8)constant).getBytes();
    }

    public int getLength() {
        return this.constant_pool_count;
    }

    public void setConstant(int n2, Constant constant) {
        this.constant_pool[n2] = constant;
    }

    public void setConstantPool(Constant[] constantArray) {
        this.constant_pool = constantArray;
        this.constant_pool_count = constantArray == null ? 0 : constantArray.length;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 1; i2 < this.constant_pool_count; ++i2) {
            stringBuffer.append(i2 + ")" + this.constant_pool[i2] + "\n");
        }
        return stringBuffer.toString();
    }

    public ConstantPool copy() {
        ConstantPool constantPool = null;
        try {
            constantPool = (ConstantPool)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        constantPool.constant_pool = new Constant[this.constant_pool_count];
        for (int i2 = 1; i2 < this.constant_pool_count; ++i2) {
            if (this.constant_pool[i2] == null) continue;
            constantPool.constant_pool[i2] = this.constant_pool[i2].copy();
        }
        return constantPool;
    }
}

