/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.internal;

import com.sun.jmx.remote.internal.ClientListenerInfo;
import com.sun.jmx.remote.internal.ListenerInfo;
import com.sun.jmx.remote.util.ClassLogger;
import com.sun.jmx.remote.util.EnvHelp;
import java.io.IOException;
import java.io.NotSerializableException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.remote.NotificationResult;
import javax.management.remote.TargetedNotification;
import javax.security.auth.Subject;

public abstract class ClientNotifForwarder {
    private static int threadId;
    private final ClassLoader defaultClassLoader;
    private final Executor executor;
    private final HashMap infoList = new HashMap();
    private long clientSequenceNumber = -1L;
    private final int maxNotifications;
    private final long timeout;
    private Integer mbeanRemovedNotifID = null;
    private Thread currentFetchThread;
    private boolean inited = false;
    private static final int STARTING = 0;
    private static final int STARTED = 1;
    private static final int STOPPING = 2;
    private static final int STOPPED = 3;
    private static final int TERMINATED = 4;
    private int state = 3;
    private boolean beingReconnected = false;
    private static final ClassLogger logger;

    public ClientNotifForwarder(Map map) {
        this(null, map);
    }

    public ClientNotifForwarder(ClassLoader classLoader, Map map) {
        this.maxNotifications = EnvHelp.getMaxFetchNotifNumber(map);
        this.timeout = EnvHelp.getFetchTimeout(map);
        Executor executor = (Executor)map.get("jmx.remote.x.fetch.notifications.executor");
        if (executor == null) {
            executor = new LinearExecutor();
        } else if (logger.traceOn()) {
            logger.trace("ClientNotifForwarder", "executor is " + executor);
        }
        this.defaultClassLoader = classLoader;
        this.executor = executor;
    }

    protected abstract NotificationResult fetchNotifs(long var1, int var3, long var4) throws IOException, ClassNotFoundException;

    protected abstract Integer addListenerForMBeanRemovedNotif() throws IOException, InstanceNotFoundException;

    protected abstract void removeListenerForMBeanRemovedNotif(Integer var1) throws IOException, InstanceNotFoundException, ListenerNotFoundException;

    protected abstract void lostNotifs(String var1, long var2);

    public synchronized void addNotificationListener(Integer n2, ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object, Subject subject) throws IOException, InstanceNotFoundException {
        if (logger.traceOn()) {
            logger.trace("addNotificationListener", "Add the listener " + notificationListener + " at " + objectName);
        }
        this.infoList.put(n2, new ClientListenerInfo(n2, objectName, notificationListener, notificationFilter, object, subject));
        this.init(false);
    }

    public synchronized Integer[] removeNotificationListener(ObjectName objectName, NotificationListener notificationListener) throws ListenerNotFoundException, IOException {
        this.beforeRemove();
        if (logger.traceOn()) {
            logger.trace("removeNotificationListener", "Remove the listener " + notificationListener + " from " + objectName);
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList arrayList2 = new ArrayList(this.infoList.values());
        for (int i2 = arrayList2.size() - 1; i2 >= 0; --i2) {
            ClientListenerInfo clientListenerInfo = (ClientListenerInfo)arrayList2.get(i2);
            if (!clientListenerInfo.sameAs(objectName, notificationListener)) continue;
            arrayList.add(clientListenerInfo.getListenerID());
            this.infoList.remove(clientListenerInfo.getListenerID());
        }
        if (arrayList.isEmpty()) {
            throw new ListenerNotFoundException("Listener not found");
        }
        return arrayList.toArray(new Integer[0]);
    }

    public synchronized Integer removeNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws ListenerNotFoundException, IOException {
        if (logger.traceOn()) {
            logger.trace("removeNotificationListener", "Remove the listener " + notificationListener + " from " + objectName);
        }
        this.beforeRemove();
        Integer n2 = null;
        ArrayList arrayList = new ArrayList(this.infoList.values());
        for (int i2 = arrayList.size() - 1; i2 >= 0; --i2) {
            ClientListenerInfo clientListenerInfo = (ClientListenerInfo)arrayList.get(i2);
            if (!clientListenerInfo.sameAs(objectName, notificationListener, notificationFilter, object)) continue;
            n2 = clientListenerInfo.getListenerID();
            this.infoList.remove(n2);
            break;
        }
        if (n2 == null) {
            throw new ListenerNotFoundException("Listener not found");
        }
        return n2;
    }

    public synchronized Integer[] removeNotificationListener(ObjectName objectName) {
        if (logger.traceOn()) {
            logger.trace("removeNotificationListener", "Remove all listeners registered at " + objectName);
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList arrayList2 = new ArrayList(this.infoList.values());
        for (int i2 = arrayList2.size() - 1; i2 >= 0; --i2) {
            ClientListenerInfo clientListenerInfo = (ClientListenerInfo)arrayList2.get(i2);
            if (!clientListenerInfo.sameAs(objectName)) continue;
            arrayList.add(clientListenerInfo.getListenerID());
            this.infoList.remove(clientListenerInfo.getListenerID());
        }
        return arrayList.toArray(new Integer[0]);
    }

    public synchronized ListenerInfo[] getListenerInfo() {
        return this.infoList.values().toArray(new ListenerInfo[0]);
    }

    public synchronized ClientListenerInfo[] preReconnection() throws IOException {
        if (this.state == 4 || this.beingReconnected) {
            throw new IOException("Illegal state.");
        }
        ClientListenerInfo[] clientListenerInfoArray = this.infoList.values().toArray(new ClientListenerInfo[0]);
        this.beingReconnected = true;
        this.infoList.clear();
        if (this.currentFetchThread == Thread.currentThread()) {
            return clientListenerInfoArray;
        }
        while (this.state == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                IOException iOException = new IOException(interruptedException.toString());
                EnvHelp.initCause(iOException, interruptedException);
                throw iOException;
            }
        }
        if (this.state == 1) {
            this.setState(2);
        }
        return clientListenerInfoArray;
    }

    public synchronized void postReconnection(ClientListenerInfo[] clientListenerInfoArray) throws IOException {
        if (this.state == 4) {
            return;
        }
        while (this.state == 2) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                IOException iOException = new IOException(interruptedException.toString());
                EnvHelp.initCause(iOException, interruptedException);
                throw iOException;
            }
        }
        boolean bl2 = logger.traceOn();
        int n2 = clientListenerInfoArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (bl2) {
                logger.trace("addNotificationListeners", "Add a listener at " + clientListenerInfoArray[i2].getListenerID());
            }
            this.infoList.put(clientListenerInfoArray[i2].getListenerID(), clientListenerInfoArray[i2]);
        }
        this.beingReconnected = false;
        this.notifyAll();
        if (this.currentFetchThread == Thread.currentThread()) {
            try {
                this.mbeanRemovedNotifID = this.addListenerForMBeanRemovedNotif();
            }
            catch (Exception exception) {
                if (logger.traceOn()) {
                    logger.trace("init", "Failed to register a listener to the mbean server: the client will not do clean when an MBean is unregistered", exception);
                }
            }
        } else if (clientListenerInfoArray.length > 0) {
            this.init(true);
        } else if (this.infoList.size() > 0) {
            this.init(false);
        }
    }

    public synchronized void terminate() {
        if (this.state == 4) {
            return;
        }
        if (logger.traceOn()) {
            logger.trace("terminate", "Terminating...");
        }
        if (this.state == 1) {
            this.infoList.clear();
        }
        this.setState(4);
    }

    private synchronized void setState(int n2) {
        if (this.state == 4) {
            return;
        }
        this.state = n2;
        this.notifyAll();
    }

    /*
     * Unable to fully structure code
     */
    private synchronized void init(boolean var1_1) throws IOException {
        switch (this.state) {
            case 1: {
                return;
            }
            case 0: {
                return;
            }
            case 4: {
                throw new IOException("The ClientNotifForwarder has been terminated.");
            }
            case 2: {
                if (this.beingReconnected) {
                    return;
                }
                while (this.state == 2) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException var2_2) {
                        var3_6 = new IOException(var2_2.toString());
                        EnvHelp.initCause(var3_6, var2_2);
                        throw var3_6;
                    }
                }
                this.init(var1_1);
                return;
            }
            case 3: {
                if (this.beingReconnected) {
                    return;
                }
                if (ClientNotifForwarder.logger.traceOn()) {
                    ClientNotifForwarder.logger.trace("init", "Initializing...");
                }
                if (!var1_1) {
                    try {
                        var2_3 = this.fetchNotifs(-1L, 0, 0L);
                        this.clientSequenceNumber = var2_3.getNextSequenceNumber();
                    }
                    catch (ClassNotFoundException var2_4) {
                        ClientNotifForwarder.logger.warning("init", "Impossible exception: " + var2_4);
                        ClientNotifForwarder.logger.debug("init", var2_4);
                    }
                }
                try {
                    this.mbeanRemovedNotifID = this.addListenerForMBeanRemovedNotif();
                }
                catch (Exception var2_5) {
                    if (!ClientNotifForwarder.logger.traceOn()) ** GOTO lbl41
                    ClientNotifForwarder.logger.trace("init", "Failed to register a listener to the mbean server: the client will not do clean when an MBean is unregistered", var2_5);
                }
lbl41:
                // 3 sources

                this.setState(0);
                this.executor.execute(new NotifFetcher());
                return;
            }
        }
        throw new IOException("Unknown state.");
    }

    private synchronized void beforeRemove() throws IOException {
        while (this.beingReconnected) {
            if (this.state == 4) {
                throw new IOException("Terminated.");
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                IOException iOException = new IOException(interruptedException.toString());
                EnvHelp.initCause(iOException, interruptedException);
                throw iOException;
            }
        }
        if (this.state == 4) {
            throw new IOException("Terminated.");
        }
    }

    static {
        logger = new ClassLogger("javax.management.remote.misc", "ClientNotifForwarder");
    }

    private static class LinearExecutor
    implements Executor {
        private Runnable command;
        private Thread thread;

        private LinearExecutor() {
        }

        public synchronized void execute(Runnable runnable) {
            if (this.command != null) {
                throw new IllegalArgumentException("More than one command");
            }
            this.command = runnable;
            if (this.thread == null) {
                this.thread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        while (true) {
                            Runnable runnable;
                            LinearExecutor linearExecutor = LinearExecutor.this;
                            synchronized (linearExecutor) {
                                if (LinearExecutor.this.command == null) {
                                    LinearExecutor.this.thread = null;
                                    return;
                                }
                                runnable = LinearExecutor.this.command;
                                LinearExecutor.this.command = null;
                            }
                            runnable.run();
                        }
                    }
                };
                this.thread.setDaemon(true);
                this.thread.setName("ClientNotifForwarder-" + ++threadId);
                this.thread.start();
            }
        }
    }

    private class NotifFetcher
    implements Runnable {
        private NotifFetcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            TargetedNotification[] targetedNotificationArray;
            Object object = ClientNotifForwarder.this;
            synchronized (object) {
                ClientNotifForwarder.this.currentFetchThread = Thread.currentThread();
                if (ClientNotifForwarder.this.state == 0) {
                    ClientNotifForwarder.this.setState(1);
                }
            }
            if (ClientNotifForwarder.this.defaultClassLoader != null) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Thread.currentThread().setContextClassLoader(ClientNotifForwarder.this.defaultClassLoader);
                        return null;
                    }
                });
            }
            object = null;
            if (!this.shouldStop() && (object = this.fetchNotifs()) != null) {
                Integer n2;
                HashMap<Integer, Object> hashMap;
                targetedNotificationArray = ((NotificationResult)object).getTargetedNotifications();
                int n3 = targetedNotificationArray.length;
                long l2 = 0L;
                Object object2 = ClientNotifForwarder.this;
                synchronized (object2) {
                    if (ClientNotifForwarder.this.clientSequenceNumber >= 0L) {
                        l2 = ((NotificationResult)object).getEarliestSequenceNumber() - ClientNotifForwarder.this.clientSequenceNumber;
                    }
                    ClientNotifForwarder.this.clientSequenceNumber = ((NotificationResult)object).getNextSequenceNumber();
                    int n4 = ClientNotifForwarder.this.infoList.size();
                    hashMap = new HashMap<Integer, Object>(n4 > n3 ? n3 : n4);
                    for (int i2 = 0; i2 < n3; ++i2) {
                        Object object3;
                        TargetedNotification targetedNotification = targetedNotificationArray[i2];
                        Integer n5 = targetedNotification.getListenerID();
                        if (!n5.equals(ClientNotifForwarder.this.mbeanRemovedNotifID)) {
                            object3 = (ListenerInfo)ClientNotifForwarder.this.infoList.get(n5);
                            if (object3 == null) continue;
                            hashMap.put(n5, object3);
                            continue;
                        }
                        object3 = targetedNotification.getNotification();
                        if (!(object3 instanceof MBeanServerNotification) || !((Notification)object3).getType().equals("JMX.mbean.unregistered")) continue;
                        MBeanServerNotification mBeanServerNotification = (MBeanServerNotification)object3;
                        ObjectName objectName = mBeanServerNotification.getMBeanName();
                        ClientNotifForwarder.this.removeNotificationListener(objectName);
                    }
                    n2 = ClientNotifForwarder.this.mbeanRemovedNotifID;
                }
                if (l2 > 0L) {
                    object2 = "May have lost up to " + l2 + " notification" + (l2 == 1L ? "" : "s");
                    ClientNotifForwarder.this.lostNotifs((String)object2, l2);
                    logger.trace("NotifFetcher.run", (String)object2);
                }
                for (int i3 = 0; i3 < n3; ++i3) {
                    TargetedNotification targetedNotification = targetedNotificationArray[i3];
                    this.dispatchNotification(targetedNotification, n2, hashMap);
                }
            }
            targetedNotificationArray = ClientNotifForwarder.this;
            synchronized (ClientNotifForwarder.this) {
                ClientNotifForwarder.this.currentFetchThread = null;
                // ** MonitorExit[var2_3] (shouldn't be in output)
                if (object == null || this.shouldStop()) {
                    ClientNotifForwarder.this.setState(3);
                } else {
                    ClientNotifForwarder.this.executor.execute(this);
                }
                return;
            }
        }

        void dispatchNotification(TargetedNotification targetedNotification, Integer n2, Map map) {
            Notification notification = targetedNotification.getNotification();
            Integer n3 = targetedNotification.getListenerID();
            if (n3.equals(n2)) {
                return;
            }
            ClientListenerInfo clientListenerInfo = (ClientListenerInfo)map.get(n3);
            if (clientListenerInfo == null) {
                logger.trace("NotifFetcher.dispatch", "Listener ID not in map");
                return;
            }
            NotificationListener notificationListener = clientListenerInfo.getListener();
            Object object = clientListenerInfo.getHandback();
            try {
                notificationListener.handleNotification(notification, object);
            }
            catch (RuntimeException runtimeException) {
                logger.trace("NotifFetcher-run", "Failed to forward a notification to a listener", runtimeException);
            }
        }

        private NotificationResult fetchNotifs() {
            try {
                NotificationResult notificationResult = ClientNotifForwarder.this.fetchNotifs(ClientNotifForwarder.this.clientSequenceNumber, ClientNotifForwarder.this.maxNotifications, ClientNotifForwarder.this.timeout);
                if (logger.traceOn()) {
                    logger.trace("NotifFetcher-run", "Got notifications from the server: " + notificationResult);
                }
                return notificationResult;
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.trace("NotifFetcher.fetchNotifs", classNotFoundException);
                return this.fetchOneNotif();
            }
            catch (NotSerializableException notSerializableException) {
                logger.trace("NotifFetcher.fetchNotifs", notSerializableException);
                return this.fetchOneNotif();
            }
            catch (IOException iOException) {
                if (!this.shouldStop()) {
                    logger.error("NotifFetcher-run", "Failed to fetch notification, stopping thread. Error is: " + iOException, iOException);
                    logger.debug("NotifFetcher-run", iOException);
                }
                return null;
            }
        }

        private NotificationResult fetchOneNotif() {
            Object object;
            ClientNotifForwarder clientNotifForwarder = ClientNotifForwarder.this;
            long l2 = ClientNotifForwarder.this.clientSequenceNumber;
            int n2 = 0;
            NotificationResult notificationResult = null;
            while (notificationResult == null && !this.shouldStop()) {
                try {
                    object = clientNotifForwarder.fetchNotifs(l2, 0, 0L);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    logger.warning("NotifFetcher.fetchOneNotif", "Impossible exception: " + classNotFoundException);
                    logger.debug("NotifFetcher.fetchOneNotif", classNotFoundException);
                    return null;
                }
                catch (IOException iOException) {
                    if (!this.shouldStop()) {
                        logger.trace("NotifFetcher.fetchOneNotif", iOException);
                    }
                    return null;
                }
                if (this.shouldStop()) {
                    return null;
                }
                l2 = ((NotificationResult)object).getNextSequenceNumber();
                try {
                    notificationResult = clientNotifForwarder.fetchNotifs(l2, 1, 0L);
                }
                catch (Exception exception) {
                    if (exception instanceof ClassNotFoundException || exception instanceof NotSerializableException) {
                        logger.warning("NotifFetcher.fetchOneNotif", "Failed to deserialize a notification: " + exception.toString());
                        if (logger.traceOn()) {
                            logger.trace("NotifFetcher.fetchOneNotif", "Failed to deserialize a notification.", exception);
                        }
                        ++n2;
                        ++l2;
                        continue;
                    }
                    if (!this.shouldStop()) {
                        logger.trace("NotifFetcher.fetchOneNotif", exception);
                    }
                    return null;
                }
            }
            if (n2 > 0) {
                object = "Dropped " + n2 + " notification" + (n2 == 1 ? "" : "s") + " because classes were missing locally";
                ClientNotifForwarder.this.lostNotifs((String)object, n2);
            }
            return notificationResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean shouldStop() {
            ClientNotifForwarder clientNotifForwarder = ClientNotifForwarder.this;
            synchronized (clientNotifForwarder) {
                if (ClientNotifForwarder.this.state != 1) {
                    return true;
                }
                if (ClientNotifForwarder.this.infoList.size() == 0) {
                    ClientNotifForwarder.this.setState(2);
                    return true;
                }
                return false;
            }
        }
    }
}

