/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.WindowsUtils;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;

public class WindowsComboBoxUI
extends BasicComboBoxUI {
    MouseListener rolloverListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsComboBoxUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.comboBox.setRequestFocusEnabled(true);
        if (XPStyle.getXP() != null && this.arrowButton != null) {
            this.rolloverListener = new RolloverListener();
            this.comboBox.addMouseListener(this.rolloverListener);
        }
    }

    public void uninstallUI(JComponent jComponent) {
        if (XPStyle.getXP() != null) {
            this.comboBox.removeMouseListener(this.rolloverListener);
        }
        super.uninstallUI(jComponent);
    }

    public void paintCurrentValue(Graphics graphics, Rectangle rectangle, boolean bl2) {
        if (XPStyle.getXP() != null) {
            rectangle.x += 2;
            rectangle.y += 2;
            rectangle.width -= 3;
            rectangle.height -= 4;
        } else {
            ++rectangle.x;
            ++rectangle.y;
            rectangle.width -= 2;
            rectangle.height -= 2;
        }
        super.paintCurrentValue(graphics, rectangle, bl2);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = super.getPreferredSize(jComponent);
        dimension.width += 4;
        dimension.height += 2;
        if (XPStyle.getXP() != null) {
            dimension.height += 2;
        }
        return dimension;
    }

    protected LayoutManager createLayoutManager() {
        return new BasicComboBoxUI.ComboBoxLayoutManager(){

            public void layoutContainer(Container container) {
                super.layoutContainer(container);
                if (XPStyle.getXP() != null && WindowsComboBoxUI.this.arrowButton != null) {
                    Dimension dimension = container.getSize();
                    Insets insets = WindowsComboBoxUI.this.getInsets();
                    int n2 = ((WindowsComboBoxUI)WindowsComboBoxUI.this).arrowButton.getPreferredSize().width;
                    WindowsComboBoxUI.this.arrowButton.setBounds(WindowsUtils.isLeftToRight((JComboBox)container) ? dimension.width - insets.right - n2 : insets.left, insets.top, n2, dimension.height - insets.top - insets.bottom);
                }
            }
        };
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
    }

    protected ComboPopup createPopup() {
        return super.createPopup();
    }

    protected ComboBoxEditor createEditor() {
        return new WindowsComboBoxEditor();
    }

    protected JButton createArrowButton() {
        if (XPStyle.getXP() != null) {
            return new XPComboBoxButton();
        }
        return super.createArrowButton();
    }

    class RolloverListener
    extends MouseAdapter {
        RolloverListener() {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            ButtonModel buttonModel = null;
            if (WindowsComboBoxUI.this.arrowButton != null) {
                buttonModel = WindowsComboBoxUI.this.arrowButton.getModel();
            }
            if (buttonModel != null) {
                buttonModel.setRollover(true);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            ButtonModel buttonModel = null;
            if (WindowsComboBoxUI.this.arrowButton != null) {
                buttonModel = WindowsComboBoxUI.this.arrowButton.getModel();
            }
            if (buttonModel != null) {
                buttonModel.setRollover(false);
            }
        }
    }

    public static class WindowsComboBoxEditor
    extends BasicComboBoxEditor.UIResource {
        public void setItem(Object object) {
            super.setItem(object);
            if (this.editor.hasFocus()) {
                this.editor.selectAll();
            }
        }
    }

    @Deprecated
    protected class WindowsComboPopup
    extends BasicComboPopup {
        public WindowsComboPopup(JComboBox jComboBox) {
            super(jComboBox);
        }

        protected KeyListener createKeyListener() {
            return new InvocationKeyHandler();
        }

        protected class InvocationKeyHandler
        extends BasicComboPopup.InvocationKeyHandler {
            protected InvocationKeyHandler() {
                super(WindowsComboPopup.this);
            }
        }
    }

    private static class XPComboBoxButton
    extends XPStyle.GlyphButton {
        public XPComboBoxButton() {
            super("combobox.dropdownbutton");
            this.setRequestFocusEnabled(false);
        }

        public Dimension getPreferredSize() {
            return new Dimension(17, 20);
        }
    }
}

