/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.oa.poa;

import com.sun.corba.se.spi.extension.CopyObjectPolicy;
import com.sun.corba.se.spi.extension.ServantCachingPolicy;
import com.sun.corba.se.spi.extension.ZeroPortPolicy;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import org.omg.CORBA.Policy;
import org.omg.PortableServer.IdAssignmentPolicy;
import org.omg.PortableServer.IdUniquenessPolicy;
import org.omg.PortableServer.ImplicitActivationPolicy;
import org.omg.PortableServer.LifespanPolicy;
import org.omg.PortableServer.POAPackage.InvalidPolicy;
import org.omg.PortableServer.RequestProcessingPolicy;
import org.omg.PortableServer.ServantRetentionPolicy;
import org.omg.PortableServer.ThreadPolicy;

public final class Policies {
    private static final int MIN_POA_POLICY_ID = 16;
    private static final int MAX_POA_POLICY_ID = 22;
    private static final int POLICY_TABLE_SIZE = 7;
    int defaultObjectCopierFactoryId;
    private HashMap policyMap = new HashMap();
    public static final Policies defaultPolicies = new Policies();
    public static final Policies rootPOAPolicies = new Policies(0, 0, 0, 1, 0, 0, 0);
    private int[] poaPolicyValues;

    private int getPolicyValue(int n2) {
        return this.poaPolicyValues[n2 - 16];
    }

    private void setPolicyValue(int n2, int n3) {
        this.poaPolicyValues[n2 - 16] = n3;
    }

    private Policies(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.poaPolicyValues = new int[]{n2, n3, n4, n5, n6, n7, n8};
    }

    private Policies() {
        this(0, 0, 0, 1, 1, 0, 0);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Policies[");
        boolean bl2 = true;
        Iterator iterator = this.policyMap.values().iterator();
        while (iterator.hasNext()) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuffer.append(",");
            }
            stringBuffer.append(iterator.next().toString());
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private int getPOAPolicyValue(Policy policy) {
        if (policy instanceof ThreadPolicy) {
            return ((ThreadPolicy)policy).value().value();
        }
        if (policy instanceof LifespanPolicy) {
            return ((LifespanPolicy)policy).value().value();
        }
        if (policy instanceof IdUniquenessPolicy) {
            return ((IdUniquenessPolicy)policy).value().value();
        }
        if (policy instanceof IdAssignmentPolicy) {
            return ((IdAssignmentPolicy)policy).value().value();
        }
        if (policy instanceof ServantRetentionPolicy) {
            return ((ServantRetentionPolicy)policy).value().value();
        }
        if (policy instanceof RequestProcessingPolicy) {
            return ((RequestProcessingPolicy)policy).value().value();
        }
        if (policy instanceof ImplicitActivationPolicy) {
            return ((ImplicitActivationPolicy)policy).value().value();
        }
        return -1;
    }

    private void checkForPolicyError(BitSet bitSet) throws InvalidPolicy {
        for (short s2 = 0; s2 < bitSet.length(); s2 = (short)(s2 + 1)) {
            if (!bitSet.get(s2)) continue;
            throw new InvalidPolicy(s2);
        }
    }

    private void addToErrorSet(Policy[] policyArray, int n2, BitSet bitSet) {
        for (int i2 = 0; i2 < policyArray.length; ++i2) {
            if (policyArray[i2].policy_type() != n2) continue;
            bitSet.set(i2);
            return;
        }
    }

    Policies(Policy[] policyArray, int n2) throws InvalidPolicy {
        this();
        this.defaultObjectCopierFactoryId = n2;
        if (policyArray == null) {
            return;
        }
        BitSet bitSet = new BitSet(policyArray.length);
        for (int n3 = 0; n3 < policyArray.length; n3 = (int)((short)(n3 + 1))) {
            Policy policy = policyArray[n3];
            int n4 = this.getPOAPolicyValue(policy);
            Integer n5 = new Integer(policy.policy_type());
            Policy policy2 = (Policy)this.policyMap.get(n5);
            if (policy2 == null) {
                this.policyMap.put(n5, policy);
            }
            if (n4 < 0) continue;
            this.setPolicyValue(n5, n4);
            if (policy2 == null || this.getPOAPolicyValue(policy2) == n4) continue;
            bitSet.set(n3);
        }
        if (!this.retainServants() && this.useActiveMapOnly()) {
            this.addToErrorSet(policyArray, 21, bitSet);
            this.addToErrorSet(policyArray, 22, bitSet);
        }
        if (this.isImplicitlyActivated()) {
            if (!this.retainServants()) {
                this.addToErrorSet(policyArray, 20, bitSet);
                this.addToErrorSet(policyArray, 21, bitSet);
            }
            if (!this.isSystemAssignedIds()) {
                this.addToErrorSet(policyArray, 20, bitSet);
                this.addToErrorSet(policyArray, 19, bitSet);
            }
        }
        this.checkForPolicyError(bitSet);
    }

    public Policy get_effective_policy(int n2) {
        Integer n3 = new Integer(n2);
        Policy policy = (Policy)this.policyMap.get(n3);
        return policy;
    }

    public final boolean isOrbControlledThreads() {
        return this.getPolicyValue(16) == 0;
    }

    public final boolean isSingleThreaded() {
        return this.getPolicyValue(16) == 1;
    }

    public final boolean isTransient() {
        return this.getPolicyValue(17) == 0;
    }

    public final boolean isPersistent() {
        return this.getPolicyValue(17) == 1;
    }

    public final boolean isUniqueIds() {
        return this.getPolicyValue(18) == 0;
    }

    public final boolean isMultipleIds() {
        return this.getPolicyValue(18) == 1;
    }

    public final boolean isUserAssignedIds() {
        return this.getPolicyValue(19) == 0;
    }

    public final boolean isSystemAssignedIds() {
        return this.getPolicyValue(19) == 1;
    }

    public final boolean retainServants() {
        return this.getPolicyValue(21) == 0;
    }

    public final boolean useActiveMapOnly() {
        return this.getPolicyValue(22) == 0;
    }

    public final boolean useDefaultServant() {
        return this.getPolicyValue(22) == 1;
    }

    public final boolean useServantManager() {
        return this.getPolicyValue(22) == 2;
    }

    public final boolean isImplicitlyActivated() {
        return this.getPolicyValue(20) == 0;
    }

    public final int servantCachingLevel() {
        Integer n2 = new Integer(0x53550000);
        ServantCachingPolicy servantCachingPolicy = (ServantCachingPolicy)this.policyMap.get(n2);
        if (servantCachingPolicy == null) {
            return 0;
        }
        return servantCachingPolicy.getType();
    }

    public final boolean forceZeroPort() {
        Integer n2 = new Integer(1398079489);
        ZeroPortPolicy zeroPortPolicy = (ZeroPortPolicy)this.policyMap.get(n2);
        if (zeroPortPolicy == null) {
            return false;
        }
        return zeroPortPolicy.forceZeroPort();
    }

    public final int getCopierId() {
        Integer n2 = new Integer(1398079490);
        CopyObjectPolicy copyObjectPolicy = (CopyObjectPolicy)this.policyMap.get(n2);
        if (copyObjectPolicy != null) {
            return copyObjectPolicy.getValue();
        }
        return this.defaultObjectCopierFactoryId;
    }
}

