/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.util.nativelib.win32;

import com.zerog.util.nativelib.win32.RegistryJD;
import com.zerog.util.nativelib.win32.Win32Exception;
import java.util.StringTokenizer;

public class Registry {
    public static final int HKEY_CLASSES_ROOT = Integer.MIN_VALUE;
    public static final String HKEY_CLASSES_ROOT_STRING = "HKEY_CLASSES_ROOT";
    public static final int HKEY_CURRENT_USER = -2147483647;
    public static final String HKEY_CURRENT_USER_STRING = "HKEY_CURRENT_USER";
    public static final int HKEY_LOCAL_MACHINE = -2147483646;
    public static final String HKEY_LOCAL_MACHINE_STRING = "HKEY_LOCAL_MACHINE";
    public static final int HKEY_USERS = -2147483645;
    public static final String HKEY_USERS_STRING = "HKEY_USERS";
    public static final int REG_NONE = 0;
    public static final int REG_SZ = 1;
    public static final int REG_EXPAND_SZ = 2;
    public static final int REG_BINARY = 3;
    public static final int REG_DWORD = 4;
    public static final int REG_DWORD_LITTLE_ENDIAN = 4;
    public static final int REG_DWORD_BIG_ENDIAN = 5;
    public static final int REG_LINK = 6;
    public static final int REG_MULTI_SZ = 7;
    public static final int REG_RESOURCE_LIST = 8;
    public static final int REG_FULL_RESOURCE_DESCRIPTOR = 9;
    public static final int REG_RESOURCE_REQUIREMENTS_LIST = 10;
    public static final int KEY_QUERY_VALUE = 1;
    public static final int KEY_SET_VALUE = 2;
    public static final int KEY_CREATE_SUB_KEY = 4;
    public static final int KEY_ENUMERATE_SUB_KEYS = 8;
    public static final int KEY_NOTIFY = 16;
    public static final int KEY_CREATE_LINK = 32;
    public static final int KEY_READ = 131097;
    public static final int KEY_WRITE = 131078;
    public static final int KEY_EXECUTE = 131097;
    public static final int KEY_ALL_ACCESS = 983103;
    private static final int MAX_REG_STRING_LENGTH = 1024;
    private static final int MAX_REG_BINARY_LENGTH = 4096;
    private static boolean useJsDirect = false;

    public static int parseTopKey(String string) throws IllegalArgumentException {
        if (string != null) {
            if (string.toLowerCase().startsWith(HKEY_CLASSES_ROOT_STRING.toLowerCase())) {
                return Integer.MIN_VALUE;
            }
            if (string.toLowerCase().startsWith(HKEY_CURRENT_USER_STRING.toLowerCase())) {
                return -2147483647;
            }
            if (string.toLowerCase().startsWith(HKEY_LOCAL_MACHINE_STRING.toLowerCase())) {
                return -2147483646;
            }
            if (string.toLowerCase().startsWith(HKEY_USERS_STRING.toLowerCase())) {
                return -2147483645;
            }
            throw new IllegalArgumentException("The registry key: " + string + " does not have a valid top level key.");
        }
        throw new IllegalArgumentException("The registry key: null can't be a reg key :(");
    }

    public static int splitKey(String string, String[] stringArray) {
        int n = 0;
        try {
            n = Registry.parseTopKey(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return 0;
        }
        int n2 = string.indexOf(92);
        if (n2 != -1 && n2 + 1 < string.length()) {
            stringArray[0] = string.substring(n2 + 1);
        }
        return n;
    }

    public static int createKey(String string) {
        String[] stringArray = new String[1];
        int n = Registry.splitKey(string, stringArray);
        if (n != 0) {
            return Registry.createSubkey(n, stringArray[0], true);
        }
        return 0;
    }

    public static int openKey(String string, int n) throws Win32Exception {
        String[] stringArray = new String[1];
        int n2 = Registry.splitKey(string, stringArray);
        if (n2 != 0) {
            return Registry.openKey(n2, stringArray[0], n);
        }
        return 0;
    }

    public static int createSubkey(int n, String string, boolean bl) {
        String string2 = ZeroGd.c(string);
        string2 = ZeroGd.e(string2);
        int n2 = 0;
        try {
            int n3 = Registry.openKey(n, "", 983103);
            n2 = Registry.createKey(n3, string2, 983103);
            Registry.closeKey(n3);
            if (!bl) {
                Registry.closeKey(n2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n2;
    }

    public static int countExistingKeySegs(String string) {
        if (string != null && string != "") {
            boolean bl = true;
            int n = 0;
            try {
                n = Registry.parseTopKey(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
                bl = false;
            }
            if (bl) {
                int n2 = string.indexOf(92);
                if (n2 != -1 && n2 + 1 < string.length()) {
                    String string2 = string.substring(n2 + 1);
                    return Registry.countExistingKeySegs(n, string2);
                }
                return 1;
            }
            return 0;
        }
        return 0;
    }

    public static int countExistingKeySegs(int n, String string) {
        int n2 = -1;
        try {
            Registry.openKey(n, "", 983103);
        }
        catch (Exception exception) {
            return n2;
        }
        n2 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\\");
        String string2 = "";
        while (stringTokenizer.hasMoreElements()) {
            string2 = string2 + (String)stringTokenizer.nextElement();
            System.err.println(string2);
            try {
                int n3 = Registry.openKey(n, string2, 131097);
            }
            catch (Exception exception) {
                break;
            }
            string2 = string2 + "\\";
            ++n2;
        }
        return n2;
    }

    public static boolean delKey(int n, String string) {
        try {
            int n2 = Registry.openKey(-2147483647, "TESTTTT\\Tedd\\SomeKeyHuh", 983103);
            Registry.deleteKey(n2, "");
            Registry.closeKey(n2);
        }
        catch (Exception exception) {
            System.err.println("Registry.delKey() failed.  Stack trace: ");
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public static void printSubkeys(int n, String string) {
        int n2 = 0;
        try {
            n2 = Registry.openKey(n, string, 131097);
            int n3 = Registry.queryKeySubKeyCnt(n2);
            System.err.println(n3 + " subkeys: ");
            int n4 = 0;
            while (n4 < n3) {
                System.err.println(Registry.enumKey(n2, n4));
                ++n4;
            }
            Registry.closeKey(n2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void printKeyValues(int n, String string) {
        try {
            int n2 = Registry.openKey(n, string, 131097);
            int n3 = Registry.queryKeyValueCnt(n2);
            System.err.println("Default value:");
            System.err.println("(Default) == \"" + Registry.getKeyValue(n2) + "\"");
            System.err.println(n3 + " values: ");
            int n4 = 0;
            while (n4 < n3) {
                String string2 = Registry.getValueName(n2, n4);
                int n5 = Registry.getValueType(n2, n4);
                switch (n5) {
                    case 0: {
                        System.err.println("\"" + string2 + "\" == " + "(has no value type)");
                        break;
                    }
                    case 1: {
                        System.err.println("\"" + string2 + "\" == \"" + Registry.enumStringValue(n2, n4) + "\" (REG_SZ)");
                        break;
                    }
                    case 2: {
                        System.err.println("\"" + string2 + "\" == \"" + Registry.enumStringValue(n2, n4) + "\" (REG_EXPAND_SZ)");
                        break;
                    }
                    case 3: {
                        System.err.println("\"" + string2 + "\" == \"" + Registry.toString(Registry.enumBinaryValue(n2, n4)) + "\" (REG_BINARY)");
                        break;
                    }
                    case 4: {
                        System.err.println("\"" + string2 + "\" == \"" + Registry.enumIntValue(n2, n4) + "\" (REG_DWORD_LITTLE_ENDIAN)");
                        break;
                    }
                    case 5: {
                        System.err.println("\"" + string2 + "\" == \"" + Registry.enumIntValue(n2, n4) + "\" (REG_DWORD_LITTLE_ENDIAN)");
                        break;
                    }
                    case 6: {
                        System.err.println("\"" + string2 + "\" == " + "(REG_LINK)");
                        break;
                    }
                    case 7: {
                        System.err.println("\"" + string2 + "\" == " + "(REG_MULTI_SZ)");
                        break;
                    }
                    case 8: {
                        System.err.println("\"" + string2 + "\" == " + "(REG_RESOURCE_LIST)");
                        break;
                    }
                    case 9: {
                        System.err.println("\"" + string2 + "\" == " + "(REG_FULL_RESOURCE_DESCRIPTOR)");
                        break;
                    }
                    case 10: {
                        System.err.println("\"" + string2 + "\" == " + "(REG_RESOURCE_REQUIREMENTS_LIST)");
                        break;
                    }
                    default: {
                        System.err.println("\"" + string2 + "\" == " + "(??? unknown type)");
                    }
                }
                ++n4;
            }
            Registry.closeKey(n2);
        }
        catch (Win32Exception win32Exception) {
            win32Exception.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static String toString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(byArray[0]);
        int n = 1;
        while (n < byArray.length) {
            stringBuffer.append(", ");
            stringBuffer.append(byArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static int openKey(int n, String string, int n2) throws Win32Exception {
        if (useJsDirect) {
            int n3 = RegistryJD.openKey(n, string, n2);
            RegistryJD.checkResult();
            return n3;
        }
        return Registry.openKeyJNI(n, string, n2);
    }

    private static native int openKeyJNI(int var0, String var1, int var2) throws Win32Exception;

    public static void closeKey(int n) throws Win32Exception {
        if (useJsDirect) {
            RegistryJD.closeKey(n);
            RegistryJD.checkResult();
        } else {
            Registry.closeKeyJNI(n);
        }
    }

    private static native void closeKeyJNI(int var0) throws Win32Exception;

    public static int createKey(int n, String string, int n2) throws Win32Exception {
        if (useJsDirect) {
            int n3 = RegistryJD.createKey(n, string, n2);
            RegistryJD.checkResult();
            return n3;
        }
        return Registry.createKeyJNI(n, string, n2);
    }

    private static native int createKeyJNI(int var0, String var1, int var2) throws Win32Exception;

    public static void deleteKey(int n, String string) throws Win32Exception {
        if (useJsDirect) {
            RegistryJD.deleteKey(n, string);
            RegistryJD.checkResult();
        } else {
            Registry.deleteKeyJNI(n, string);
        }
    }

    private static native void deleteKeyJNI(int var0, String var1) throws Win32Exception;

    public static void deleteKeyValue(int n, String string) throws Win32Exception {
        if (useJsDirect) {
            RegistryJD.deleteKeyValue(n, string);
            RegistryJD.checkResult();
        } else {
            Registry.deleteKeyValueJNI(n, string);
        }
    }

    private static native void deleteKeyValueJNI(int var0, String var1) throws Win32Exception;

    public static String enumKey(int n, int n2) throws Win32Exception {
        if (useJsDirect) {
            StringBuffer stringBuffer = new StringBuffer(1024);
            RegistryJD.enumKey(n, n2, stringBuffer.capacity(), stringBuffer);
            RegistryJD.checkResult();
            return stringBuffer.toString();
        }
        return Registry.enumKeyJNI(n, n2);
    }

    private static native String enumKeyJNI(int var0, int var1) throws Win32Exception;

    public static int getValueType(int n, int n2) throws Win32Exception {
        if (useJsDirect) {
            int n3 = RegistryJD.getValueType(n, n2);
            RegistryJD.checkResult();
            return n3;
        }
        return Registry.getValueTypeJNI(n, n2);
    }

    private static native int getValueTypeJNI(int var0, int var1) throws Win32Exception;

    public static String getValueName(int n, int n2) throws Win32Exception {
        if (useJsDirect) {
            StringBuffer stringBuffer = new StringBuffer(1024);
            RegistryJD.getValueName(n, n2, stringBuffer.capacity(), stringBuffer);
            RegistryJD.checkResult();
            return stringBuffer.toString();
        }
        return Registry.getValueNameJNI(n, n2);
    }

    private static native String getValueNameJNI(int var0, int var1) throws Win32Exception;

    public static String enumStringValue(int n, int n2) throws Win32Exception {
        if (useJsDirect) {
            StringBuffer stringBuffer = new StringBuffer(1024);
            RegistryJD.enumStringValue(n, n2, stringBuffer.capacity(), stringBuffer);
            RegistryJD.checkResult();
            return stringBuffer.toString();
        }
        return Registry.enumStringValueJNI(n, n2);
    }

    private static native String enumStringValueJNI(int var0, int var1) throws Win32Exception;

    public static int enumIntValue(int n, int n2) throws Win32Exception {
        if (useJsDirect) {
            int n3 = RegistryJD.enumIntValue(n, n2);
            RegistryJD.checkResult();
            return n3;
        }
        return Registry.enumIntValueJNI(n, n2);
    }

    private static native int enumIntValueJNI(int var0, int var1) throws Win32Exception;

    public static byte[] enumBinaryValue(int n, int n2) throws Win32Exception {
        if (useJsDirect) {
            byte[] byArray = new byte[4096];
            RegistryJD.enumBinaryValue(n, n2, byArray.length, byArray);
            RegistryJD.checkResult();
            return byArray;
        }
        return Registry.enumBinaryValueJNI(n, n2);
    }

    private static native byte[] enumBinaryValueJNI(int var0, int var1) throws Win32Exception;

    public static int queryKeySubKeyCnt(int n) throws Win32Exception {
        if (useJsDirect) {
            int n2 = RegistryJD.queryKeySubKeyCnt(n);
            RegistryJD.checkResult();
            return n2;
        }
        return Registry.queryKeySubKeyCntJNI(n);
    }

    private static native int queryKeySubKeyCntJNI(int var0) throws Win32Exception;

    public static int queryKeyValueCnt(int n) throws Win32Exception {
        if (useJsDirect) {
            int n2 = RegistryJD.queryKeyValueCnt(n);
            RegistryJD.checkResult();
            return n2;
        }
        return Registry.queryKeyValueCntJNI(n);
    }

    private static native int queryKeyValueCntJNI(int var0) throws Win32Exception;

    public static String getKeyValue(int n) throws Win32Exception {
        if (useJsDirect) {
            StringBuffer stringBuffer = new StringBuffer(1024);
            RegistryJD.getKeyValue(n, stringBuffer.capacity(), stringBuffer);
            RegistryJD.checkResult();
            return stringBuffer.toString();
        }
        return Registry.getKeyValueJNI(n);
    }

    private static native String getKeyValueJNI(int var0) throws Win32Exception;

    public static void setKeyValue(int n, String string) throws Win32Exception {
        if (useJsDirect) {
            RegistryJD.setKeyValue(n, string);
            RegistryJD.checkResult();
        } else {
            Registry.setKeyValueJNI(n, string);
        }
    }

    private static native void setKeyValueJNI(int var0, String var1) throws Win32Exception;

    public static int getValueType(int n, String string) throws Win32Exception {
        if (useJsDirect) {
            int n2 = RegistryJD.getValueType(n, string);
            RegistryJD.checkResult();
            return n2;
        }
        return Registry.getValueTypeJNI(n, string);
    }

    private static native int getValueTypeJNI(int var0, String var1) throws Win32Exception;

    public static String getStringValue(int n, String string) throws Win32Exception {
        if (useJsDirect) {
            int n2 = 256;
            StringBuffer stringBuffer = new StringBuffer(n2);
            boolean bl = false;
            while (!bl) {
                RegistryJD.getStringValue(n, string, stringBuffer.capacity(), stringBuffer);
                try {
                    RegistryJD.checkResult();
                    bl = true;
                }
                catch (Win32Exception win32Exception) {
                    if (win32Exception.getErrorCode() == 234) {
                        stringBuffer = new StringBuffer(n2 += 64);
                        continue;
                    }
                    throw win32Exception;
                }
            }
            return stringBuffer.toString();
        }
        return Registry.getStringValueJNI(n, string);
    }

    private static native String getStringValueJNI(int var0, String var1) throws Win32Exception;

    public static int getIntValue(int n, String string) throws Win32Exception {
        if (useJsDirect) {
            int n2 = RegistryJD.getIntValue(n, string);
            RegistryJD.checkResult();
            return n2;
        }
        return Registry.getIntValueJNI(n, string);
    }

    private static native int getIntValueJNI(int var0, String var1) throws Win32Exception;

    public static byte[] getBinaryValue(int n, String string) throws Win32Exception {
        if (useJsDirect) {
            byte[] byArray = new byte[4096];
            RegistryJD.getBinaryValue(n, string, byArray.length, byArray);
            RegistryJD.checkResult();
            return byArray;
        }
        return Registry.getBinaryValueJNI(n, string);
    }

    private static native byte[] getBinaryValueJNI(int var0, String var1) throws Win32Exception;

    public static void setValue(int n, String string, String string2) throws Win32Exception {
        int n2 = 1;
        if (Registry.containsWin32EnvironmentVariable(string2)) {
            System.err.println("Registry: Found an Win32 Environment Variable in value, changing type from REG_SZ to REG_EXPAND_SZ");
            n2 = 2;
        }
        if (useJsDirect) {
            RegistryJD.setValueWithType(n, string, string2, n2);
            RegistryJD.checkResult();
        } else {
            Registry.setValueWithTypeJNI(n, string, string2, n2);
        }
    }

    private static native void setValueJNI(int var0, String var1, String var2) throws Win32Exception;

    private static native void setValueWithTypeJNI(int var0, String var1, String var2, int var3) throws Win32Exception;

    public static void setValue(int n, String string, int n2) throws Win32Exception {
        if (useJsDirect) {
            RegistryJD.setValue(n, string, n2);
            RegistryJD.checkResult();
        } else {
            Registry.setValueJNI(n, string, n2);
        }
    }

    private static native void setValueJNI(int var0, String var1, int var2) throws Win32Exception;

    public static void setValue(int n, String string, byte[] byArray) throws Win32Exception {
        if (useJsDirect) {
            RegistryJD.setValue(n, string, byArray.length, byArray);
            RegistryJD.checkResult();
        } else {
            Registry.setValueJNI(n, string, byArray);
        }
    }

    private static native void setValueJNI(int var0, String var1, byte[] var2) throws Win32Exception;

    public static void flushKey(int n) throws Win32Exception {
        if (useJsDirect) {
            RegistryJD.flushKey(n);
            RegistryJD.checkResult();
        } else {
            Registry.flushKeyJNI(n);
        }
    }

    private static native void flushKeyJNI(int var0) throws Win32Exception;

    private static boolean containsWin32EnvironmentVariable(String string) {
        int n;
        int n2 = 37;
        int n3 = string.indexOf(n2);
        if (n3 == -1) {
            return false;
        }
        return n3 >= string.length() - 1 || (n = string.indexOf(n2, n3 + 1)) != -1;
    }

    static {
        if ((ZeroGd.l() & 8) != 0) {
            useJsDirect = true;
        }
    }
}

