/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.installer.si;

import com.zerog.ia.installer.util.VariablePropertyDataIP;
import java.io.File;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SCMPackageSAXReader
extends DefaultHandler {
    private File targetPackage = null;
    private boolean rootIUStarted = false;
    private boolean variablesStarted = false;
    private boolean variableStarted = false;
    private Vector variables = new Vector();
    private Vector features = new Vector();
    private Vector rootFeatures = new Vector();
    private boolean featuresStarted = false;
    private boolean identityOfFeatureStarted = false;
    private boolean nameOfFeatureStarted = false;
    private String featureNameInProgress = "";
    private Vector featuresUnderConstruction = new Vector();
    public static final String packagedIULocation = "meta-inf/packagedIU.xml";

    public SCMPackageSAXReader(File file) {
        this.targetPackage = file;
    }

    private void wipeData() {
        this.rootIUStarted = false;
        this.variablesStarted = false;
        this.variableStarted = false;
        this.variables = new Vector();
        this.features = new Vector();
        this.featuresStarted = false;
        this.rootFeatures = new Vector();
        this.identityOfFeatureStarted = false;
        this.nameOfFeatureStarted = false;
        this.featureNameInProgress = "";
    }

    public void parse() {
        this.wipeData();
        try {
            System.err.println("target zip file exists? : " + this.targetPackage.exists());
            ZipFile zipFile = new ZipFile(this.targetPackage);
            ZipEntry zipEntry = this.findPackagedIU(zipFile);
            System.err.println("entry: " + zipEntry);
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            InputSource inputSource = new InputSource(inputStream);
            SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
            sAXParser.parse(inputSource, (DefaultHandler)this);
            inputStream.close();
            zipFile.close();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if (string3.endsWith("rootIU")) {
            this.rootIUStarted = true;
        }
        if (this.rootIUStarted) {
            VariablePropertyDataIP variablePropertyDataIP;
            if (string3.endsWith("variables")) {
                this.variablesStarted = true;
            }
            if (string3.endsWith("features")) {
                this.featuresStarted = true;
            }
            if (this.variablesStarted && string3.endsWith("variable")) {
                variablePropertyDataIP = new VariablePropertyDataIP();
                variablePropertyDataIP.setPropertyName(attributes.getValue("name"));
                this.variables.addElement(variablePropertyDataIP);
            }
            if (this.variablesStarted && string3.endsWith("parameter")) {
                variablePropertyDataIP = (VariablePropertyDataIP)this.variables.lastElement();
                variablePropertyDataIP.setPropertyValue(attributes.getValue("defaultValue"));
            }
            if (this.featuresStarted && string3.endsWith("feature")) {
                this.addBlankFeatureToBottomOfStack();
            }
            if (this.featuresUnderConstruction.size() > 0 && string3.endsWith("identity")) {
                this.identityOfFeatureStarted = true;
            }
            if (this.featuresUnderConstruction.size() > 0 && string3.equalsIgnoreCase("name")) {
                this.nameOfFeatureStarted = true;
            }
        }
    }

    private void addBlankFeatureToBottomOfStack() {
        ZeroGo2 zeroGo2 = new ZeroGo2("UNDER CONSTRUCTION -- INVALID");
        this.featuresUnderConstruction.addElement(zeroGo2);
    }

    private void removeBottomFeatureFromStackAndHookItUp() {
        ZeroGo2 zeroGo2 = (ZeroGo2)this.featuresUnderConstruction.elementAt(this.featuresUnderConstruction.size() - 1);
        if (this.featuresUnderConstruction.size() == 1) {
            this.rootFeatures.addElement(zeroGo2);
        } else {
            ZeroGo2 zeroGo22 = (ZeroGo2)this.featuresUnderConstruction.elementAt(this.featuresUnderConstruction.size() - 2);
            zeroGo22.a(zeroGo2);
        }
        this.featuresUnderConstruction.removeElement(zeroGo2);
    }

    public void endElement(String string, String string2, String string3) {
        if (string3.endsWith("rootIU")) {
            this.rootIUStarted = false;
        }
        if (this.rootIUStarted) {
            if (string3.endsWith("variables")) {
                this.variablesStarted = false;
            }
            if (string3.endsWith("features")) {
                this.featuresStarted = false;
            }
            if (this.featuresStarted && string3.endsWith("feature")) {
                this.removeBottomFeatureFromStackAndHookItUp();
            }
            if (this.featuresUnderConstruction.size() > 0 && string3.endsWith("identity")) {
                this.identityOfFeatureStarted = false;
            }
            if (this.featuresUnderConstruction.size() > 0 && string3.equalsIgnoreCase("name")) {
                this.features.addElement(this.featureNameInProgress);
                ((ZeroGo2)this.featuresUnderConstruction.elementAt((int)(this.featuresUnderConstruction.size() - 1))).a = this.featureNameInProgress;
                this.featureNameInProgress = "";
                this.nameOfFeatureStarted = false;
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.nameOfFeatureStarted) {
            this.featureNameInProgress = this.featureNameInProgress + new String(cArray, n, n2);
        }
    }

    private void printVariablesAndFeatures() {
        Enumeration enumeration = this.variables.elements();
        while (enumeration.hasMoreElements()) {
            System.err.println("variable: " + enumeration.nextElement());
        }
        enumeration = this.features.elements();
        while (enumeration.hasMoreElements()) {
            System.err.println("feature: " + enumeration.nextElement());
        }
    }

    public static void main(String[] stringArray) {
        String string = "C:/bigblue/tf/eng/spikes/SIRuntimeTests/Packages/HierarchicalFeaturePackage.zip";
        System.err.println("target zip file exists? : " + new File(string).exists());
        SCMPackageSAXReader sCMPackageSAXReader = new SCMPackageSAXReader(new File(string));
        sCMPackageSAXReader.parse();
        sCMPackageSAXReader.printVariablesAndFeatures();
        sCMPackageSAXReader.printRootFeatures();
    }

    public Vector acquireVariablesOnRootUI(boolean bl) {
        this.parse();
        this.printVariablesAndFeatures();
        if (!bl) {
            return this.variables;
        }
        return this.maybeRemoveInstallFolder(this.variables);
    }

    private Vector maybeRemoveInstallFolder(Vector vector) {
        Vector vector2 = (Vector)vector.clone();
        Enumeration enumeration = vector.elements();
        boolean bl = false;
        while (enumeration.hasMoreElements() && !bl) {
            VariablePropertyDataIP variablePropertyDataIP = (VariablePropertyDataIP)enumeration.nextElement();
            if (!variablePropertyDataIP.getPropertyName().equals("InstallFolder")) continue;
            bl = true;
            vector2.removeElement(variablePropertyDataIP);
        }
        return vector2;
    }

    private ZipEntry findPackagedIU(ZipFile zipFile) {
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (!zipEntry.getName().endsWith("packagedIU.xml") || !zipEntry.getName().toLowerCase().startsWith("meta-inf")) continue;
            return zipEntry;
        }
        return null;
    }

    public void printRootFeatures() {
        System.err.println("ROOT FEATURES");
        System.err.println("============");
        Enumeration enumeration = this.rootFeatures.elements();
        while (enumeration.hasMoreElements()) {
            ((ZeroGo2)enumeration.nextElement()).a(0);
        }
    }

    public Vector getRootFeatures() {
        return this.rootFeatures;
    }
}

