/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.installer.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class JarUtil {
    private static Logger log = Logger.getLogger(JarUtil.class.getName());

    public static File getFileFromJar(String fileName, String zipArchive) {
        File tmpFile = null;
        try {
            ZipFile zipFile = new ZipFile(zipArchive);
            ZipEntry entry = null;
            String entryName = null;
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                entry = entries.nextElement();
                entryName = entry.getName();
                System.out.println(entryName);
                if (!entryName.equals(fileName)) continue;
                tmpFile = entryName.lastIndexOf(".") != -1 ? File.createTempFile(entryName.substring(0, entryName.indexOf(".")), null) : File.createTempFile(entryName, null);
                tmpFile = File.createTempFile(entryName, null);
                InputStream in = zipFile.getInputStream(entry);
                FileOutputStream out = new FileOutputStream(tmpFile);
                JarUtil.copyFile(in, out);
                in.close();
                out.close();
                break;
            }
            zipFile.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return tmpFile;
    }

    private static void copyFile(InputStream source, OutputStream dest) throws IOException {
        byte[] buf = new byte[1024];
        int len = 0;
        while ((len = source.read(buf)) > 0) {
            dest.write(buf, 0, len);
            dest.flush();
        }
    }

    public static void copyResource(String resource, String destDir) throws IOException, FileNotFoundException {
        log.info("Copy " + resource + " to " + destDir);
        BufferedInputStream in = new BufferedInputStream(JarUtil.class.getClassLoader().getResourceAsStream(resource));
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(new File(String.valueOf(destDir) + "/" + resource)));
        byte[] buf = new byte[1024];
        int len = 0;
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        out.flush();
        out.close();
        in.close();
    }

    public static final void main(String[] args) {
        File f = JarUtil.getFileFromJar("plugin.xml", "C:/Dorado/owareapps/ngnms/lib/bwanms.jar");
        System.out.println(f.getAbsolutePath());
    }
}

