/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.installer.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.nio.channels.FileChannel;

public class FileOps {
    public static void copy(File from, File to) throws RuntimeException {
        if (from.isDirectory()) {
            if (!to.isDirectory()) {
                FileOps.mkDir(to);
            }
            FileOps.copyDirToDir(from, to);
        } else if (to.isDirectory()) {
            FileOps.copyFileToDir(from, to);
        } else if (from.exists()) {
            FileOps.copyFileToFile(from, to);
        } else {
            throw new RuntimeException("Can't find file " + from.getAbsolutePath());
        }
    }

    public static void copyFileToFile(File from, File to) throws RuntimeException {
        try {
            FileChannel sourceChannel = new FileInputStream(from).getChannel();
            FileChannel targetChannel = new FileOutputStream(to).getChannel();
            sourceChannel.transferTo(0L, sourceChannel.size(), targetChannel);
            sourceChannel.close();
            targetChannel.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Can't copy " + from.getAbsolutePath() + " to " + to.getAbsolutePath());
        }
    }

    public static void copyFileToDir(File from, File to) {
        FileOps.copyFileToFile(from, new File(to, from.getName()));
    }

    public static void copyDirToDir(File from, File to) {
        String[] info = from.list();
        int i = 0;
        while (i < info.length) {
            if (!info[i].equals(".") && !info[i].equals("..")) {
                File n = new File(from, info[i]);
                if (n.isDirectory()) {
                    File t = new File(to, info[i]);
                    FileOps.mkDir(t);
                    FileOps.copyDirToDir(n, t);
                } else {
                    FileOps.copyFileToFile(n, new File(to, info[i]));
                }
            }
            ++i;
        }
    }

    public static boolean mkDir(File f) throws RuntimeException {
        block4: {
            if (!f.isDirectory()) {
                try {
                    if (!f.mkdir()) {
                        throw new RuntimeException("Couldn't create dir " + f.getAbsolutePath());
                    }
                    break block4;
                }
                catch (SecurityException e) {
                    throw new RuntimeException("Couldn't create dir " + f.getAbsolutePath(), e);
                }
            }
            return false;
        }
        return true;
    }

    public static boolean delete(File fileToDel, FilenameFilter filter) {
        if (!fileToDel.isDirectory()) {
            return FileOps.deleteFile(fileToDel);
        }
        File[] dirCt = null;
        dirCt = filter == null ? fileToDel.listFiles() : fileToDel.listFiles(filter);
        int i = 0;
        while (i < dirCt.length) {
            if (dirCt[i].isDirectory()) {
                FileOps.delete(dirCt[i], filter);
            } else {
                FileOps.deleteFile(dirCt[i]);
            }
            ++i;
        }
        return FileOps.deleteEmptyDir(fileToDel);
    }

    public static boolean deleteFile(File fileToDel) {
        if (!fileToDel.delete()) {
            System.err.println("Couldn't delete file " + fileToDel.getAbsolutePath() + ". Probably in use.");
            return false;
        }
        return true;
    }

    public static boolean deleteEmptyDir(File fileToDel) {
        if (!fileToDel.delete()) {
            System.err.println("Couldn't delete dir " + fileToDel.getAbsolutePath() + ". Probably in use or not empty.");
            return false;
        }
        return true;
    }
}

