/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.installer.util;

import com.bwanms.installer.util.JarUtil;
import com.bwanms.installer.util.Version;
import com.zerog.ia.api.pub.FatalInstallException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.logging.Logger;

public class AlvaUtil {
    private static Logger log = Logger.getLogger(AlvaUtil.class.getName());
    public static final String VALID_VERSION_EXPRESSION = "([0-9]+\\.){3}[0-9]+";
    public static Version FIRST_PATCHED_VERSION = new Version("3", "2", "2", "2");

    public static Version getVersion(String prodDir) throws Exception {
        if (prodDir == null || prodDir.length() == 0) {
            log.info("A* not installed");
            throw new Exception("A* not detected at " + prodDir);
        }
        File dir = new File(prodDir = prodDir.replace("\\", "/"));
        if (!dir.isDirectory()) {
            throw new Exception("A* not detected at " + prodDir);
        }
        log.info("PRODUCT DIRECTORY prodDir=" + prodDir);
        String jarFile = "";
        jarFile = String.valueOf(jarFile) + prodDir;
        if (!prodDir.endsWith("/")) {
            jarFile = String.valueOf(jarFile) + "/";
        }
        jarFile = String.valueOf(jarFile) + "owareapps/ngnms/lib/bwanms.jar";
        log.info("bwanms jarFile=" + jarFile);
        File f = JarUtil.getFileFromJar("plugin.xml", jarFile);
        if (f == null || !f.exists()) {
            log.info("Could not detect version plugin.xml file not found");
            throw new FatalInstallException("Could not detect version");
        }
        log.info("unzip plugin.xml to =" + f.getAbsolutePath());
        String versionStr = null;
        BufferedReader reader = new BufferedReader(new FileReader(f));
        String line = null;
        while ((line = reader.readLine()) != null) {
            int startIdx = line.indexOf("version");
            if (startIdx == -1) continue;
            int endIdx = line.indexOf("\"", startIdx + 10);
            versionStr = line.substring(startIdx + 9, endIdx);
            break;
        }
        reader.close();
        if (versionStr != null) {
            log.info("Installed version=\"" + versionStr + "\"");
            return AlvaUtil.parseVersion(versionStr);
        }
        throw new Exception("Invalid version string null");
    }

    public static Version parseVersion(String version) throws Exception {
        if (!version.matches(VALID_VERSION_EXPRESSION)) {
            log.info("Version string not valid : " + version);
            throw new Exception("Version string not valid : " + version);
        }
        String[] tokens = version.split("\\.");
        return new Version(tokens[0], tokens[1], tokens[2], tokens[3]);
    }
}

