/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.installer.components;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import javax.swing.JComponent;

public class WrappingLabel
extends JComponent {
    private FontRenderContext frc;
    private String text;
    private int maxWidth = Integer.MAX_VALUE;
    private boolean antiAliased;
    private Insets insets = new Insets(5, 5, 5, 5);

    public WrappingLabel() {
        this.frc = new FontRenderContext(null, this.antiAliased, false);
    }

    public WrappingLabel(String text) {
        this.text = text;
        this.frc = new FontRenderContext(null, this.antiAliased, false);
        this.firePropertyChange("text", null, text);
    }

    public boolean isAntiAliased() {
        return this.antiAliased;
    }

    public void setAntiAliased(boolean antiAliased) {
        boolean oldVal = this.isAntiAliased();
        this.antiAliased = antiAliased;
        this.frc = new FontRenderContext(null, antiAliased, false);
        this.firePropertyChange("antiAliased", oldVal, antiAliased);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        String oldText = this.getText();
        this.text = text;
        this.firePropertyChange("text", oldText, text);
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(int maxWidth) {
        int oldWidth = this.getMaxWidth();
        this.maxWidth = maxWidth;
        this.firePropertyChange("maxWidth", oldWidth, maxWidth);
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void setInsets(Insets insets) {
        Insets oldInsets = this.getInsets();
        this.insets = insets;
        this.firePropertyChange("insets", oldInsets, insets);
    }

    public Dimension getPreferredSize() {
        return this.computeSize(this.maxWidth);
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paint(g, this.maxWidth);
    }

    private Dimension computeSize(int maxWidth) {
        String labelText = this.getText();
        if (labelText != null && labelText.length() > 0) {
            AttributedString aText = new AttributedString(labelText);
            aText.addAttribute(TextAttribute.FONT, this.getFont());
            int width = maxWidth;
            width = width - this.insets.left - this.insets.right;
            AttributedCharacterIterator paragraph = aText.getIterator();
            LineBreakMeasurer ruler = new LineBreakMeasurer(paragraph, this.frc);
            int pStart = paragraph.getBeginIndex();
            int pEnd = paragraph.getEndIndex();
            float drawY = this.insets.top;
            float max = 0.0f;
            ruler.setPosition(pStart);
            TextLayout nLayout = null;
            while (ruler.getPosition() < pEnd) {
                nLayout = ruler.nextLayout(width);
                drawY += nLayout.getAscent() + nLayout.getDescent() + nLayout.getLeading();
                max = Math.max(max, nLayout.getAdvance());
            }
            return new Dimension((int)Math.floor((float)this.insets.left + max + (float)this.insets.right), (int)Math.floor(drawY + (float)this.insets.bottom));
        }
        return new Dimension(this.insets.left + this.insets.right, this.insets.top + this.insets.bottom);
    }

    private void paint(Graphics g, int maxWidth) {
        Graphics2D g2d = (Graphics2D)g;
        String labelText = this.getText();
        if (labelText != null && labelText.length() > 0) {
            AttributedString aText = new AttributedString(labelText);
            aText.addAttribute(TextAttribute.FONT, this.getFont());
            Dimension compSize = this.getSize();
            if (this.isOpaque()) {
                g2d.setColor(this.getBackground());
                g2d.fillRect(0, 0, compSize.width, compSize.height);
                g2d.setColor(this.getForeground());
            }
            int width = maxWidth;
            width = width - this.insets.left - this.insets.right;
            AttributedCharacterIterator paragraph = aText.getIterator();
            LineBreakMeasurer ruler = new LineBreakMeasurer(paragraph, this.frc);
            int pStart = paragraph.getBeginIndex();
            int pEnd = paragraph.getEndIndex();
            float drawX = this.insets.left;
            float drawY = this.insets.top;
            ruler.setPosition(pStart);
            TextLayout nLayout = null;
            while (ruler.getPosition() < pEnd) {
                nLayout = ruler.nextLayout(width);
                drawX = nLayout.isLeftToRight() ? (float)this.insets.left : (float)width - nLayout.getAdvance();
                nLayout.draw(g2d, drawX, drawY += nLayout.getAscent());
                drawY += nLayout.getDescent() + nLayout.getLeading();
            }
        }
    }
}

