/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.installer.components;

import com.bwanms.installer.components.ValueBean;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class OutputStreamParser
extends Thread {
    public static final String TASK = "TASK:";
    public static final String PROGRESS = "PROG:";
    private final Lock lock = new ReentrantLock();
    private final Condition finished = this.lock.newCondition();
    private InputStream in;
    private boolean done;
    private ValueBean bean;
    private PrintStream logFileOut;

    public OutputStreamParser(InputStream in, ValueBean bean) {
        this.in = in;
        this.done = false;
        this.bean = bean;
    }

    public OutputStreamParser(InputStream in, ValueBean bean, String logFileName) {
        this(in, bean);
        if (logFileName != null && logFileName.length() > 0) {
            try {
                this.logFileOut = new PrintStream(logFileName);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public void await() {
        this.lock.lock();
        try {
            try {
                this.finished.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block29: {
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.in));
            String buf = null;
            try {
                try {
                    while (true) {
                        String[] line;
                        block30: {
                            block28: {
                                block31: {
                                    if ((buf = reader.readLine()) == null) {
                                        reader.close();
                                        break;
                                    }
                                    if (buf.trim().length() == 0) continue;
                                    line = buf.split(" ");
                                    if (line.length < 2) {
                                        this.log(buf);
                                        continue;
                                    }
                                    if (!line[1].equals("INFO")) break block30;
                                    if (line.length <= 2) break block31;
                                    if (line[2].startsWith(TASK)) {
                                        this.bean.setStatus(buf.substring(buf.indexOf(TASK) + TASK.length()).trim());
                                        break block28;
                                    } else if (line[2].startsWith(PROGRESS)) {
                                        try {
                                            int progress = Math.round(Float.parseFloat(line[2].substring(PROGRESS.length())));
                                            this.bean.setProgress(progress);
                                        }
                                        catch (NumberFormatException ex) {
                                            ex.printStackTrace();
                                        }
                                        break block28;
                                    } else {
                                        this.log(buf);
                                    }
                                    break block28;
                                }
                                this.log(buf);
                            }
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            continue;
                        }
                        if (line[1].equals("WARN")) {
                            this.bean.incWarn();
                        } else if (line[1].equals("ERROR")) {
                            this.bean.setErrorTxt(buf.substring(buf.indexOf("ERROR") + "ERROR".length() + 1));
                        }
                        this.log(buf);
                    }
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                    break block29;
                }
            }
            catch (Throwable throwable) {
                this.done = true;
                OutputStreamParser outputStreamParser = this;
                synchronized (outputStreamParser) {
                    this.notifyAll();
                }
                if (this.logFileOut == null) throw throwable;
                this.logFileOut.close();
                throw throwable;
            }
            this.done = true;
            OutputStreamParser outputStreamParser = this;
            synchronized (outputStreamParser) {
                this.notifyAll();
            }
            if (this.logFileOut == null) return;
            this.logFileOut.close();
            return;
        }
        this.done = true;
        OutputStreamParser outputStreamParser = this;
        synchronized (outputStreamParser) {
            this.notifyAll();
        }
        if (this.logFileOut == null) return;
        this.logFileOut.close();
    }

    public boolean isDone() {
        return this.done;
    }

    private void log(String buf) {
        this.bean.setLog(String.valueOf(buf) + "\n");
        if (this.logFileOut != null) {
            this.logFileOut.println(buf);
            this.logFileOut.flush();
        }
    }
}

