/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.installer.components;

import com.bwanms.installer.components.OutputStreamParser;
import com.bwanms.installer.components.ValueBean;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;
import com.zerog.ia.api.pub.CustomCodePanel;
import com.zerog.ia.api.pub.CustomCodePanelProxy;
import com.zerog.ia.api.pub.CustomError;
import com.zerog.ia.api.pub.GUIAccess;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class CommandPanel
extends CustomCodePanel
implements Runnable,
PropertyChangeListener {
    private static Logger log = Logger.getLogger(CommandPanel.class.getName());
    public static final String CMD_STRING_VARIABLE = "$COMMAND_STRING$";
    public static final String CMD_RESULT_VARIABLE = "$COMMAND_RESULT$";
    public static final String CMD_LOG_FILENAME_VARIABLE = "$COMMAND_LOG_FILENAME$";
    public static final String CMD_PANEL_TITLE = "$COMMAND_PANEL_TITLE$";
    public static final String CMD_PANEL_OPTIONS = "$COMMAND_PANEL_OPTIONS$";
    private boolean inited = false;
    private Thread worker = new Thread(this);
    private String command;
    private ValueBean bean;
    private String logFileName;
    boolean running;
    private String title = null;
    private String options;
    private boolean abordOnError = false;
    private JLabel lblOutput;
    private JScrollPane scrollPane1;
    private JTextArea txtOutput;
    private JLabel lblStatus;
    private JLabel lblTxtStatus;
    private JLabel lblProgress;
    private JProgressBar progressBar;

    public void start() {
        this.worker.start();
    }

    public boolean setupUI(CustomCodePanelProxy proxy) {
        if (this.inited) {
            return true;
        }
        this.inited = true;
        this.running = false;
        if (proxy != null) {
            CommandPanel.setCustomCodePanelProxy(proxy);
            this.command = proxy.substitute(CMD_STRING_VARIABLE);
            this.command = CommandPanel.getCmd(this.command);
            log.info("command=" + this.command);
            this.logFileName = proxy.substitute(CMD_LOG_FILENAME_VARIABLE);
            this.title = proxy.substitute(CMD_PANEL_TITLE);
            this.options = proxy.substitute(CMD_PANEL_OPTIONS);
            if (this.options == null) {
                this.options = "";
            }
        } else {
            throw new IllegalArgumentException("Null Proxy - cannot run script");
        }
        this.bean = new ValueBean();
        this.bean.addPropertyChangeListener(this);
        this.initComponents();
        if (this.options.indexOf("show_progress_bar=false") != -1) {
            this.progressBar.setVisible(false);
            this.lblProgress.setVisible(false);
        }
        this.abordOnError = this.options.indexOf("abord_on_error=true") != -1;
        this.enableButtons(false);
        return true;
    }

    public boolean setupUIforTest(String logFileName, String command) {
        if (this.inited) {
            return true;
        }
        this.inited = true;
        this.running = false;
        this.logFileName = logFileName;
        this.command = command;
        this.bean = new ValueBean();
        this.bean.addPropertyChangeListener(this);
        this.initComponents();
        if (this.options.indexOf("show_progress_bar=false") != -1) {
            this.progressBar.setVisible(false);
        }
        return true;
    }

    public void panelIsDisplayed() {
        if (this.canStart()) {
            this.enableButtons(false);
            this.start();
        } else {
            this.enableButtons(true);
        }
    }

    public boolean okToContinue() {
        return !this.running;
    }

    public boolean okToGoPrevious() {
        return false;
    }

    public String getTitle() {
        return this.title != null && this.title.length() > 0 ? this.title : this.command;
    }

    private boolean canStart() {
        return this.worker.getState() == Thread.State.NEW;
    }

    private void enableButtons(boolean enable) {
        if (customCodePanelProxy != null) {
            GUIAccess guiAccess = (GUIAccess)customCodePanelProxy.getService(GUIAccess.class);
            guiAccess.setNextButtonEnabled(enable);
            guiAccess.setPreviousButtonEnabled(false);
            guiAccess.setExitButtonEnabled(enable);
        }
    }

    public static String getCmd(String str) {
        StringBuffer cmd = new StringBuffer();
        StringBuffer var = new StringBuffer();
        char[] c = str.toCharArray();
        boolean inVar = false;
        int i = 0;
        while (i < c.length) {
            if (c[i] == '$') {
                if (inVar) {
                    if (var.length() == 1 && (var.charAt(0) == '/' || var.charAt(0) == '\\')) {
                        cmd.append(File.pathSeparatorChar);
                    } else {
                        String value = customCodePanelProxy.substitute(var.toString());
                        System.out.println("Replace " + var.toString() + " with " + value);
                        if (value == null) {
                            value = "";
                            System.err.println(String.valueOf(var.toString()) + " not found");
                        }
                        cmd.append(value);
                    }
                    var.delete(0, var.length());
                } else {
                    inVar = true;
                }
            } else if (inVar) {
                var.append(c[i]);
            } else {
                cmd.append(c[i]);
            }
            ++i;
        }
        return cmd.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        CustomError err;
        int ev;
        block14: {
            log.info("Starting process : " + this.command);
            this.running = true;
            ev = -1;
            err = (CustomError)customCodePanelProxy.getService(CustomError.class);
            err.setLogDescription(String.valueOf(this.title) + ": " + this.command);
            Frame mainFrame = ((GUIAccess)customCodePanelProxy.getService(GUIAccess.class)).getFrame();
            Runtime rt = Runtime.getRuntime();
            try {
                try {
                    Process p = rt.exec(this.command);
                    OutputStreamParser output = new OutputStreamParser(p.getInputStream(), this.bean, this.logFileName);
                    output.start();
                    try {
                        p.waitFor();
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                    OutputStreamParser outputStreamParser = output;
                    synchronized (outputStreamParser) {
                        try {
                            while (!output.isDone()) {
                                output.wait();
                            }
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    this.bean.setLog("\nPROCESS FINISHED");
                    ev = p.exitValue();
                    if (ev == 0) break block14;
                    err.appendError("Exit value = " + ev, 97);
                    if (this.abordOnError) {
                        JOptionPane.showMessageDialog(mainFrame, "Installation aborted due to error :\n" + this.bean.getErrorTxt(), "Error", 0);
                        CustomCodePanel.customCodePanelProxy.abortInstallation(ev);
                        break block14;
                    }
                    JOptionPane.showMessageDialog(mainFrame, "Process aborted due to error :\n" + this.bean.getErrorTxt(), "Error", 0);
                }
                catch (Exception ex) {
                    err.appendError(ex.getMessage(), 98);
                    JOptionPane.showMessageDialog(mainFrame, "Process aborted due to system error :\n" + ex.getMessage(), "Error", 0);
                }
            }
            finally {
                this.enableButtons(true);
            }
        }
        customCodePanelProxy.setVariable(CMD_RESULT_VARIABLE, ev);
        err.log();
        this.running = false;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if (propName.equals("log")) {
            this.txtOutput.append(this.bean.getLog());
            this.txtOutput.setCaretPosition(this.txtOutput.getText().length());
        } else if (propName.equals("status")) {
            this.lblTxtStatus.setText(this.bean.getStatus());
        } else if (propName.equals("progress")) {
            this.progressBar.setValue(this.bean.getProgress());
        }
    }

    private void initComponents() {
        this.lblOutput = new JLabel();
        this.scrollPane1 = new JScrollPane();
        this.txtOutput = new JTextArea();
        this.lblStatus = new JLabel();
        this.lblTxtStatus = new JLabel();
        this.lblProgress = new JLabel();
        this.progressBar = new JProgressBar();
        CellConstraints cc = new CellConstraints();
        this.setLayout(new FormLayout(new ColumnSpec[]{new ColumnSpec(Sizes.dluX(80)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, Sizes.dluY(100), 1.0), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.lblOutput.setText("Output");
        this.add((Component)this.lblOutput, cc.xywh(1, 1, 3, 1));
        this.txtOutput.setColumns(20);
        this.txtOutput.setRows(10);
        this.txtOutput.setLineWrap(true);
        this.txtOutput.setEditable(false);
        this.scrollPane1.setViewportView(this.txtOutput);
        this.add((Component)this.scrollPane1, cc.xywh(1, 3, 3, 1));
        this.lblStatus.setText("Current task");
        this.add((Component)this.lblStatus, cc.xy(1, 5));
        this.add((Component)this.lblTxtStatus, cc.xy(3, 5));
        this.lblProgress.setText("Progress");
        this.add((Component)this.lblProgress, cc.xy(1, 7));
        this.add((Component)this.progressBar, cc.xy(3, 7));
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("test");
        frame.getRootPane().setLayout(new BorderLayout());
        frame.setBounds(10, 10, 200, 200);
        frame.setVisible(true);
        frame.validate();
        CommandPanel panel = new CommandPanel();
        frame.getRootPane().add(panel);
        panel.setupUI(null);
        panel.start();
    }
}

