/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.installer;

import com.bwanms.installer.util.JarPatcher;
import com.bwanms.installer.util.JarUtil;
import com.bwanms.installer.util.Version;
import com.zerog.ia.api.pub.CustomCodeAction;
import com.zerog.ia.api.pub.FatalInstallException;
import com.zerog.ia.api.pub.InstallException;
import com.zerog.ia.api.pub.InstallerProxy;
import com.zerog.ia.api.pub.UninstallerProxy;
import java.io.IOException;

public class PatchVersionActionStep2
extends CustomCodeAction {
    public String getInstallStatusMessage() {
        return null;
    }

    public String getUninstallStatusMessage() {
        return null;
    }

    public void install(InstallerProxy proxy) throws InstallException {
        String tempDir;
        String prodDir;
        if (proxy != null) {
            prodDir = proxy.substitute("$lax.nl.env.OWARE_USER_ROOT$");
            tempDir = proxy.substitute("$INSTALLER_TEMP_DIR$");
        } else {
            prodDir = "C:/Dorado";
            tempDir = "C:/temp";
        }
        Version version = (Version)proxy.getVariable("$EXISTING_VERSION$");
        if (version == null) {
            throw new FatalInstallException("EXISTING_VERSION variable is null. Could not determine version number");
        }
        String shortVer = String.valueOf(version.tokens[0]) + "." + version.tokens[1];
        try {
            JarUtil.copyResource("migration-files-ngnms-" + shortVer + ".jar", tempDir);
            this.patch(prodDir, tempDir, shortVer);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new FatalInstallException(e.getMessage());
        }
    }

    public void uninstall(UninstallerProxy arg0) throws InstallException {
    }

    private void patch(String prodDir, String tempDir, String shortVer) throws IOException {
        JarPatcher.patchJarFromJar(String.valueOf(prodDir) + "/owareapps/ngnms/lib/bwanms.jar", String.valueOf(tempDir) + "/migration-files-ngnms-" + shortVer + ".jar");
        JarPatcher.patchJarFromJar(String.valueOf(prodDir) + "/oware/jboss-3.2.3/server/oware/deploy/bwanms.sar/lib/dd/bwanms.jar", String.valueOf(tempDir) + "/" + "migration-files-ngnms-" + shortVer + ".jar");
    }
}

