/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.installer;

import com.zerog.ia.api.pub.CustomCodeAction;
import com.zerog.ia.api.pub.InstallException;
import com.zerog.ia.api.pub.InstallerProxy;
import com.zerog.ia.api.pub.UninstallerProxy;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.jdbc.driver.OracleDriver;

public class OracleJDBCTestAction
extends CustomCodeAction {
    public String getInstallStatusMessage() {
        return "";
    }

    public String getUninstallStatusMessage() {
        return "";
    }

    public void install(InstallerProxy ip) throws InstallException {
        String thinDbURL;
        String passwd = ip.substitute("$DB_PARAMS_2$") != null ? ip.substitute("$DB_PARAMS_2$") : "";
        String string = thinDbURL = ip.substitute("$DATABASE_URL_FULL$") != null ? ip.substitute("$DATABASE_URL_FULL$") : "";
        if ("".equals(passwd) || "".equals(thinDbURL)) {
            ip.setVariable("$JDBC_ERROR$", "[OracleJDBCTestAction] At least one Oracle parameter was empty");
            throw new AssertionError((Object)"[OracleJDBCTestAction] At least one Oracle parameter was empty");
        }
        try {
            System.err.println("Using thin driver...");
            this.testConnection(thinDbURL, passwd);
        }
        catch (UnsatisfiedLinkError ex) {
            ex.printStackTrace();
            ip.setVariable("$JDBC_ERROR$", ex.getMessage());
        }
        catch (SQLException ex) {
            int vendorErr = ex.getErrorCode();
            System.err.println("ERROR_CODE=" + vendorErr);
            ex.printStackTrace();
            ip.setVariable("$JDBC_SQL_EXCEPTION$", ex.getMessage());
        }
    }

    private void testConnection(String url, String passwd) throws SQLException {
        System.out.println("Test connection: " + url);
        DriverManager.registerDriver((Driver)new OracleDriver());
        Connection con = DriverManager.getConnection(url, "system", passwd);
        System.out.println("Connection aquired making a test query: \"SELECT sysdate FROM DUAL\"");
        Statement st = con.createStatement();
        ResultSet rs = st.executeQuery("SELECT sysdate FROM DUAL");
        if (rs.next()) {
            System.out.println("Current date from server:");
            Date curDate = rs.getDate(1);
            System.out.println(curDate);
        } else {
            System.out.println("No results from query");
        }
        rs.close();
        st.close();
        con.close();
    }

    public void uninstall(UninstallerProxy up) throws InstallException {
    }
}

