/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.installer;

import com.bwanms.installer.components.CommandPanel;
import com.zerog.ia.api.pub.CustomCodeRule;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Logger;

public class IsServerInstalationRule
extends CustomCodeRule {
    private static Logger log = Logger.getLogger(CommandPanel.class.getName());

    public boolean evaluateRule() {
        boolean unistallPerformed;
        String owareUserRoot = CustomCodeRule.ruleProxy.substitute("$lax.nl.env.OWARE_USER_ROOT$");
        boolean bl = unistallPerformed = CustomCodeRule.ruleProxy.substitute("$UNINSTALL_PERFORMED$") != null && CustomCodeRule.ruleProxy.substitute("$UNINSTALL_PERFORMED$").equals("true");
        if (unistallPerformed) {
            return false;
        }
        File rootDir = new File(owareUserRoot);
        File[] rootDirs = rootDir.listFiles(new FileFilter(){

            public boolean accept(File f) {
                System.err.println("\t" + f.getName());
                return f.isDirectory() && f.getName().startsWith("Uninstall_");
            }
        });
        if (rootDirs.length == 0) {
            CustomCodeRule.ruleProxy.setVariable("$ABORD_INSTALLATION$", "true");
            return false;
        }
        if (rootDirs.length > 1) {
            CustomCodeRule.ruleProxy.setVariable("$ABORD_INSTALLATION$", "true");
            return false;
        }
        File installVarsFile = new File(String.valueOf(owareUserRoot) + "/" + rootDirs[0].getName() + "/installvariables.properties");
        if (!installVarsFile.exists()) {
            CustomCodeRule.ruleProxy.setVariable("$ABORD_INSTALLATION$", "true");
            return false;
        }
        try {
            FileInputStream input = new FileInputStream(installVarsFile);
            Properties installVars = new Properties();
            installVars.load(input);
            String instMode = installVars.getProperty("INSTALLATION_MODE", "");
            log.info("Detected instalation mode : " + instMode);
            if (!instMode.equals("client")) {
                return true;
            }
        }
        catch (FileNotFoundException e) {
            log.severe(e.getMessage());
        }
        catch (IOException e) {
            log.severe(e.getMessage());
        }
        return false;
    }
}

