/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.installer;

import com.bwanms.installer.util.AlvaUtil;
import com.bwanms.installer.util.FileOps;
import com.bwanms.installer.util.Version;
import com.zerog.ia.api.pub.CustomCodeAction;
import com.zerog.ia.api.pub.FatalInstallException;
import com.zerog.ia.api.pub.InstallException;
import com.zerog.ia.api.pub.InstallerProxy;
import com.zerog.ia.api.pub.UninstallerProxy;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Properties;

public class InfrDetectInstalledDDs
extends CustomCodeAction {
    public static final String DD_PROPERTY = "DD";
    public static final String INFRASTRUCTURE_VERSION_PROPERTY = "Infrastructure";

    public String getInstallStatusMessage() {
        return null;
    }

    public String getUninstallStatusMessage() {
        return null;
    }

    public void install(InstallerProxy proxy) throws InstallException {
        try {
            String DD_SEPARATOR = proxy.substitute("$DD_SEPARATOR$");
            File invDir = new File(String.valueOf(proxy.substitute("$lax.nl.env.OWARE_USER_ROOT$")) + "/inventory");
            if (!invDir.isDirectory()) {
                throw new Exception("Can't find the inventory installation folder");
            }
            File prodDir = new File(invDir, "dd");
            if (!prodDir.isDirectory()) {
                throw new Exception("Can't find folder " + prodDir.getAbsolutePath());
            }
            String[] dirList = prodDir.list();
            StringBuffer dds = new StringBuffer();
            StringBuffer ddsCompatible = new StringBuffer();
            Version infrVers = AlvaUtil.parseVersion(proxy.substitute("$backward.compatibility.version$"));
            ArrayList<String> excludeDirs = new ArrayList<String>();
            int i = 0;
            while (i < dirList.length) {
                File ddDir = new File(prodDir, dirList[i]);
                if (ddDir.isDirectory()) {
                    File ddFile = new File(ddDir, "dd.properties");
                    File ddServerDir = new File(ddDir, "server");
                    File ddClientDir = new File(ddDir, "client");
                    File ddSchemaDir = new File(ddDir, "schema");
                    if (ddFile.isFile() && ddServerDir.isDirectory() && ddClientDir.isDirectory() && ddSchemaDir.isDirectory()) {
                        FileInputStream fin = null;
                        try {
                            try {
                                fin = new FileInputStream(ddFile);
                                Properties ddProp = new Properties();
                                ddProp.load(fin);
                                String ddName = ddProp.getProperty(DD_PROPERTY);
                                dds.append(ddName).append(DD_SEPARATOR);
                                Version ddInfrVers = AlvaUtil.parseVersion(ddProp.getProperty(INFRASTRUCTURE_VERSION_PROPERTY));
                                if (infrVers.compareTo(ddInfrVers, 3) <= 0) {
                                    ddsCompatible.append(ddName).append(DD_SEPARATOR);
                                    excludeDirs.add(ddDir.getAbsolutePath());
                                }
                            }
                            catch (Exception exception) {}
                        }
                        finally {
                            if (fin != null) {
                                try {
                                    fin.close();
                                }
                                catch (Exception exception) {}
                            }
                        }
                    }
                }
                ++i;
            }
            proxy.setVariable("$INSTALLED_DEVICE_DRIVERS$", dds.toString());
            proxy.setVariable("$COMPATIBLE_INSTALLED_DEVICE_DRIVERS$", ddsCompatible.toString());
            FileOps.delete(invDir, new ExcludeFolderFilter(excludeDirs.toArray()));
        }
        catch (Exception ex) {
            proxy.setVariable("$INSTALL_ABORT$", "1");
            ex.printStackTrace();
            throw new FatalInstallException(ex.getMessage());
        }
    }

    public void uninstall(UninstallerProxy arg0) throws InstallException {
    }

    class ExcludeFolderFilter
    implements FilenameFilter {
        private Object[] exclFolders;

        public ExcludeFolderFilter(Object[] exclFolders) {
            this.exclFolders = exclFolders;
        }

        public boolean accept(File file, String name) {
            int i = 0;
            while (i < this.exclFolders.length) {
                if (file.getAbsolutePath().startsWith(this.exclFolders[i].toString())) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

