/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.installer;

import com.bwanms.installer.util.FileOps;
import com.zerog.ia.api.pub.CustomCodeAction;
import com.zerog.ia.api.pub.InstallException;
import com.zerog.ia.api.pub.InstallerProxy;
import com.zerog.ia.api.pub.UninstallerProxy;
import java.io.File;
import java.io.FilenameFilter;

public class DeleteFolderAction
extends CustomCodeAction {
    public String getInstallStatusMessage() {
        return "Deleting installed folders";
    }

    public String getUninstallStatusMessage() {
        return "Deleting installed folders";
    }

    public void install(InstallerProxy ip) throws InstallException {
    }

    public void uninstall(UninstallerProxy up) throws InstallException {
        String installDir = up.substitute("$USER_INSTALL_DIR$");
        String prodName = up.substitute("$PRODUCT_NAME$");
        System.err.println("Deletting " + installDir);
        String[] filesToExclude = new String[]{String.valueOf(installDir) + File.separator + "jre", String.valueOf(installDir) + File.separator + "Uninstall_" + prodName, String.valueOf(installDir) + File.separator + "filesystem", String.valueOf(installDir) + File.separator + "inventory", String.valueOf(installDir) + File.separator + "migration"};
        File file = new File(installDir);
        if (file.exists() && file.isDirectory()) {
            DeleteFolderFilter filter = new DeleteFolderFilter(filesToExclude);
            FileOps.delete(file, filter);
        } else {
            System.err.println("The file " + file.getAbsolutePath() + " does not exist or is not a directory.");
        }
    }

    class DeleteFolderFilter
    implements FilenameFilter {
        private String[] exclFolders;

        public DeleteFolderFilter(String[] exclFolders) {
            this.exclFolders = exclFolders;
        }

        public boolean accept(File dir, String name) {
            String path = null;
            int i = 0;
            while (i < this.exclFolders.length) {
                path = String.valueOf(dir.getAbsolutePath()) + File.separator + name;
                if (dir.getAbsolutePath().startsWith(this.exclFolders[i])) {
                    System.err.println("Not deleted: " + path);
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

